#include "AlphaButtonTest.h"

#define IMAGECLASS AlphaButtonImg
#define IMAGEFILE <AlphaButtonTest/AlphaButtonTest.iml>
#include <Draw/iml_source.h>

AlphaButtonTest::AlphaButtonTest()
{
	CtrlLayout(*this, "Window title");
	styleL = ABTStyle2(ABTSTYLE_LEFT_WITH_CIRCLE);
	styleR = ABTStyle(ABTSTYLE_RIGHT_WITH_CIRCLE);
	styleBL= ABTStyle2(ABTSTYLE_RIGHT_EMPTY);
	styleBR= ABTStyle(ABTSTYLE_LEFT_WITH_ROUND_BUTTON);

	backImg.Set( AlphaButtonImg::BACKGROUND);
	L1.SetStyle(styleL);
	L2.SetStyle(styleL);
	L3.SetStyle(styleL);
	R1.SetStyle(styleR);
	R2.SetStyle(styleR);
	R3.SetStyle(styleR);

	prev.SetStyle(styleBL);
	next.SetStyle(styleBR);
}

GUI_APP_MAIN
{
	AlphaButtonTest().Run();
}




Value ABTLook( int skinType, Color circleColor, Image bandImage, Color alphaColor, int alphaValue)
{
	ABT_SideStyle e;
	e.circleColor = circleColor;
	e.bandStyle = bandImage;
	e.skinType = skinType;
	e.alphaColor = alphaColor;
	e.alphaValue = alphaValue;
	return RawToValue(e);
}



Value MyLookFn(Draw& w, const Rect& rect, const Value& v, int op) {
	if( IsTypeRaw<ABT_SideStyle>(v) ) {
		const ABT_SideStyle& e = ValueTo<ABT_SideStyle>(v);
		switch(op)
		{
			case LOOK_MARGINS:
				return Rect(2,2,2,2);
			case LOOK_ISOPAQUE:
				return false;
			case LOOK_PAINT:
				Rect circleRect;
				Rect bandRect;
				switch(e.skinType)
				{
				case ABTSTYLE_RIGHT_WITH_CIRCLE:
					circleRect = Rect( rect.TopLeft(), Point(rect.left+rect.Height(), rect.bottom ));
					bandRect   = Rect( Point(rect.left+(rect.Height()/2),rect.top) , rect.BottomRight() );
					w.DrawImage(bandRect, e.bandStyle );
					w.DrawEllipse(circleRect, e.circleColor);
					break;
				case ABTSTYLE_LEFT_WITH_CIRCLE:
					circleRect = Rect( Point(rect.right-rect.Height(),rect.top) , rect.BottomRight() );
					bandRect   = Rect( rect.TopLeft(), Point(rect.right-(rect.Height()/2), rect.bottom ));
					w.DrawImage(bandRect, e.bandStyle );
					w.DrawEllipse(circleRect, e.circleColor);
					break;
				case ABTSTYLE_LEFT_EMPTY:
					circleRect = Rect( Point(rect.right-rect.Height(),rect.top) , rect.BottomRight() );
					bandRect   = Rect( rect.TopLeft(), Point(rect.right-(rect.Height()/2), rect.bottom ));
					{
						ImageDraw iw(rect.Width(), rect.Height());
						iw.Alpha().DrawRect(bandRect, GrayColor(e.alphaValue));
						iw.Alpha().DrawEllipse(circleRect, GrayColor(e.alphaValue));
						w.DrawImage( rect, iw , e.alphaColor);
					}
					break;
				case ABTSTYLE_RIGHT_EMPTY:
					circleRect = Rect( rect.TopLeft(), Point(rect.left+rect.Height(), rect.bottom ));
					bandRect   = Rect( Point(rect.left+(rect.Height()/2),rect.top) , rect.BottomRight() );
					{
						ImageDraw iw(rect.Width(), rect.Height());
						iw.Alpha().DrawRect(bandRect, GrayColor(e.alphaValue));
						iw.Alpha().DrawEllipse(circleRect, GrayColor(e.alphaValue));
						w.DrawImage( rect, iw , e.alphaColor);
					}
					break;
				case ABTSTYLE_LEFT_WITH_ROUND_BUTTON:
					circleRect = Rect( Point(rect.right-rect.Height(),rect.top) , rect.BottomRight() );
					bandRect   = Rect( rect.TopLeft(), Point(rect.right-(rect.Height()/2), rect.bottom ));
					{
						ImageDraw iw(rect.Width(), rect.Height());
						iw.Alpha().DrawRect(bandRect, GrayColor(e.alphaValue));
						iw.Alpha().DrawEllipse(circleRect, GrayColor(e.alphaValue));
						w.DrawImage( rect, iw , e.alphaColor);
						circleRect.Deflate(6);
						bandRect.Deflate(0, 6);
						bandRect.left = bandRect.left + bandRect.Height()/2;
						w.DrawEllipse(circleRect, e.circleColor );
						w.DrawRect(bandRect, e.circleColor);
						circleRect.OffsetHorz(-bandRect.Width());
						w.DrawEllipse(circleRect, e.circleColor );
					}
					break;
				case ABTSTYLE_RIGHT_WITH_ROUND_BUTTON:
					break;
				default:
					break;
				}
				return 1;
		}
	}
	return Null;
}

INITBLOCK {
	ChLookFn(MyLookFn);
}



Button::Style ABTStyle(int skinNum)
{
	Button::Style s = Button::StyleNormal();
	s.look[0] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE, GrayColor(0), 48 );
	s.look[1] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE, GrayColor(0), 48  );
	s.look[2] = ABTLook( skinNum, White, AlphaButtonImg::WHITE_REFERENCE, White, 255  );
	s.look[3] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE, GrayColor(0), 48  );
	s.textcolor[0] = White;
	s.textcolor[1] = White;
	s.textcolor[2] = Black;
	s.textcolor[3] = White;
	return s;
}

Button::Style ABTStyle2(int skinNum)
{
	Button::Style s = Button::StyleNormal();
	s.look[0] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE_2, GrayColor(43), 47 );
	s.look[1] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE_2, GrayColor(43), 47  );
	s.look[2] = ABTLook( skinNum, White, AlphaButtonImg::WHITE_REFERENCE, White, 255  );
	s.look[3] = ABTLook( skinNum, White, AlphaButtonImg::ALPHA_REFERENCE_2, GrayColor(43), 47  );
	s.textcolor[0] = White;
	s.textcolor[1] = White;
	s.textcolor[2] = Black;
	s.textcolor[3] = White;
	return s;
}
