#include <CtrlLib/CtrlLib.h>

#include "libDB.h"
/*

NAMESPACE_UPP

*/

#ifdef _DEBUG
#include <Sql/sch_schema.h>
#endif

#include <Sql/sch_source.h>
Sqlite3Session lDB;

libDB::libDB()
{
}

libDB::~libDB()
{
	if (lDB.IsOpen()) lDB.Close();
}

void libDB::InitDB()
{
	LOG("Open DB");
	if(!lDB.Open(ConfigFile("libDB.db"))) {
		Exclamation(t_("Cannot create or open libDB database file\n"));
		return;
	}
	LOG("SqlSchema");
	SqlSchema sch(SQLITE3);

//#ifdef _DEBUG
//	pcDB.SetTrace();
//	All_Tables(sch);
//	if(sch.ScriptChanged(SqlSchema::UPGRADE)) {
//		PromptOK("sch : UPGRADE");
//		Sqlite3PerformScript(sch.Upgrade());
//	}
//	if(sch.ScriptChanged(SqlSchema::ATTRIBUTES)) {
//		PromptOK("sch : ATTRIBUTES");
//		Sqlite3PerformScript(sch.Attributes());
//	}
//	if(sch.ScriptChanged(SqlSchema::CONFIG)) {
//		PromptOK("sch : CONFIG");
//		Sqlite3PerformScript(sch.ConfigDrop());
//		Sqlite3PerformScript(sch.Config());
//	}
//	sch.SaveNormal();
//	pcDB.SetTrace();
//    // Get the list of tables    
//    Vector<String> table_list = pcDB.EnumTables("");
//    LOG(Format("Tables: (%d)",table_list.GetCount()));
//    for (int i = 0; i < table_list.GetCount(); ++i)
//        LOG(Format("  #%d: %s",i+1,table_list[i]));
//
//#else
//	All_Tables(sch);
//#endif
	LOG("SetTrace");
	lDB.SetTrace();
	LOG("All_Tables");
	All_Tables(sch);
	LOG("Upgrade");
	Sqlite3PerformScript(sch.Upgrade());
	LOG("Attributes");
	Sqlite3PerformScript(sch.Attributes());
	LOG("ConfigDrop");
	Sqlite3PerformScript(sch.ConfigDrop());
	LOG("Config");
	Sqlite3PerformScript(sch.Config());
	LOG("SaveNormal");
	sch.SaveNormal();
	LOG("SetTrace");
	lDB.SetTrace();
    // Get the list of tables    
	LOG("Liste des tables");
    Vector<String> table_list = lDB.EnumTables("");
    LOG(Format("Tables: (%d)",table_list.GetCount()));
    for (int i = 0; i < table_list.GetCount(); ++i)
        LOG(Format("  #%d: %s",i+1,table_list[i]));
}
