#include <CtrlLib/CtrlLib.h>
#include <Painter/Painter.h>

using namespace Upp;

#define LAYOUTFILE <Transformations/Transformations.lay>
#include <CtrlCore/lay.h>

class Transformations : public WithTransformationsLayout<TopWindow>
{
	public:
		typedef Transformations CLASSNAME;
		Transformations();
		void PaintImage(PaintingPainter &painter);
		void Paint1(PaintingPainter &painter, Color const &c);
		void Paint2(PaintingPainter &painter, Color const &c);
};

// this one draws a line around point 2000, 2000
// at an angle of 45° just to show transformations
void Transformations::PaintImage(PaintingPainter &painter)
{
	Pointf center(2000, 2000);
	Pointf p1(center.x - 100, center.y - 100);
	Pointf p2(center.x + 100, center.y + 100);

	painter.Move(p1);
	painter.Line(p2);
	painter.Stroke(1, Black());
}

// this one do transformation using discrete operations
void Transformations::Paint1(PaintingPainter &painter, Color const &c)
{
	// center of drawing
	Pointf center(2000, 2000);
	
	// size of image control, to center on it
	Size sz = imageCtrl1.GetSize();
	
	// 2 points around center, forming a line at 45°
	double angle = -45.0 * M_PI / 180;
	
	// move origin to center point and rotate of 45°
	painter.Translate(-center);
	painter.Rotate(-angle);
	painter.Translate(sz.cx / 2, sz.cy / 2);

	// paint the image -- this should give an horizontal line
	// centered around ImageCtrl center
	PaintImage(painter);

	// reset back painter transformation
	painter.Translate(-sz.cx / 2, -sz.cy / 2);
	painter.Rotate(angle);
	painter.Translate(center);
}

// this one do transformation using matrices
void Transformations::Paint2(PaintingPainter &painter, Color const &c)
{
	// center of drawing
	Pointf center(2000, 2000);
	
	// size of image control, to center on it
	Size sz = imageCtrl1.GetSize();
	
	// 2 points around center, forming a line at 45°
	double angle = -45.0 * M_PI / 180;
	
	// forward transformation matrix
	Xform2D trsf;
	trsf = Xform2D::Translation(-center.x, -center.y);
	trsf = trsf * Xform2D::Rotation(angle);
	trsf = trsf * Xform2D::Translation(sz.cx / 2, sz.cy / 2);
	
	// transform forward
	painter.Transform(trsf);
	
	// paint the image -- this should give an horizontal line
	// centered around ImageCtrl center
	PaintImage(painter);
	
	// invert transformation
	trsf = Inverse(trsf);
	painter.Transform(trsf);
}

Transformations::Transformations()
{
	CtrlLayout(*this, "Window title");
	
	// initialize a couple of identical painter2 reversing y axis
	// to have origin at bottom/left and y axis growing upwards
	Size sz = imageCtrl1.GetSize();

	PaintingPainter painter1(sz);
	painter1.Scale(1, -1);
	painter1.Translate(0, -sz.cy);
	painter1.Rectangle(0, 0, sz.cx, sz.cy);
	painter1.Stroke(1, White());
	painter1.Fill(White());

	PaintingPainter painter2(sz);
	painter2.Scale(1, -1);
	painter2.Translate(0, -sz.cy);
	painter2.Rectangle(0, 0, sz.cx, sz.cy);
	painter2.Stroke(1, White());
	painter2.Fill(White());

	// both following calls should bring the same drawing

	// use first translaton way (discrete ops), red color	
	Paint1(painter1, Red());
	painter1.Circle(sz.cx / 2, sz.cy / 2, 10);
	painter1.Stroke(1, Black());
	ImageDraw dw1(sz);
	dw1.DrawPainting(0, 0, sz.cx, sz.cy, painter1);
	imageCtrl1.SetImage(dw1);
	
	// use second translation way (matrix ops), green color
	Paint2(painter2, Green());
	painter2.Circle(sz.cx / 2, sz.cy / 2, 10);
	painter2.Stroke(1, Black());
	ImageDraw dw2(sz);
	dw2.DrawPainting(0, 0, sz.cx, sz.cy, painter2);
	imageCtrl2.SetImage(dw2);
}

GUI_APP_MAIN
{
	Transformations().Run();
}
