#include <CtrlLib/CtrlLib.h>
#include <TabBar/TabBar.h>
#include <GridCtrl/GridCtrl.h>

using namespace Upp;

class MyApp : public TopWindow {
public:
	MyApp();

	void ReportSaleInvoiceList();
	typedef MyApp CLASSNAME;

private:
	MenuBar menu;
	TabBarCtrl clients;
	StatusBar status;
	Array<Ctrl> childs;

	void MenuMain(Bar& b);
	void MenuReportSale(Bar& b);
	

	
};

GUI_APP_MAIN
{
	::SetLanguage(LNGC_('E','N','U','S',CHARSET_UTF8));
	MyApp a;
	a.ReportSaleInvoiceList();
	a.Run();
}


MyApp::MyApp()
{
	AddFrame(menu).AddFrame(status).AddFrame(InsetFrame()).Add(clients);
	menu.Set( THISBACK(MenuMain) );
	clients.SizePos();
	clients.StyleDefault().Write().Variant1Crosses();
	Sizeable().Zoomable().Title(t_("Test Grid Summary")).Maximize();
}

void MyApp::MenuMain(Bar& b)
{
	b.Add(t_("Report"), THISBACK(MenuReportSale));
}

void MyApp::MenuReportSale(Bar& b)
{
	b.Add(t_("Sale Invoice List"), THISBACK(ReportSaleInvoiceList));
}


#define LAYOUTFILE <TestGridSummary/SaleInvoiceList.lay>
#include <CtrlCore/lay.h>

class SaleInvoiceListTab : public WithSaleInvoiceListLayout<ParentCtrl>
{
public:
	SaleInvoiceListTab();

	virtual void Paint(Draw& w);

private:
	void RefreshReport();
	
	void SetGridColumns();

	
	typedef SaleInvoiceListTab CLASSNAME;

};

void MyApp::ReportSaleInvoiceList()
{
	clients.AddCtrl(
		childs.Create<SaleInvoiceListTab>(),
	 	1, "Sales Invoice List",
	 	Null, "Sale", true
	);
}


SaleInvoiceListTab::SaleInvoiceListTab()
{
	CtrlLayout(*this);
	refresh<<=THISBACK(RefreshReport);
	//RefreshReport();
}
void SaleInvoiceListTab::Paint(Draw& w)
{
	Rect r(GetSize());
	r.top+=companyName.GetRect().top-4;
	w.DrawRect(r, SColorPaper());
}

// to provide test data
//
Vector<Vector<Value>> GetSaleInvoiceList()
{
	Vector<Vector<Value>> vvv;
	Vector<Value> vv;
	
	vv<<GetSysDate()<<1<<"ABC Company"<<"Sales"<<100.<<0.<<14.<<114.;
	for(int i=0; i<40; ++i)
	{
		vvv<<vv;
		vv[1]=(int)vv[1]+1;
		vv[4]=(double)vv[4]+.1;
		vv[6]=(double)vv[6]+.01;
		vv[7]=(double)vv[7]+.11;
	}
	return vvv;
}

void SaleInvoiceListTab::RefreshReport()
{
	Vector<Vector<Value>> vvv=GetSaleInvoiceList();
	
	grid.Clear(true);
	SetGridColumns();
	for(int i=0; i<vvv.GetCount();++i)
		grid.Add(vvv[i]);
	//grid.UpdateSummary();
}

void SaleInvoiceListTab::SetGridColumns()
{
	#define _f(x) x

	grid.Ready(false);
	grid.Clear(true);
	grid.SummaryRow();
	grid.AddColumn(t_("Date"),10).SetHeaderFont(StdFont().Bold());
	grid.AddColumn(t_("Invoice"),10).SetHeaderFont(StdFont().Bold());
	grid.AddColumn(t_("Customer"),25).SetHeaderFont(StdFont().Bold());
	grid.AddColumn(t_("Description"),30).SetHeaderFont(StdFont().Bold());
	grid.AddColumn(t_("Amount"),10).HeaderAlignCenterRight()
		.AlignCenterRight().SetHeaderFont(StdFont().Bold())
		.DoSum(_f("%nl"));

	grid.AddColumn("Tax1",8)
			.AlignCenterRight().AlignCenterRight()
			.HeaderAlignCenterRight()
			.SetHeaderFont(StdFont().Bold()).DoSum(_f("%nl"));
	grid.AddColumn("Tax2",8)
			.AlignCenterRight().AlignCenterRight()
			.HeaderAlignCenterRight()
			.SetHeaderFont(StdFont().Bold()).DoSum(_f("%nl"));
	grid.AddColumn(t_("Total"),10).HeaderAlignCenterRight()
		.SetHeaderFont(StdFont().Bold())
		.AlignCenterRight().DoSum(_f("%nl"));
	grid.Ready(true);
	grid.HorzGrid(false).VertGrid(false);
	
	#undef _f
}
