#!/bin/bash
set -ex

echo "Running $0"

# read configuration file
if [ -f "$1" ]; then
	. "$1"
else
	echo "Usage: $0 <config_file>"
	exit 1
fi

# create temporary directory
TMP="$(mktemp -d --tmpdir upp2deb.XXXX)"
mkdir "$TMP/debian"

# create debian/rules
cat > "$TMP/debian/rules" <<EOF
#!/usr/bin/make -f
%:
	dh \$@
EOF

# create debian/changelog
cat > "$TMP/debian/changelog" <<-EOF
$PKGNAME ($VERSION) unknown; urgency=low
  * new version
 -- $MAINTAINER  $(date -R)
EOF

# create debian/control
cat > "$TMP/debian/control" <<EOF
Source: $PKGNAME
Maintainer: $MAINTAINER
Section: devel
Priority: low

Package: $PKGNAME
Architecture: any
Depends:  \${shlibs:Depends}, \${misc:Depends}, $DEPENDS
Description: $SHORTDESCRIPTION
 $LONGDESCRIPTION
EOF

# create debian/compat
echo "7" > "$TMP/debian/compat"

# create simple Makefile
cat > "$TMP/Makefile" <<EOF
build:
	umk $ASSEMBLY $PKG $BUILDOPT $TMP/$EXECUTABLE
install: build
	install -D $TMP/$EXECUTABLE \$(DESTDIR)/usr/bin/$EXECUTABLE
EOF

#additional files
add_files() {
	echo "args:$@"
	echo "argc:$#"
	while [ $# -ge 2 ]; do
		echo "	install -D $1 \$(DESTDIR)$2" >> $TMP/Makefile
		shift 2
	done
}
add_files ${FILES[@]}

# build the package
(cd $TMP && dpkg-buildpackage -b)
set -x
ls /tmp
# move the package to the output outputdir
mkdir -p $OUTPUTDIR
mv /tmp/${PKGNAME}_${VERSION}_* $OUTPUTDIR/

# clean up
rm -rf $TMP
