#include "BarCode.h"
using namespace Upp;

class E13p:protected EAN
{
public:
	struct DrawInfo
	{
		Draw& draw;
		int left;
		int width;
		Size textSize;
		Upp::Font digitFont; // font to draw the digits
		// above to be filled and fed to Render;
		// below will be used internally by Render;
		int digitY; // the y coordinate of digits
		int guardCY; // the height of the guard bar;
		int regularCY; // the height of regular bar;
		int actualType; // actual variant type(eg. EAN13, UPCA)
		DrawInfo(Draw& w, int left)
			: draw(w), left(left)
		{}
	};

	void Render(Draw& draw, E13p::DrawInfo& di);

	bool IsEmpty()const{ return ___[0]=='\0';}

	int dcnlz()const; // digits count without leading zero
private:

	//static int stroke[10][4];	
	void DrawBar(DrawInfo& di, int width, int height);
	// start /end guard
	inline void Draw101(DrawInfo& di, int h){
		DrawBar(di, 1, h);
		DrawBar(di, 1, 0);
		DrawBar(di, 1, h);
	}
	// this is the guard in the middle
	inline void Draw01010(DrawInfo& di, int h){
		DrawBar(di, 1, 0);
		DrawBar(di, 1, h);
		DrawBar(di, 1, 0);
		DrawBar(di, 1, h);
		DrawBar(di, 1, 0);
	}
	void DrawDigit(DrawInfo& di, int index, int lgr);
	
	inline int digit(int i)const{ return ___[i]-'0'; }
	
	void DrawEAN8Left(DrawInfo& di);
	void DrawEAN13orUPCALeft(DrawInfo& di);
	void DrawEAN8Right(DrawInfo& di);
	void DrawEAN13orUPCARight(DrawInfo& di);
	

};
static int lg[10][6]={
	//0 	LLLLLL 	RRRRRR
	{0,0,0,0,0,0},
	//1 	LLGLGG 	RRRRRR
	{0,0,1,0,1,1},
	//2 	LLGGLG 	RRRRRR
	{0,0,1,1,0,1},
	//3 	LLGGGL 	RRRRRR
	{0,0,1,1,1,0},
	//4 	LGLLGG 	RRRRRR
	{0,1,0,0,1,1},
	//5 	LGGLLG 	RRRRRR
	{0,1,1,0,0,1},
	//6 	LGGGLL 	RRRRRR
	{0,1,1,1,0,0},
	//7 	LGLGLG 	RRRRRR
	{0,1,0,1,0,1},
	//8 	LGLGGL 	RRRRRR
	{0,1,0,1,1,0},
	//9 	LGGLGL 	RRRRRR}
	{0,1,1,0,1,0}
};

void E13p::Render(Draw& draw, E13p::DrawInfo& di)
{
	ASSERT(noQuietZone<2);
	di.actualType=ActualType();
	di.left=(noQuietZone==1?6:9)*unitWidth;
	if(di.textSize.cx>BarcodeWidth())
		di.left+=(di.textSize.cx-BarcodeWidth())/2;
	
	di.digitY=	height-di.digitFont.GetHeight()-2*unitWidth;
	di.guardCY= di.digitY+6*unitWidth;
	di.regularCY=di.guardCY-5*unitWidth;

	draw.DrawText(di.left-(noQuietZone==1?6:9)*unitWidth,
		di.digitY,
		String().Cat()
			<<( di.actualType==EAN8?'<':
			  		di.actualType==UPCA?___[1]:___[0]),
		di.digitFont,color);
	
	Draw101(di, di.guardCY); // start
	
	// draw EAN8 & EAN13/UPC8 differently
	if(di.actualType==EAN8)
		DrawEAN8Left(di);
	else
		DrawEAN13orUPCALeft(di);
	
	Draw01010(di, di.guardCY); // middle
	
	if(di.actualType==EAN8)
		DrawEAN8Right(di);
	else
		DrawEAN13orUPCARight(di);
//	for(int i=7; i<13; ++i)
//	{
//		draw.DrawText(di.left,
//			digitY,
//			String().Cat()<<___[i],
//			di.digitFont, color);
//		DrawDigit(di, i, 2); // 2 R
//	}
	Draw101(di, di.guardCY); // end
	draw.DrawText(di.left+(noQuietZone==1?0:3)*unitWidth,
		di.digitY,
		String().Cat()<<(di.actualType==UPCA?___[12]:'>'),
		di.digitFont, color);
	// display text if any
	if(di.textSize.cx!=0)
	{
		draw.DrawText((di.width-di.textSize.cx)/2, height+2*unitWidth, text, font, color);
	}

}

void E13p::DrawDigit(DrawInfo& di, int index, int lgr)
{
	int number=digit(index);
	const static int stroke[10][4]={
	 		{3,2,1,1}, //	0001101
			{2,2,2,1}, // 	0011001
			{2,1,2,2}, //	0010011
			{1,4,1,1}, //	0111101
			{1,1,3,2}, // 	0100011
			{1,2,3,1}, // 	0110001
			{1,1,1,4}, //	0101111
			{1,3,1,2}, // 	0111011
			{1,2,1,3}, // 	0110111
			{3,1,1,2} // 0001011
		};	 	
	switch(lgr)
	{
	case 0: // L
		DrawBar(di,stroke[number][0], 0);
		DrawBar(di,stroke[number][1], di.regularCY);
		DrawBar(di,stroke[number][2], 0);
		DrawBar(di,stroke[number][3], di.regularCY);
		break;
	case 1: // G
		DrawBar(di,stroke[number][3], 0);
		DrawBar(di,stroke[number][2], di.regularCY);
		DrawBar(di,stroke[number][1], 0);
		DrawBar(di,stroke[number][0], di.regularCY);
		break;
	case 2: // R
		DrawBar(di,stroke[number][0], di.regularCY);
		DrawBar(di,stroke[number][1], 0);
		DrawBar(di,stroke[number][2], di.regularCY);
		DrawBar(di,stroke[number][3], 0);
		break;
	}
}

void E13p::DrawBar(DrawInfo& di, int width, int height)
{
	int w=unitWidth*width;
	if(height!=0)
	{
		di.draw.DrawRect(di.left, 0, w, height, color);
	}
	di.left+=w;
}

void E13p::DrawEAN8Left(DrawInfo& di)
{
	for(int i=5; i<9; ++i)
	{
		di.draw.DrawText(di.left,
			di.digitY,
			String().Cat()<<___[i],
			di.digitFont, color);
		DrawDigit(di, i, 0); // 0 L, 1-G
	}
}
void E13p::DrawEAN8Right(DrawInfo& di)
{
	for(int i=9; i<13; ++i)
	{
		di.draw.DrawText(di.left,
			di.digitY,
			String().Cat()<<___[i],
			di.digitFont, color);
		DrawDigit(di, i, 2); // 2 R
	}
}
void E13p::DrawEAN13orUPCALeft(DrawInfo& di)
{
	for(int i=1; i<7; ++i)
	{
		bool f=di.actualType==UPCA && i==1;
		if(!f)
			di.draw.DrawText(di.left,
				di.digitY,
				String().Cat()<<___[i],
				di.digitFont, color);
		if(f)
			di.regularCY=di.guardCY;	
		DrawDigit(di, i, lg[digit(0)][i-1]); // 0 L, 1-G
		if(f)
			di.regularCY-=5*unitWidth;
	}
}
void E13p::DrawEAN13orUPCARight(DrawInfo& di)
{
	for(int i=7; i<13; ++i)
	{
		bool f=di.actualType==UPCA && i==12;
		if(!f)
			di.draw.DrawText(di.left,
				di.digitY,
				String().Cat()<<___[i],
				di.digitFont, color);
		if(f)
			di.regularCY=di.guardCY;	
		DrawDigit(di, i, 2); // 2 R
		if(f)
			di.regularCY-=5*unitWidth;
	}
}

// digits count without leading zero
//
// sort of, actually just checked upto 6th char
//
// 
int E13p::dcnlz()const 
{
	ASSERT_(___[0]!='\0', "Not expected to be used on empty string");
	ASSERT_(UPCA==2,
		"Change to type enum may break this function");
	int cnt=0;
	for(int i=0;i<5;++i)
		if(___[i]=='0')
			++cnt;
		else
			break;
	return 13-cnt;
}
// precondition _[0] to _[12] are chars in ['0','9']
//
// calculates and fills in check digit for ean13
static void ckdg(char _[14])
{
	_[12]=(150+'0'*24-(_[0]+_[2]+_[4]+_[6]+_[8]+_[10])-
		(_[1]+_[3]+_[5]+_[7]+_[9]+_[11])*3)%10+'0';
}

void EAN::SetText(const char * text)
{
	int len;
	ASSERT_(EAN8UPCAEAN13==3 && EAN8EAN13==4,
	        "change to type enum may have broken the following code");
	if(	text==NULL || 
		(len=strlen(text))==0 ||
		 ((type!=EAN8)&&len>12)||
	    (type==EAN8 && len>7) 
	){
		ClearData(); // silently ignore invalid input text
		return;
	}
	{	// check if all chars in text are digits;
		int c;
		
		for(const char * p=text; (c=*p); ++p)
			if(c<'0' || c>'9')
			{
				ClearData(); // silently ignore invalid input text
				return;
			}
	}
	memsetw(___,('0'<<8)+'0',sizeof(___)/2-1);
	memcpy(___+12-len,text,len);
	ckdg(___);
	___[13]='\0';
}

#define _e13p (reinterpret_cast<E13p&>(const_cast<EAN&>(*this)))
void EAN::Prepare()
{
	DrawingDraw w(1,1);
	if(___[0]!='\0'){// valid data
		int h=height;
		//  In UPC-A the dark bars forming the Start,
		//  Middle, and End guard bars are extended 
		// downwards by 5 times x-dimension, with a 
		// resulting nominal symbol of height of 27.55 mm (1.08 in.) 

		// The total width for a digit is always 7 modules. 
		//
		Size textSize(0,0);
		if(!text.IsEmpty())
		{
			textSize=GetTextSize(text, font);
			h+=unitWidth*2+textSize.cy;
		}
		w.Create(GetWidth(),h);
		E13p::DrawInfo di(w,0);

		di.textSize=textSize;
		di.width=w.GetSize().cx;
		di.digitFont=StdFont().Width(6*unitWidth).Height(9*unitWidth);
		_e13p.Render(w, di);
	}
	const_cast<EAN&>(*this).draw.Create<Drawing>()=w;	
}
int EAN::ActualType()const
{
	ASSERT_(type>=EAN13 && type<=EAN8EAN13,
		"Changes to type enum breaks the following code");
	if(type<EAN8UPCAEAN13)
		return type;
	int dc=_e13p.dcnlz();
	switch(type)
	{
	case EAN8UPCAEAN13:
		return dc<9?EAN8:dc<13?UPCA:EAN13;
	//default:
	}
	return dc<9?EAN8:EAN13;
}

EAN& EAN::Type(int upcvariant)
{
	ASSERT_(EAN8EAN13==4,"Change to type enum may have broke this code");
	if(type!=upcvariant)
	{
		int oldtype=type;
		type=upcvariant;
		switch(upcvariant)
		{
		case EAN8:
			for(int i=0; i<5; ++i)
				if(___[i]!='0')
				{
					ClearData(); break;
				}
			break;
		case UPCA:
			if(___[0]!='0')
			{
				ClearData();
			}
			break;
		//default: EAN13, EAN8UPCAEAN13, EAN8EAN13
		//         are always ok with existing data
		}
		if(_e13p.IsEmpty() || oldtype!=ActualType())
			draw.Clear();
	}
	return *this;
}


#undef _e13p
