#ifndef _Barcode_QtfBarcode_h_
#define _Barcode_QtfBarcode_h_

#include <Barcode/Barcode.h>
#include <RichText/RichText.h>

NAMESPACE_UPP

template <>
String AsString<Barcode>(const Barcode& barcode)
{
	DrawingDraw d(barcode.GetSize()*600/72);
	d.DrawDrawing(d.GetSize(), barcode.AsDrawing());
	return AsQTF(CreateDrawingObject(
	            d.GetResult(),
	            d.GetSize(),
	            d.GetSize()
			));
}

template <>
String AsString<Code128>(const Code128& barcode)
{
	return AsString<Barcode>(barcode);
}

template <>
String AsString<EAN>(const EAN& barcode)
{
	return AsString<Barcode>(barcode);
}

END_UPP_NAMESPACE

#endif
