#include <CtrlLib/CtrlLib.h>

#include <Barcode/Barcode.h>
// no need to include the following if not going to 
// use QTF 
#include <Barcode/QtfBarcode.h>

using namespace Upp;

#define LAYOUTFILE <BarcodeTest/BarcodeTest.lay>
#include <CtrlCore/lay.h>

struct MyApp : WithBarcodeTestLayout<TopWindow>
{
	MyApp(){
		CtrlLayout(*this, "Barcode Test");
		input<<=THISBACK(Updated);
		print.SetImage(CtrlImg::print())<<=THISBACK(Print);
		top<<=2;
		left<<=2;
	}
	
	virtual void Paint(Draw& w);
	
	void GenBarcode();
	void Print();
	
	void Updated()
	{
		Refresh();
		Code128 c(String().Cat()<<~input);
		EAN ean(AsString(~input));
		richview.SetQTF(String("[ ").Cat()
			<<c.DisplayText("Hi, U++ user!")
				.Color(Red()).Height(36)
			<<"&&"
			<<ean.Type(EAN::EAN8UPCAEAN13)
				.DisplayText("Best Seller")
		);
	}
	
	typedef MyApp CLASSNAME;
	
};

GUI_APP_MAIN
{
	MyApp().Sizeable().Run();

}

void MyApp::Paint(Draw& w)
{
	w.DrawRect(GetSize(), SColorFace());
	
	String text=~input;
	if(!text.IsEmpty())
	{
		Code128 c(text);
		c.Color(Red()).Height(72)
			//.UnitWidth(2)
			.NoQuietZone()
			.Font(StdFont().Height(13).Bold());

		Rect r(c.GetSize()*2);
		r+=Point(5,50);
	
		w.DrawRect(r, LtGreen());
		w.DrawDrawing(r,c);
		{
			int h=GetTextSize("H", StdFont()).cy;
			w.DrawText(r.right+5, r.top+r.GetHeight()/2-h, "Code128 drawed");
			w.DrawText(r.right+5, r.top+r.GetHeight()/2,"to 2 times ");
			w.DrawText(r.right+5, r.top+r.GetHeight()/2+h,"regular size");
		}
		EAN ean(text);
		ean.Type(EAN::EAN8UPCAEAN13)
			.DisplayText("The Product's Name goes Here");
		w.DrawRect(Rect(ean.GetSize())+Point(5,370), LtGreen());
		w.DrawDrawing(Rect(ean.GetSize())+Point(5,370), ean);
		{
			w.DrawText(ean.GetSize().cx+10,ean.GetSize().cy/2+370,
				"EAN with standard size"
			);
		}
	}

}


void MyApp::Print()
{
	String text=~input;
	
	if(text.IsEmpty())
		return;
	
	int l=~left;
	if(IsNull(l))
	{
		l=2;
		left<<=2;
	}
	int t=~top;
	if(IsNull(t))
	{
		t=2;
		top<<=2;
	}
	
	Drawing draw=Code128(text).Color(LtRed)
		.Height(72)
		//.UnitWidth(1)
		.Font(StdFont().Height(10).Bold());
	PrinterJob prn;
	Draw& w=prn;
	w.StartPage();
	w.DrawDrawing(int(l*600/25.4),int(t*600/25.4), 
		draw.GetSize().cx*600/72 , 
		draw.GetSize().cy*600/72,draw);
		
	draw=EAN(text).DisplayText("Product X");//.UnitWidth(1);
	w.DrawDrawing(int(l*600/25.4),int(t*600/25.4)+700, 
		draw.GetSize().cx*600/72 , 
		draw.GetSize().cy*600/72,draw);	
	w.EndPage();
	
}