#include "CommPak.h"
#include "Serial.h"


SerialPort	CommPort;			// My serial object
char buff[65]; // Last byte reserved for 0 terminator
int bytes_read;


CommPak::CommPak()
{
	
	CtrlLayout(*this, "Puloon Test program");
	Sizeable().Zoomable();
	MaximizeBox();
	Maximize();
	Icon(MyImg::vmlogo());

	btnSetup			<<= THISBACK(SetupComms);

	btnPurge			<<= THISBACK(PuloonPurge);
	btnStatus			<<= THISBACK(PuloonStatus);
	btnUpperDispense	<<= THISBACK(PuloonUpperDispense);
	btnUpperDispense2	<<= THISBACK(PuloonUpperDispense2);
	btnLowerDispense	<<= THISBACK(PuloonLowerDispense);
	btnLowerDispense2	<<= THISBACK(PuloonLowerDispense2);
	btnUpperLowerDispense	<<= THISBACK(PuloonUpperLowerDispense);
	outtext.AddColumn("out",100);
	if (!CommPort.Open("/dev/ttyS1")){
		Exclamation("Cannot open ttyS1");
	}
}
 

void	CommPak::SetupComms()
{
int Cnt;
int Port,Baud[]={1200,2400,4800,9600,19200,38400,57600,115200};

	WithCommSetup<TopWindow>	CommSetup;
 	RLOG("1");
	// stop the timer before changing anything

 	RLOG("2");

	// if the port is open, close it
	if (CommPort.IsOpened())	CommPort.Close();
	
	CtrlLayoutOKCancel(CommSetup, "Setup Comms");
 	RLOG("3");

	for (Cnt=1;Cnt < 9; Cnt++)
		CommSetup.dlPort.Add(Format("COM%d",Cnt));
	for (Cnt=0; Cnt < sizeof(Baud)/sizeof(int); Cnt++)
		CommSetup.dlBaud.Add(Format("%d",Baud[Cnt]));
	
	CommSetup.dlPort = "COM1";	// choose to display COM1
	CommSetup.dlBaud= "9600";	// and 9600 baud
	
	if (CommSetup.Execute() == IDOK)
	{
		Port = CommSetup.dlPort.GetIndex()+1;
		// Now open the port at the baud rate
		if (!CommPort.Open(Port-1,Baud[CommSetup.dlBaud.GetIndex()]))
			Exclamation(Format("Cannot open COM%d",Port));
	}
	RLOG("4");
}

int	CommPak::ReadAckNck(){
	char buff[2]; // Last byte reserved for 0 terminator
	int bytes_read;
	Time starttime = GetSysTime();
	while (true){
		try { bytes_read = CommPort.ReadData(buff, 1); }
		catch (String msg){ PromptOK(msg); }
		if (bytes_read>0) {
			String so = CommPort.BufToString(buff, 1, " <- ");
			RLOG("read1="+AsString(6)+"-("+so+")");
			outtext.Add("read1="+AsString(6)+"-("+so+")");
			if (buff[0]==0x15 || buff[0]==0x06) return buff[0];
		}
		if (GetSysTime() > starttime+60) {
			response.SetQTF("TimeOut Fail");
			response.Sync();
			
			return 0x15;
		}
	}
}

void CommPak::ClearReadBuffer(){
	
	try { bytes_read = CommPort.ReadData(buff, 65); }
	catch (String msg){ PromptOK(msg); }
	String so = CommPort.BufToString(buff, bytes_read, " <- ");
	RLOG("skip="+AsString(bytes_read)+"-("+so+")");
	outtext.Add("skip="+AsString(bytes_read)+"-("+so+")");
	
}

String CommPak::ErrorTextByCode(char code){
	char buff[1];

	switch(code) {
	case 0x30: return "Good"; break;
	case 0x31: return "Normal stop"; break;
	case 0x32: return "Pickup error"; break;
	case 0x33: return "JAM at CHK1,2 Sensor"; break;
	case 0x34: return "Overflow bill"; break;
	case 0x35: return "JAM at EXIT Sensor or EJT Sensor"; break;
	case 0x36: return "JAM at DIV Sensor"; break;
	case 0x37: return "Undefined command"; break;
	case 0x38: return "Bill- End"; break;
	case 0x3B: return "Note request error"; break;
	case 0x3C: return "Counting Error(between DIV Sensor and EJT Sensor)"; break;
	case 0x3D: return "Counting Error(between EJT Sensor and EXIT Sensor)"; break;
	case 0x3F: return "Reject Tray is not recognized"; break;
	case 0x41: return "Motor Stop"; break;
	case 0x42: return "JAM at Div Sensor"; break;
	case 0x43: return "Timeout (From DIV Sensor to EJT Sensor)"; break;
	case 0x44: return "Over Reject"; break;
	case 0x45: return "Cassette is not recognized"; break;
	case 0x47: return "Dispensing timeout"; break;
	case 0x49: return "Diverter solenoid or SOL Sensor error"; break;
	case 0x4A: return "SOL Sensor error"; break;
	case 0x4E: return "Purge error (Jam at Div Sensor)"; break;
	default:{
			buff[0] = code; buff[1] = 0;
			return "неизвестный код"+CommPort.BufToString(buff, 1, "");
			break;
		}
	}

}

void	CommPak::PuloonPurge(){	
	char command[] = { 0x04, 0x50, 0x02, 0x44, 0x03, 0x00 };
	int len = 6, retlen = 7;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x44?"команда совпадает(44)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[4]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+4, 1, "")+"] "+ErrorTextByCode(buff[4]);
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}


void	CommPak::PuloonStatus(){	
	char command[] = { 0x04, 0x50, 0x02, 0x46, 0x03, 0x00 };
	int len = 6, retlen = 10;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x46?"команда совпадает(46)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[5]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+5, 1, "")+"] "+ErrorTextByCode(buff[5]);
		String sensor0 = "Sensor0 = "+FormatIntBase(int(buff[6])&0xff,2,8,'0');
		String sensor1 = "Sensor1 = "+FormatIntBase(int(buff[7])&0xff,2,8,'0');
		String bitsensor;
		bitsensor.Cat("CHK1 sensor = "+AsString(int(((buff[6])&(1<<0))>>0))+"&");
		bitsensor.Cat("CHK2 sensor = "+AsString(int(((buff[6])&(1<<1))>>1))+"&");
		bitsensor.Cat("DIV1 sensor = "+AsString(int(((buff[6])&(1<<2))>>2))+"&");
		bitsensor.Cat("DIV2 sensor = "+AsString(int(((buff[6])&(1<<3))>>3))+"&");
		bitsensor.Cat("EJT sensor = "+AsString(int(((buff[6])&(1<<4))>>4))+"&");
		bitsensor.Cat("EXIT sensor = "+AsString(int(((buff[6])&(1<<5))>>5))+"&");
		bitsensor.Cat("NearEndUpper sensor = "+AsString(int(((buff[6])&(1<<6))>>6))+"&&");
		
		bitsensor.Cat("SOL sensor = "+AsString(int(((buff[7])&(1<<0))>>0))+"&");
		bitsensor.Cat("UpperCassete sensor = "+AsString(int(((buff[7])&(1<<1))>>1))+"&");
		bitsensor.Cat("LowerCassete sensor = "+AsString(int(((buff[7])&(1<<2))>>2))+"&");
		bitsensor.Cat("CHK3 sensor = "+AsString(int(((buff[7])&(1<<3))>>3))+"&");
		bitsensor.Cat("CHK4 sensor = "+AsString(int(((buff[7])&(1<<4))>>4))+"&");
		bitsensor.Cat("NearEndLower sensor = "+AsString(int(((buff[7])&(1<<5))>>5))+"&");
		bitsensor.Cat("RejectTray sensor = "+AsString(int(((buff[7])&(1<<6))>>6))+"&");
		response.SetQTF("[1 {{1000:1000g0f0^ "+
						iscommand+"&"+
		                exitstatus+"&"+
		                sensor0+"&"+
		                sensor1+"&"+
		                "[+50 "+bitsensor +"]"+
		                ":: [> @@iml:2000*2000`MyImg::Sensors`]}}"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}


void	CommPak::PuloonUpperDispense(){	
	char command[] = { 0x04, 0x50, 0x02, 0x45, 0x30, 0x31, 0x03, 0x00 };
	int len = 8, retlen = 14;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x45?"команда совпадает(45)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[8]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+8, 1, "")+"] "+ErrorTextByCode(buff[8]);
		String chk12sensor = "Прошло через сенсоры CHK 1,2, купюр = ";
		String exitsensor = "Прошло через выходные сенсоры, купюр = ";
		String rejectedbills  = "Отклонено, купюр = ";
		String uppernearend;
		chk12sensor.Cat(buff[4]); chk12sensor.Cat(buff[5]); 
		exitsensor.Cat(buff[6]); exitsensor.Cat(buff[7]); 
		rejectedbills.Cat(buff[10]); rejectedbills.Cat(buff[11]); 
		if (int(buff[9]&0xff)== 0x31)  uppernearend = "Верхняя кассета почти пустая";
		if (int(buff[9]&0xff)== 0x30)  uppernearend = "Верхняя кассета полна";
		
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"+
		                chk12sensor+"&"+
		                exitsensor+"&"+
		                rejectedbills+"&"+
		                uppernearend
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}



void	CommPak::PuloonUpperDispense2(){	
	char command[] = { 0x04, 0x50, 0x02, 0x45, 0x30, 0x32, 0x03, 0x00 };
	int len = 8, retlen = 14;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x45?"команда совпадает(45)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[8]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+8, 1, "")+"] "+ErrorTextByCode(buff[8]);
		String chk12sensor = "Прошло через сенсоры CHK 1,2, купюр = ";
		String exitsensor = "Прошло через выходные сенсоры, купюр = ";
		String rejectedbills  = "Отклонено, купюр = ";
		String uppernearend;
		chk12sensor.Cat(buff[4]); chk12sensor.Cat(buff[5]); 
		exitsensor.Cat(buff[6]); exitsensor.Cat(buff[7]); 
		rejectedbills.Cat(buff[10]); rejectedbills.Cat(buff[11]); 
		if (int(buff[9]&0xff)== 0x31)  uppernearend = "Верхняя кассета почти пустая";
		if (int(buff[9]&0xff)== 0x30)  uppernearend = "Верхняя кассета полна";
		
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"+
		                chk12sensor+"&"+
		                exitsensor+"&"+
		                rejectedbills+"&"+
		                uppernearend+"&"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}

void CommPak::PuloonLowerDispense(){
	char command[] = { 0x04, 0x50, 0x02, 0x55, 0x30, 0x31, 0x03, 0x00 };
	int len = 8, retlen = 14;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x55?"команда совпадает(55)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[8]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+8, 1, "")+"] "+ErrorTextByCode(buff[8]);
		String chk12sensor = "Прошло через сенсоры CHK 3,4, купюр = ";
		String exitsensor = "Прошло через выходные сенсоры, купюр = ";
		String rejectedbills  = "Отклонено, купюр = ";
		String uppernearend;
		chk12sensor.Cat(buff[4]); chk12sensor.Cat(buff[5]); 
		exitsensor.Cat(buff[6]); exitsensor.Cat(buff[7]); 
		rejectedbills.Cat(buff[10]); rejectedbills.Cat(buff[11]); 
		if (int(buff[9]&0xff)== 0x31)  uppernearend = "Нижняя кассета почти пустая";
		if (int(buff[9]&0xff)== 0x30)  uppernearend = "Нижняя кассета полна";
		
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"+
		                chk12sensor+"&"+
		                exitsensor+"&"+
		                rejectedbills+"&"+
		                uppernearend+"&"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}

void CommPak::PuloonLowerDispense2(){
	char command[] = { 0x04, 0x50, 0x02, 0x55, 0x30, 0x32, 0x03, 0x00 };
	int len = 8, retlen = 14;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x55?"команда совпадает(55)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[8]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+8, 1, "")+"] "+ErrorTextByCode(buff[8]);
		String chk12sensor = "Прошло через сенсоры CHK 3,4, купюр = ";
		String exitsensor = "Прошло через выходные сенсоры, купюр = ";
		String rejectedbills  = "Отклонено, купюр = ";
		String uppernearend;
		chk12sensor.Cat(buff[4]); chk12sensor.Cat(buff[5]); 
		exitsensor.Cat(buff[6]); exitsensor.Cat(buff[7]); 
		rejectedbills.Cat(buff[10]); rejectedbills.Cat(buff[11]); 
		if (int(buff[9]&0xff)== 0x31)  uppernearend = "Нижняя кассета почти пустая";
		if (int(buff[9]&0xff)== 0x30)  uppernearend = "Нижняя кассета полна";
		
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"+
		                chk12sensor+"&"+
		                exitsensor+"&"+
		                rejectedbills+"&"+
		                uppernearend+"&"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}

void	CommPak::PuloonUpperLowerDispense(){	
	char command[] = { 0x04, 0x50, 0x02, 0x56, 0x30, 0x31, 0x30, 0x31, 0x03, 0x00 };
	int len = 10, retlen = 21;
	if (CommandSend(command , len, retlen)) {
		String iscommand = buff[3]==0x56?"команда совпадает(56)":"отчет о другой команде ("+CommPort.BufToString(buff+3, 1, "")+")";
		String exitstatus = AsString(buff[12]<=0x31?"Результат":"Ошибка")+": [* "+CommPort.BufToString(buff+12, 1, "")+"] "+ErrorTextByCode(buff[12]);
		String chk12sensor = "Прошло через сенсоры CHK 1,2, купюр = ";
		String exitsensorU = "Прошло через выходные сенсоры, купюр = ";
		String chk34sensor = "Прошло через сенсоры CHK 3,4, купюр = ";
		String exitsensorL = "Прошло через выходные сенсоры, купюр = ";
		String rejectedbillsU  = "Отклонено, купюр = ";
		String rejectedbillsL  = "Отклонено, купюр = ";
		String uppernearend;
		String lowernearend;
		chk12sensor.Cat(buff[4]); chk12sensor.Cat(buff[5]); 
		exitsensorU.Cat(buff[6]); exitsensorU.Cat(buff[7]); 
		chk34sensor.Cat(buff[8]); chk34sensor.Cat(buff[9]); 
		exitsensorL.Cat(buff[10]); exitsensorL.Cat(buff[11]); 
		rejectedbillsU.Cat(buff[15]); rejectedbillsU.Cat(buff[16]); 
		rejectedbillsL.Cat(buff[17]); rejectedbillsL.Cat(buff[18]); 
		if (int(buff[13]&0xff)== 0x31)  uppernearend = "Верхняя кассета почти пустая";
		if (int(buff[13]&0xff)== 0x30)  uppernearend = "Верхняя кассета полна";
		if (int(buff[14]&0xff)== 0x31)  lowernearend = "Нижняя кассета почти пустая";
		if (int(buff[14]&0xff)== 0x30)  lowernearend = "Нижняя кассета полна";
		
		response.SetQTF(iscommand+"&"+
		                exitstatus+"&"+
		                chk12sensor+"&"+
		                exitsensorU+"&"+
		                chk34sensor+"&"+
		                exitsensorL+"&"+
		                rejectedbillsU+"&"+
		                rejectedbillsL+"&"+
		                uppernearend+"&"+
		                lowernearend+"&"
						);
		outtext.Refresh();
		Ctrl::ProcessEvents();
	}
}


//======================================================================================

bool CommPak::CommandSend(char * command, int len, int retlen){
	outtext.Clear();
	ClearReadBuffer();
	command[len-1] = GetXorCRC((unsigned char*)command,len-1);
	
	char send_bytes_ok[] = { 0x06 };
	char send_bytes_nck[] = { 0x15 };
	
	int i=0; 

	char* s = command;
	String so;
	RLOG("SendData");
	for(int i = 0; i < 2; i++) {
		CommPort.SendData(s,len);
		so = CommPort.BufToString(AsString(s), len, " -> ");
		RLOG("read="+AsString(len)+"-"+so);
		outtext.Add(AsString(len)+"-"+so);
	
		buff[0] = ReadAckNck();
		so = CommPort.BufToString(buff, 1, " <- ");
		RLOG("read=1-"+so);
		outtext.Add("1-"+so);
		
		if (buff[0] = 0x06) break;
	}
	
	String ss;
	Time starttime = GetSysTime();

	RLOG("ReadData");
	for(int trying = 0; trying < 3; trying++){
		RDUMP(trying);
		while (true){
			try { bytes_read = CommPort.ReadData(buff, 1); }
			catch (String msg){ PromptOK(msg); }
			if (bytes_read>0) {
				String so = CommPort.BufToString(buff, 1, " <- ");
				RLOG("read1="+AsString(1)+"-("+so+")");
				outtext.Add("read1="+AsString(1)+"-("+so+")");
				if (buff[0]==0x01 ) break;
				else {
					String so = CommPort.BufToString(buff, 1, " <- ");
					RLOG("read1="+AsString(1)+"-("+so+")");
					outtext.Add("read1="+AsString(1)+"-("+so+")");
				}
			}
			if (GetSysTime() > starttime+60) {
				response.SetQTF("TimeOut Fail");
				response.Sync();
				
				return false;
			}
		}
		starttime = GetSysTime();
		RLOG("After 1st cycle");
		{
			int i = 1;
			while (true){
				try { bytes_read = CommPort.ReadData(buff+i, 1); }
				catch (String msg){ PromptOK(msg); }
				if (bytes_read != 0) i++;
				if ( i == retlen ) break;
				if (GetSysTime() > starttime+60) {
					response.SetQTF("TimeOut Fail");
					response.Sync();
					
					return false;
				}
			}
			bytes_read = retlen;
		}
		buff[bytes_read] = 0;
		so = CommPort.BufToString(buff, bytes_read, " <- ");
		RLOG("read="+AsString(bytes_read)+"-"+so);
		outtext.Add(AsString(bytes_read)+"-"+so);
	
		outtext.Refresh();
		Ctrl::ProcessEvents();
	
		RLOG("---");
		Sleep(200);
		
		if (bytes_read!=0 && int(buff[retlen-1]&0xff)==int(GetXorCRC((unsigned char*)buff, retlen-1))) {
			s = send_bytes_ok;
			CommPort.SendData(s,1);	
			so = CommPort.BufToString(s, 1, " -> ");
			RLOG("read="+AsString(1)+"-"+so);
			outtext.Add(AsString(1)+"-"+so);

			ClearReadBuffer();
			return true;
		} else {
			s = send_bytes_nck;
			CommPort.SendData(s,1);	
			so = CommPort.BufToString(s, 1, " -> ");
			RLOG("read="+AsString(1)+"-"+so);
			outtext.Add(AsString(1)+"-"+so);
		}
		
	}
	ClearReadBuffer();
	return false;
}

unsigned char CommPak::GetXorCRC(unsigned char* bufData, unsigned int sizeData,bool check)
{
	unsigned char CRC, i;
	CRC = 0;
	for(i=0; i < sizeData; i++) {
		CRC ^= bufData[i];
	}
	return CRC & 0xff;
}


	
CommPak::~CommPak()
{	
	CommPort.Close();	
}
void CommPak::Close(){
	Break(0);
	TopWindow::Close();
}

	
GUI_APP_MAIN
{
	CommPak().Run();
	return ;
}

