#ifndef _xadrez_xadrez_h
#define _xadrez_xadrez_h

#include <CtrlLib/CtrlLib.h>

#define IMAGEFILE <xadrez/xadrez.iml>
#include <Draw/iml_source.h>
#define LAYOUTFILE <xadrez/xadrez.lay>
#include <CtrlCore/lay.h>

#define           MAXESC    10

class xadrez : public WithxadrezLayout<TopWindow> {
public:
	typedef xadrez CLASSNAME;
	// Variaveis do Programa
	MenuBar                   menu;
	StatusBar   estadoxadrezpostal;
	Splitter            horizontal;
	TreeCtrl       arvoredeescolha;
	String         OpcoesDeEscolha;
	Image                      img;

	xadrez();
	
	void Paint(Draw& w) 
	{
     	Size sz = GetSize();
		w.DrawRect(sz, SWhite);
		Size isz = vacat().GetSize();
		w.DrawImage((sz.cx - isz.cx) / 2, (sz.cy - isz.cy) / 2, vacat());
		//Icon(Xadrez::vulpix());
	    //Tip("This is U++ tray icon");
	}
	
	virtual void MouseMove(Point pos, dword flags) 
	{
		Refresh();
	}
	
	virtual void LeftDown(Point pos, dword flags) 
	{
		Refresh();
	}
	
	void LocalMenu(Bar& bar) {
		bar.Add("Sair", THISBACK(Exit));
	}

	void RightDown(Point, dword) {
		MenuBar::Execute(THISBACK(LocalMenu));
	}
	
	void Exit() 
	{
		if(PromptOKCancel("Sair do Xadrez Postal?"))
			Break();
	}

	void ajuda();
	void sobre();
	void configurar();
	void sair();
	void OpenDir(int id);
	void CloseDir(int id);
	void LoadTree(int parent, const String& path, Progress& pi);
	void ShowPath();
	void TratarOpcoesDeArvore();
	void SetOption(int id);
};

#endif

