/*
PieChart control
V0.1, Dec 2006
Copyright (C) 2006, Andrei-Catalin
*/

#ifndef _Scatter_Pie_h_
#define _Scatter_Pie_h_
#include <CtrlLib/CtrlLib.h>
using namespace Upp;

void DrawPie(Draw& w, Point centre, int r, int start, int alpha, int width=0, class::Color fill=Null, class::Color outline=Black,uint64 pattern=0,class::Color background=White);

inline void DrawScaledPie(Draw& w, Point centre, int r, int start, int alpha, int width=0, class::Color fill=Null, class::Color outline=Black, int scale=1,uint64 pattern=0,class::Color background=White)
{
	DrawPie(w, centre, scale*r, start, alpha, scale*width, fill, outline,pattern,background);
}
void DrawMLText(Draw& w, Rect& box, String content, Font f=StdFont());

typedef class::Color Acolor;
class PieChart: public Ctrl
{
	public:
	enum titlePosition {BUTTOM, TOP};
	
	PieChart& SetColor(class::Color _color);
	PieChart& SetTitle(String _title);
	PieChart& SetTitleFont(Font& fontTitle);
	PieChart& SetTitleColor(class::Color colorTitle);
	PieChart& TitleTopPos(bool pos=TOP);
	PieChart& SetTitleGap(int gap);
	
	PieChart& SetRadius(int r);
	
	PieChart& ShowPercent(bool show=true);
	PieChart& SetPercentBack(class::Color pbcolor);
	
	PieChart& SetLegendFont(Font& fontLegend);
	PieChart& SetLegendTextColor(class::Color colorLegend);
	PieChart& SetLegendBackColor(class::Color colorBack);
	PieChart& SetLegend_cx(int h);
	PieChart& SetLegend_cy(int v);
	PieChart& SetShowLegend(bool show);
	
	void AddCategory(String name, double value, class::Color catcolor);
	void RemoveCategory(int index);
	PieChart& SetCatValue(int index, double value);
	PieChart& SetCatName(int index, String name);
	PieChart& SetCatColor(int index, class::Color catcolor);
	double GetCatValue(int index);
	String GetCatName(int index);
	Acolor GetCatColor(int index);
	int GetCatCount();	
	
	PieChart();
	~PieChart();
	void PaintPie(Draw& w,int scale);
	void DrawChart(Draw& w,int scale);
	void Paint(Draw& w);
	
	Drawing& GetDrawing();
	Image& GetImage(int scale=1);
	void SaveAsMetafile(const char* file);
	
	typedef PieChart CLASSNAME;
	
	private:
	class::Color backColor;
	String title;
	Font titleFont;
	class::Color titleColor;
	bool titlePos;
	int titleGap;
	
	int radius;
	bool showPercent;
	Acolor percentBack;
	
	Font legendFont;
	class::Color legendTextColor, legendBackColor;
	int legend_cx, legend_cy;
	bool showLegend;
	
	Vector<String> vNames;
	Vector<double> vValues;
	Vector<class::Color> vColors;
	
	String GetPercent(double a, double total);
	
	Drawing drawing;
	Image img;
	
	
};
#endif
