#include "Scatter.h"


Scatter& Scatter::SetColor(class::Color _color)
{
	graphColor=_color;
	return *this;
}

Scatter& Scatter::SetTitle(String _title)
{
	title=_title;
	return *this;
}
Scatter& Scatter::SetTitleFont(Font& fontTitle)
{
	titleFont=fontTitle;
	return *this;
}
Scatter& Scatter::SetTitleColor(class::Color colorTitle)
{
	titleColor=colorTitle;
	return *this;
}
void Scatter::SetLabels(String _xLabel, String _yLabel)
{
	xLabel=_xLabel;
	yLabel=_yLabel;
}
Scatter& Scatter::SetLabelX(String _xLabel)
{
	xLabel=_xLabel;
	return *this;
}
Scatter& Scatter::SetLabelY(String _yLabel)
{
	yLabel=_yLabel;
	return *this;
}
Scatter& Scatter::SetLabelsFont(Font& fontLabels)
{
	labelsFont=fontLabels;
	return *this;
}
Scatter& Scatter::SetLabelsColor(class::Color colorLabels)
{
	labelsColor=colorLabels;
	return *this;
}
Scatter& Scatter::SetPlotAreaPoz(int poz_x, int poz_y)
{
	px=poz_x;
	py=poz_y;
	return *this;
}
Scatter& Scatter::H_Border(int poz_x)
{
	if(poz_x>=0) px=poz_x;
	return *this;
}
Scatter& Scatter::V_Border(int poz_y)
{
	if(poz_y>=0) py=poz_y;
	return *this;
}

Scatter& Scatter::SetPlotAreaColor(class ::Color p_a_color)
{
	plotAreaColor=p_a_color;        
	return *this;
}
Scatter& Scatter::SetAxisColor(class::Color axis_color)
{
	axisColor=axis_color;
	return *this;
}
Scatter& Scatter::SetAxisWidth(int axis_width)
{
	axisWidth=axis_width;
	return *this;
}
Scatter& Scatter::SetGridColor(class::Color grid_color)
{
	gridColor=grid_color;
	return *this;
}
Scatter& Scatter::SetGridWidth(int grid_width)
{
	gridWidth=grid_width;
	return *this;
}
Scatter& Scatter::ShowHGrid(bool show)
{
	drawHGrid=show;
	return *this;
}
Scatter& Scatter::ShowVGrid(bool show)
{
	drawVGrid=show;
	return *this;
}
Scatter& Scatter::ShowLegend(bool show)
{
	showLegend=show;
	return *this;
}
Scatter& Scatter::SetLegendWeight(int weight)
{
	legendWeight=weight;
	return *this;
}
Scatter& Scatter::SetAntialiasing(bool aa)
{
	antialiasing=aa;
	return *this;
}
void Scatter::DrawLegend(Draw& w,int scale)
{
	Vector<String> L;
	L.Append(vLegend);
	L.Append(vFLegend);
	Vector<int> Thick;
	Thick.Append(vPThickness);
	Thick.Append(vFThickness);
	Vector<class::Color> LC;
	LC.Append(vPColors);
	LC.Append(vFColors);
	Vector<int> LW;
	LW.Append(vPWidth);
	Vector<int> MS;
	MS.Append(vMarkStyles);
	Vector<class::Color> MC;
	MC.Append(vMarkColors);
	
	int NMR=int((GetSize().cx-2*px)/legendWeight);//max number of labels per row
	if (NMR>0)
	{
		int N=L.GetCount();//number of labels
		int Nc;//number of complete rows
		int LCR;//number of labels on complete row
		int R;//number of remaining labels on incomplete row
		if(NMR>N)           {Nc=0;      LCR=0;      R=N;}
		else if (NMR==N)    {Nc=1;      LCR=N;      R=0;}
		else                {Nc=N/NMR;  LCR=NMR;    R=N%NMR;}
		for(int j=0;j<=Nc;j++)          
		{
			int start=N-(j+1)*LCR;
			int end=N-j*LCR;
			if (j==Nc) {start=0; end=R;}
			for(int i=start;i<end;i++)
			{
				w.DrawRect(scale*(i-start)*legendWeight,
								scale*(4-12*(j+1)),
								14*scale,
								scale*Thick.At(i)/6,
								LC.At(i));
				Point p(scale*((i-start)*legendWeight+7),scale*(4-12*(j+1))+scale*Thick.At(i)/12);
				DrawMark(MS.At(i),w,scale,p,LW.At(i,0),MC.At(i));                                           
				Font scaledFont;
				scaledFont.Height(scale*StdFont().GetHeight());
				w.DrawText(scale*(i-start)*legendWeight+scale*16,
							scale*(-2-12*(j+1)),
							L.At(i),
							scaledFont,LC.At(i));                   
			}
		}
	}
		
}	

void Scatter::SetRange(double rx, double ry)
{
	xRange=rx;
	yRange=ry;
	xMajorUnit=xRange/10;
	yMajorUnit=yRange/10;   
}
void Scatter::SetMajorUnits(double ux, double uy)
{
	xMajorUnit=ux;
	yMajorUnit=uy;
}
void Scatter::SetXYMin(double xmin, double ymin)
{
	xMin=xmin;
	yMin=ymin;
}
void Scatter::AddSeries(Vector<XY> & points,String legend,bool join, class::Color pcolor, int width, int thickness)
{
	vPointsData.AddPick(points);
	vJoin.Add(join);
	vSmooth.Add(false);
	vPColors.Add(pcolor);
	vPWidth.Add(width);
	vPThickness.Add(thickness);
	vLegend.Add(legend);
	vMarkColors.Add(pcolor);
	vShowMark.Add(true);
	vMarkStyles.Add(CIRCLE);	
	
	Refresh();
}

void Scatter::AddPoint(int j, XY & point)
{
	if(j>=0 && vPointsData.GetCount()>j)
	{
		vPointsData[j].AddPick(point);
		Refresh();
	}
}
void Scatter::InsertPoint(int j, int i, XY & point)
{
	if(j>=0 && vPointsData.GetCount()>j)
	{
		if(i>=0 && vPointsData[j].GetCount()>=i)
		{
			vPointsData[j].Insert(i,point);
			Refresh();
		}
	}
}
void Scatter::RemovePoint(int j, int i)
{
	if(j>=0 && vPointsData.GetCount()>j)
	{
		if(i>=0 && vPointsData[j].GetCount()>i)
		{
			vPointsData[j].Remove(i);
			Refresh();
		}
	}
}
void Scatter::SetData(int j, int i, XY & point)
{
	if(j>=0 && vPointsData.GetCount()>j)
	{
		if(i>=0 && vPointsData[j].GetCount()>i)
		{
			vPointsData[j][i]=point; 
			Refresh();
		}
	}
}

void Scatter::SetData(int nbSeries, Vector<XY> & points)
{
	if(nbSeries>=0 && vPointsData.GetCount()>nbSeries)
	{
		vPointsData[nbSeries]<<=points;
		Refresh();
	}
}
void Scatter::SetDataColor(int j, class::Color pcolor)
{
	if(j>=0 && vPColors.GetCount()>j)
	{
		vPColors[j]=pcolor;
		Refresh();
	}
}
void Scatter::SetFunctColor(int j, class::Color fcolor)
{
	if(j>=0 && vFColors.GetCount()>j)
	{
		vFColors[j]=fcolor;
		Refresh();
	}       
}
Acolor Scatter::GetDataColor(int j)
{
	if(j>=0 && vPColors.GetCount()>j)
	{
		return vPColors[j];
	}
	else
	{
		Exclamation("Invalid series index!");
		return Null;
	}
}
Acolor Scatter::GetFunctColor(int j)
{
	if(j>=0 && vFColors.GetCount()>j)
	{
		return vFColors[j];
	}
	else
	{
		Exclamation("Invalid function index!");
		return Null;
	}
}
void Scatter::SetDataThickness(int j, int thick_dots)
{
	if(j>=0 && vPThickness.GetCount()>j)
	{
		vPThickness[j]=thick_dots;
		Refresh();
	}
}
void Scatter::SetFunctThickness(int j, int thick_dots)
{
	if(j>=0 && vFThickness.GetCount()>j)
	{
		vFThickness[j]=thick_dots;
		Refresh();
	}
}
int Scatter::GetDataThickness(int j)
{
	if(j>=0 && vPThickness.GetCount()>j)
	{
		return vPThickness[j];
	}
	else
	{
		Exclamation("Invalid series index!");
		return -1;
	}
}
int Scatter::GetFunctThickness(int j)
{
	if(j>=0 && vFThickness.GetCount()>j)
	{
		return vFThickness[j];
	}
	else
	{
		Exclamation("Invalid series index!");
		return -1;
	}
}
void Scatter::SetMarkWidth(int j, int width_dots)
{
	if(j>=0 && vPWidth.GetCount()>j)
	{
		vPWidth[j]=width_dots;
		Refresh();
	}
}
int Scatter::GetMarkWidth(int j)
{
	if(j>=0 && vPWidth.GetCount()>j)
	{
		return vPWidth[j];
	}
	else
	{
		Exclamation("Invalid series index!");
		return -1;
	}
}
void Scatter::SetMarkStyle(int j, int noStyle)
{
	if(j>=0 && vMarkStyles.GetCount()>j)
	{
		vMarkStyles[j]=noStyle;
		Refresh();
	}
}
int Scatter::GetMarkStyle(int j)
{
	if(j>=0 && vMarkStyles.GetCount()>j)
	{
		return vMarkStyles[j];
	}
	else
	{
		Exclamation("Invalid series index!");
		return -1;
	}
}
void Scatter::SetMarkColor(int j, Acolor mcolor)
{
	if(j>=0 && vMarkColors.GetCount()>j)
	{
		vMarkColors[j]=mcolor;
		Refresh();
	}
}
Acolor Scatter::GetMarkColor(int j)
{
	if(j>=0 && vMarkColors.GetCount()>j)
	{
		return vMarkColors[j];
	}	
	else 
	{
		Exclamation("Invalid series index!");
		return Null;
	}
}
void Scatter::SetShowMark(int j, bool show)
{
	if(j>=0 && vShowMark.GetCount()>j)
	{
		vShowMark[j]=show;       
		Refresh();
	}
}
bool Scatter::IsMarkShow(int j)
{
	if(j>=0 && vShowMark.GetCount()>j)
	{
		return vShowMark[j];
	}
	else 
	{
		Exclamation("Invalid series index!");
		return 0;
	}
}
void Scatter::SetJoin(int j, bool join) 
{
	if(j>=0 && vJoin.GetCount()>j)
	{
		vJoin[j]=join;
		Refresh();
	}
}
bool Scatter::IsJoined(int j)
{
	if(vJoin.GetCount()>j && j>=0)
	{
		return vJoin[j];
	}
	else 
	{
		Exclamation("Invalid series index!");
		return 0;
	}
	
}
void Scatter::SetSmooth(int j, bool smooth) 
{
	if(j>=0 && vSmooth.GetCount()>j)
	{
		vSmooth[j]=smooth;
		Refresh();
	}
}
bool Scatter::IsSmooth(int j)
{
	if(j>=0 && vSmooth.GetCount()>j)
	{
		return vSmooth[j];
	}
	else 
	{
		Exclamation("Invalid series index!");
		return 0;
	}
}   
void Scatter::RemoveSeries(int j)
{
	if (vPointsData.GetCount()>j)
	{
		vPointsData.Remove(j);
		vJoin.Remove(j);
		vSmooth.Remove(j);
		vPColors.Remove(j);
		vPWidth.Remove(j);
		vPThickness.Remove(j);
		vLegend.Remove(j);           
		vMarkColors.Remove(j);
		vShowMark.Remove(j);
		vMarkStyles.Remove(j);
		
		Refresh();
	}
}

void Scatter::PlotFunction(double (*f)(double), String legend, class::Color fcolor, int weight)
{
	double x,y;
	Vector<XY> series;
	for (int i=0;i<=GetNbMax();i++){
		x=i*(xRange/GetNbMax())+xMin;
		y=f(x);
		series<<XY(x,y);
	}
	vFColors.Add(fcolor);
	vFThickness.Add(weight);
	vFunctionData.AddPick(series);
	vFLegend.Add(legend);
	Refresh();  
}
void Scatter::PlotParaFunction(XY (*pf)(double), String legend, class::Color fcolor, int weight,int Np)
{
	double t;//t must be choosed between [0,1]
	Vector<XY> series;
	for (int i=0; i<=Np;i++)
	{
		t=(double)i/Np;
		series<<pf(t);
	}
	vFColors.Add(fcolor);
	vFThickness.Add(weight);
	vFunctionData.AddPick(series);
	vFLegend.Add(legend);
	Refresh();
}
	
int Scatter::GetNbMax()
{
	return int((GetSize().cx-2*px));
}
void Scatter::RemoveFSeries(int j)
{
	if (vFunctionData.GetCount()>j)
	{
		vFunctionData.Remove(j);
		vFColors.Remove(j);
		vFThickness.Remove(j);
		vFLegend.Remove(j);
		Refresh();
	}
}

Drawing& Scatter::GetDrawing()
{
	DrawingDraw ddw(6*GetSize());
	SetDrawing (ddw, 6);
	drawing=ddw;
	return drawing;
}
Image& Scatter::GetImage(int scale)
{
	bool aa=antialiasing;
	antialiasing=false;
	ImageDraw idraw(scale*GetSize());
	SetDrawing (idraw,scale);
	antialiasing=aa;
	img=idraw;
	return img;
}
void Scatter::SaveAsMetafile(const char* file)
{
	WinMetaFileDraw wmfd;	
	wmfd.Create(6*GetSize().cx,6*GetSize().cy,"Scatter","chart",file);
	SetDrawing (wmfd, 6);	
	wmfd.Close();	
}

void Scatter::Paint(Draw& w)
{
	SetDrawing(w,1); 
}

void Scatter::Circle(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	w.DrawLine(cp,cp,int(scale*size/6),markColor);
}

void Scatter::Square(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	Vector <Point> p;
	p<<Point(cp.x-int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5))<<Point(cp.x+int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5))
	<<Point(cp.x+int(size*scale/12+0.5),cp.y+int(size*scale/12+0.5))<<Point(cp.x-int(size*scale/12+0.5),cp.y+int(size*scale/12+0.5))
	<<Point(cp.x-int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5));
	w.DrawPolyline(p,scale/2,markColor); 
	
}
void Scatter::Rectangle(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	w.DrawRect(cp.x-int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5),int(size*scale/6+1.5),int(size*scale/6+1.5),markColor);
}
void Scatter::Triangle(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	Vector <Point> p;
	p<<Point(cp.x,cp.y-int(size*scale/12+0.5))<<Point(cp.x+int(size*scale/12+0.5),cp.y+int(0.6*size*scale/12+0.5))
	<<Point(cp.x-int(size*scale/12+0.5),cp.y+int(0.6*size*scale/12+0.5))
	<<Point(cp.x,cp.y-int(size*scale/12+0.5));
	w.DrawPolyline(p,scale/2,markColor); 
	
}
void Scatter::Cross(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	w.DrawLine(cp.x-int(size*scale/12+0.5),cp.y,cp.x+int(size*scale/12+1.5),cp.y,scale,markColor);
	w.DrawLine(cp.x,cp.y-int(size*scale/12+0.5),cp.x,cp.y+int(size*scale/12+1.5),scale,markColor);
}
void Scatter::XFunct(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	w.DrawLine(cp.x-int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5),cp.x+int(size*scale/12+1.5),cp.y+int(size*scale/12+1.5),scale,markColor);
	w.DrawLine(cp.x+int(size*scale/12+0.5),cp.y-int(size*scale/12+0.5),cp.x-int(size*scale/12+1.5),cp.y+int(size*scale/12+1.5),scale,markColor);
}
void Scatter::Rhomb(Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	Vector <Point> p;
	p<<Point(cp.x,cp.y-int(size*scale/12+0.5))<<Point(cp.x+int(size*scale/12+0.5),cp.y)
	<<Point(cp.x,cp.y+int(size*scale/12+0.5))<<Point(cp.x-int(size*scale/12+0.5),cp.y)
	<<Point(cp.x,cp.y-int(size*scale/12+0.5));
	w.DrawPolyline(p,scale,markColor); 
}
inline void Scatter::DrawMark(int style, Draw& w, int scale, Point cp, int size, class::Color markColor)
{
	switch (style)
	{
		case CIRCLE : Circle(w,scale,cp,size,markColor);break;
		case RECTANGLE :Rectangle(w,scale,cp,size,markColor);break;
		case SQUARE : Square(w,scale,cp,size,markColor);break;
		case TRIANGLE : Triangle(w,scale,cp,size,markColor);break;
		case CROSS : Cross(w,scale,cp,size,markColor);break;
		case X : XFunct(w,scale,cp,size,markColor);break;
		case RHOMB:Rhomb(w,scale,cp,size,markColor);break;
		default : Circle(w,scale,cp,size,markColor);break;
	}
}

void Scatter::Plot(Draw& w, int scale, int l, int h)
{
	int nMajorX=int(xRange/xMajorUnit);
	int nMajorY=int(yRange/yMajorUnit);
	w.DrawRect(0,0,l,h,plotAreaColor);	
	int gW=int(gridWidth*scale/6);
	if(gridWidth<0) gW=gridWidth;   
	if (drawVGrid)       
		for(int i=1; i<nMajorX;i++){
			w.DrawLine(int(i*l/(xRange/xMajorUnit)+0.5),
				0,
				int(i*l/(xRange/xMajorUnit)+0.5),
				h,
				gW,gridColor);
		}
		
	if (drawHGrid)
		for(int i=1; i<nMajorY;i++){
			w.DrawLine(0,
				h-int(i*h/(yRange/yMajorUnit)+0.5),
				l,
				h-int(i*h/(yRange/yMajorUnit)+0.5),
				gW,gridColor);
		}
		
	w.Clip(Rect(0,0,l,h));
	int ix;//int x points coordinates
	int iy;//int y points coordinates
	if (!vPointsData.IsEmpty()){
	for (int j=0; j<vPointsData.GetCount(); j++){
		Vector<Point> p1;
		for (int i=0; i<vPointsData[j].GetCount(); i++)
				{
					ix=int(l*(vPointsData[j][i].x-xMin)/xRange +0.5);
					iy=int(h*(vPointsData[j][i].y-yMin)/yRange+0.5);
					p1<<Point(ix,h-iy);
				}
		if(vJoin[j])
		{
			if(vSmooth[j]&&vPointsData[j].GetCount()>2)
			{
				Vector<Point> p2;
				Vector<XY> v(Cubic(vPointsData[j]));         
				for (int i=0; i<v.GetCount(); i++)
				{
					ix=int(l*(v[i].x-xMin)/xRange +0.5);
					iy=int(h*(v[i].y-yMin)/yRange+0.5);
					p2<<Point(ix,h-iy);
				}
				if(!p2.IsEmpty()) w.DrawPolyline(p2,int(scale*vPThickness[j]/6),vPColors[j],Null);
			}
			
			else if (!p1.IsEmpty()) w.DrawPolyline(p1,int(scale*vPThickness[j]/6),vPColors[j],Null);
		}
			
			
		if(vShowMark[j])
				for (int i=0; i<vPointsData[j].GetCount(); i++){
				
					DrawMark(vMarkStyles[j],w,scale,p1[i],vPWidth[j],vMarkColors[j]);              
										
				}
		}
		
	}

	for (int j=0; j<vFunctionData.GetCount(); j++){
		if(!vFunctionData[j].IsEmpty()){
			Vector<Point> p1;
			for (int i=0; i<vFunctionData[j].GetCount(); i++){
				ix=int(l*(vFunctionData[j][i].x-xMin)/xRange +0.5);
				iy=int(h*(vFunctionData[j][i].y-yMin)/yRange+0.5);
				p1<<Point(ix,h-iy);                         
			}
			w.DrawPolyline(p1,int(scale*vFThickness[j]/6),vFColors[j],Null);
		}
	}
	w.End();
	
}
Vector<XY> Scatter::Cubic(Vector<XY>& DataSet, int fineness,double tension)
{
	Vector<XY> OutSet;
	if(DataSet.GetCount()>2){   
	OutSet<<DataSet[0];
	double t;
	double a0,a1,a2,a3;
	double b0,b1,b2,b3;
	a2=tension*(DataSet[1].y-DataSet[0].y); 
	a0=a2+tension*(DataSet[2].y-DataSet[0].y)+2*DataSet[0].y-2*DataSet[1].y;
	a1=-2*a2- tension*(DataSet[2].y-DataSet[0].y)-3*DataSet[0].y+3*DataSet[1].y;        
	a3=DataSet[0].y;
	
	b2=tension*(DataSet[1].x-DataSet[0].x);
	b0=b2+tension*(DataSet[2].x-DataSet[0].x)+2*DataSet[0].x-2*DataSet[1].x;
	b1=-2*b2- tension*(DataSet[2].x-DataSet[0].x)-3*DataSet[0].x+3*DataSet[1].x;    
	b3=DataSet[0].x;
	
	for (int n=1; n<=fineness; n++)
	{
		t=(double)n/fineness;
		OutSet<<XY(b0*t*t*t+b1*t*t+b2*t+b3, a0*t*t*t+a1*t*t+a2*t+a3);
	}
		
	for (int i=3; i<DataSet.GetCount(); i++)
	{
		a2=tension*(DataSet[i-1].y-DataSet[i-3].y);
		a0=a2+tension*(DataSet[i].y-DataSet[i-2].y)+2*DataSet[i-2].y-2*DataSet[i-1].y;
		a1=-2*a2- tension*(DataSet[i].y-DataSet[i-2].y)-3*DataSet[i-2].y+3*DataSet[i-1].y;      
		a3=DataSet[i-2].y;
		
		b2=tension*(DataSet[i-1].x-DataSet[i-3].x);
		b0=b2+tension*(DataSet[i].x-DataSet[i-2].x)+2*DataSet[i-2].x-2*DataSet[i-1].x;
		b1=-2*b2- tension*(DataSet[i].x-DataSet[i-2].x)-3*DataSet[i-2].x+3*DataSet[i-1].x;      
		b3=DataSet[i-2].x;
		
		for (int n=1; n<=fineness; n++)
		{
			t=(double)n/fineness;
			OutSet<<XY(b0*t*t*t+b1*t*t+b2*t+b3, a0*t*t*t+a1*t*t+a2*t+a3);
		}
	}
	
	int nd=DataSet.GetCount()-1;
	a2=tension*(DataSet[nd].y-DataSet[nd-2].y); 
	a0=a2+tension*(DataSet[nd].y-DataSet[nd-1].y)+2*DataSet[nd-1].y-2*DataSet[nd].y;
	a1=-2*a2- tension*(DataSet[nd].y-DataSet[nd-1].y)-3*DataSet[nd-1].y+3*DataSet[nd].y;        
	a3=DataSet[nd-1].y;
		
	b2=tension*(DataSet[nd].x-DataSet[nd-2].x);
	b0=b2+tension*(DataSet[nd].x-DataSet[nd-1].x)+2*DataSet[nd-1].x-2*DataSet[nd].x;
	b1=-2*b2- tension*(DataSet[nd].x-DataSet[nd-1].x)-3*DataSet[nd-1].x+3*DataSet[nd].x;        
	b3=DataSet[nd-1].x;
		
		for (int n=1; n<=fineness; n++)
		{
			t=(double)n/fineness;
			OutSet<<XY(b0*t*t*t+b1*t*t+b2*t+b3, a0*t*t*t+a1*t*t+a2*t+a3);
		}
		
	}
	return Vector<XY>(OutSet);
	
}
void Scatter::SetDrawing(Draw& w, int scale)
{
	w.DrawRect(scale*GetSize(),graphColor);
	
	Size sz;
	sz.cx=0;
	sz.cy=0;    
	if(!title.IsEmpty()) 
	{
		Font FontTitle6;
		FontTitle6=titleFont;
		FontTitle6.Height(scale*titleFont.GetHeight());
		FontTitle6.Width(scale*titleFont.GetWidth());
		sz= GetTextSize(title, FontTitle6);
		w.DrawText((scale*GetSize().cx-sz.cx)/2,scale*2,title,FontTitle6,titleColor);   
	}
	
	w.Offset(Point(scale*px,scale*py+sz.cy));
	if(showLegend) DrawLegend(w,scale);
	int l=scale*GetSize().cx-2*scale*px;
	int h=scale*GetSize().cy-2*scale*py-sz.cy;
	w.DrawRect(0,-1-scale/6,l+1+scale/6,h+1+1*scale/6,Gray);
	Font FontLabel6;
	FontLabel6=labelsFont;
	FontLabel6.Height(scale*labelsFont.GetHeight());
	
	Size lx=GetTextSize(xLabel,FontLabel6);
	Size ly=GetTextSize(yLabel,FontLabel6);
	w.DrawText(int((l-lx.cx)/2),h+scale*py-lx.cy-scale*2,xLabel,FontLabel6,labelsColor);
	w.DrawText(scale*2-scale*px,int((h+ly.cx)/2),900,yLabel,FontLabel6,labelsColor);
	int nMajorX=int(xRange/xMajorUnit);
	int nMajorY=int(yRange/yMajorUnit);
	int nrX=int(l/nMajorX);
	int nrY=int(h/nMajorY);		
	
	if (drawXReticle)
		for(int i=1; i<=nMajorX;i++){
			w.DrawLine(int(i*l/(xRange/xMajorUnit)+0.5),
				h,
				int(i*l/(xRange/xMajorUnit)+0.5),
				h+scale*4,
				int(scale/2),
				axisColor);             
			Font Standard6;
			Standard6.Height(scale*StdFont().GetHeight());  
			int dx=scale*int(GetTextSize(AsString(i*xMajorUnit+xMin),StdFont()).cx/2);  
			w.DrawText(int(i*l/(xRange/xMajorUnit))-dx,h+scale*4,AsString(i*xMajorUnit+xMin),Standard6,axisColor);  
		}
		
	if (drawYReticle)
		for(int i=1; i<=nMajorY;i++){
			w.DrawLine(-(scale*4),
				h-int(i*h/(yRange/yMajorUnit)+0.5),
				0,
				h-int(i*h/(yRange/yMajorUnit)+0.5),
				int(scale/2),
				axisColor);
			int dx=scale*GetTextSize(AsString(i*yMajorUnit+yMin),StdFont()).cx;
			Font Standard6;
			Standard6.Height(scale*StdFont().GetHeight());  
			w.DrawText(-dx-scale*6,h-scale*6-int(i*h/(yRange/yMajorUnit)),AsString(i*yMajorUnit+yMin),Standard6,axisColor);
		}	

	if(antialiasing && !w.IsDrawing() && !w.IsMetaFile())
	{
		ImageDraw imdraw(3*l,3*h);	
		Plot (imdraw,3,3*l,3*h);
		w.DrawImage(0,0,l,h,imdraw);
	}	
	else Plot(w,scale,l,h);		

	w.DrawLine(0,h,l,h,int(axisWidth*scale/6),axisColor);
	w.DrawLine(0,h,0,0,int(axisWidth*scale/6),axisColor);
	w.End();
}
	
Scatter::Scatter():
	title (""),
	titleColor(Black),
	graphColor(White),
	titleFont(Roman(20)),
	xLabel(""),yLabel(""),
	labelsFont(StdFont()),
	labelsColor(Black),
	plotAreaColor(Color::Color(245,245,248)),
	axisColor(Black),
	axisWidth(3),
	px(30),
	py(30),
	xRange(100.0),
	yRange(100.0),
	xMajorUnit(xRange/10),
	yMajorUnit(yRange/5),
	xMin(0.0),
	yMin(0.0),
	gridColor(Color::Color(102,102,102)),
	gridWidth(-4),
	drawXReticle(true), drawYReticle(true),
	drawVGrid(true), drawHGrid(true),
	showLegend(true),legendWeight(80),
	antialiasing(false)       
{
	Color(graphColor);	
	BackPaint();        
}

Scatter::~Scatter()
{
}

