/*
ScatterChart Control
V0.4, Dec 2006
Copyright (C) 2006, Andrei-Catalin  
*/
#ifndef _Scatter_Scatter_h
#define _Scatter_Scatter_h

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

typedef Pointf XY;
typedef class::Color Acolor;
class Scatter : public StaticRect {
public:
	
	enum MarkStyle 
	{
		CIRCLE,
		RECTANGLE,
		SQUARE,
		TRIANGLE,
		CROSS,
		X,
		RHOMB 
	};	
			
	virtual void  Paint(Draw& w);	
	
	void SetDrawing(Draw& w,int scale);
	void Circle(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Square(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Rectangle(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Triangle(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Cross(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void XFunct(Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Rhomb(Draw& w, int scale, Point cp, int size, class::Color markColor);
	inline void DrawMark(int style,Draw& w, int scale, Point cp, int size, class::Color markColor);
	void Plot(Draw& w,int scale,int l,int h);
		
	//virtual void  LeftDown(Point, dword);
	Scatter& SetColor(class::Color _color);
	Scatter& SetTitle(String _title);
	Scatter& SetTitleFont(Font& fontTitle);
	Scatter& SetTitleColor(class::Color colorTitle);
	
	void SetLabels(String _xLabel,String _yLabel);
	Scatter& SetLabelX(String _xLabel);
	Scatter& SetLabelY(String _yLabel);
	Scatter& SetLabelsFont(Font& fontLabels);
	Scatter& SetLabelsColor(class::Color colorLabels);
	
	Scatter& SetPlotAreaPoz(int poz_x,int poz_y);
	Scatter& H_Border(int poz_x);
	Scatter& V_Border(int poz_y);
	Scatter& SetPlotAreaColor(class ::Color p_a_color);
	
	Scatter& SetAxisColor(class::Color axis_color);
	Scatter& SetAxisWidth(int axis_width);
	
	Scatter& SetGridColor(class::Color grid_color);
	Scatter& SetGridWidth(int grid_width);
	Scatter& ShowVGrid(bool show);
	Scatter& ShowHGrid(bool show);
	
	Scatter& ShowLegend(bool show=true);
	Scatter& SetLegendWeight(int weight);
	
	Scatter& SetAntialiasing(bool aa=true);
	void DrawLegend(Draw& w,int scale);
	
	void SetRange(double rx, double ry);
	void SetMajorUnits(double ux, double uy);
	void SetXYMin(double xmin,double ymin);	
	
	void AddSeries (Vector<XY> & points,String legend="", bool join=false,class::Color pcolor=LtBlue,int width=30,int thickness=6);

	void SetData(int nbSeries, int index, XY & point);
	void AddPoint(int nbSeries, XY & point);
	void InsertPoint(int nbSeries, int index, XY & point);
	void RemovePoint(int nbSeries, int index);
	
	void SetDataColor(int j,class::Color pcolor);
	void SetFunctColor(int j, class::Color fcolor);
	class::Color GetDataColor (int j);
	class::Color GetFunctColor (int j);	
	
	void SetDataThickness(int j, int thick_dots);
	void SetFunctThickness(int j,int thick_dots);
	int GetDataThickness(int j);
	int GetFunctThickness(int j);
	void SetMarkWidth(int j, int width_dots);
	int GetMarkWidth(int j);
	void SetMarkStyle(int j, int noStyle);
	int GetMarkStyle(int j);
	void SetMarkColor(int j,class::Color pcolor);
	class::Color GetMarkColor (int j);
	void SetShowMark(int j, bool show=true);
	bool IsMarkShow(int j);
	
	void SetJoin(int j, bool join=true);
	bool IsJoined(int j);
	
	void SetSmooth(int j, bool smooth=true);
	bool IsSmooth(int j);	
	
	void RemoveSeries(int j);
	void SetData(int nbSeries, Vector<XY> & points);	
	Vector<Vector<XY> > & GetData() {return vPointsData;}
	Vector<Vector<XY> > & GetFData() {return vFunctionData;}
		
	
	void PlotFunction(double (*f)(double),String legend="", class::Color fcolor=Green,int weight=6);
	void PlotParaFunction(XY (*pf)(double),String legend="", class::Color fcolor=Green,int weight=6,int Np=50);
	void RemoveFSeries(int j);
	int GetNbMax(); //max number of points along X axis
	
	Vector<XY> Cubic (Vector<XY>& DataSet, int fineness=10, double tension=0.4);
	
	Drawing& GetDrawing();
	Image& GetImage(int scale=1);
	void SaveAsMetafile(const char* file);

private:
	class ::Color graphColor;	
	String title;
	Font titleFont;
	class::Color titleColor;
	
	String xLabel, yLabel;
	Font labelsFont;
	class::Color labelsColor;
	
	int px, py;
	class ::Color plotAreaColor;
	
	class::Color axisColor;
	int axisWidth;
	
	double xRange,yRange;
	double xMin,yMin;
	double xMajorUnit,yMajorUnit;
	bool drawXReticle, drawYReticle;
	
	class::Color gridColor;
	int gridWidth;
	bool drawVGrid, drawHGrid;		
	
	Vector<Vector<XY> > vPointsData,vFunctionData;
	Vector<class::Color> vPColors,vFColors;
	Vector<int> vFThickness,vPThickness;
	Vector<int> vPWidth;
	Vector<bool> vJoin;
	Vector<bool> vSmooth;
	Vector<class::Color> vMarkColors;
	Vector<bool> vShowMark;
	Vector<int> vMarkStyles;
	Drawing drawing;
	Image img;
	
	Vector<String> vLegend;
	Vector<String> vFLegend;
	bool showLegend;
	int legendWeight;
	bool antialiasing;			

public:
	Scatter();
	~Scatter();
};


#endif

