
#include "pagination.h"

#define IMAGECLASS Img
#define IMAGEFILE <pagination/pagination.iml>
#include <Draw/iml_source.h>

TableWidget::TableWidget()
{
	CtrlLayout(*this);
	Sizeable().Zoomable();
	
	first_page.SetImage(Img::first);
	last_page.SetImage(Img::last);
	up_page.SetImage(Img::up);
	next_page.SetImage(Img::next);
	
	record_page = 52;
    total_page = 0;
    curr_page = 0;
    
    record.SetData(record_page);
    
    first_page <<= THISBACK(firstpage);
    up_page <<= THISBACK(uppage);
    next_page <<= THISBACK(nextpage);
    last_page <<= THISBACK(lastpage);
    page_list <<= THISBACK(JumpPage);
    record.WhenEnter = THISBACK(SetRecord);

}

void TableWidget::set_columnWidth(int col,int width)
{
	//TODO
	table.ColumnWidths("%width");
}

void TableWidget::set_record_page(int num)
{
	record_page = num;
	updata_data(data);
}

void TableWidget::SetRecord()
{
	set_record_page(~record);
}

void TableWidget::set_title(Vector<String> vtitle)
{
	for( int i=0;i< vtitle.GetCount();i++)
	{
		table.AddColumn(vtitle[i]);
	}
}

void TableWidget::firstpage()
{
	curr_page = 0;
    insert_data(curr_page);

}

void TableWidget::lastpage()
{
	curr_page = total_page-1;
    insert_data(curr_page);
}

void TableWidget::uppage()
{
	if(curr_page == 0) 
	{
		return;
	}
	curr_page--;
    insert_data(curr_page);
}

void TableWidget::nextpage()
{
	if(curr_page == total_page) return;
	curr_page++;
    insert_data(curr_page);
}

void TableWidget::updata_data(Vector<Vector<String> > curr_data)
{
	data.Clear();
    Vector<String> line;
    line.Clear();
    for(int i=0;i<curr_data.GetCount();i++)
    {
        data.Add(line);
        for(int j=0;j<curr_data.At(i).GetCount();j++)
        {
            data[i].Add(curr_data[i][j]);
        }
    }
    total_page = (data.GetCount()%record_page==0)?(data.GetCount()/record_page):(idivfloor(data.GetCount(),record_page)+1);
    all_page.SetText(Format("共%d页",total_page));
    page_list.Clear();
    for(int i=1;i<=total_page;i++)
    {

    	page_list.Add(i);
    }
    insert_data(curr_page);
	

}

void TableWidget::insert_data(int page)
{
	table.Clear();
	table.SetCount(0);
	for(int i=0;i<record_page;i++)
   {
      if(((page)*record_page+i)>=data.GetCount())
      {
          break;
      }
      table.Insert(i);
      for(int j=0;j<data.At(page*record_page+i).GetCount();j++)
      {
          table.Set(i,j,data[(page)*record_page+i][j]);
      }
   }
	
	page_list.SetIndex(page);
   first_page.Enable(true);
   up_page.Enable(true);
   next_page.Enable(true);
   last_page.Enable(true);
   if(page==0)
   {
      first_page.Enable(false);
      up_page.Enable(false);
   }
   if(page==total_page-1)
   {
      last_page.Enable(false);
      next_page.Enable(false);
   }
}

void TableWidget::jump_page(int page)
{
	curr_page = page - 1;
    insert_data(curr_page);
}

void TableWidget::JumpPage()
{
	jump_page(~page_list);
}