#ifndef _allegro5_scope_scope_h_
#define _allegro5_scope_scope_h_

template<class T>
void al_destroy(T *object) {
	object(); // To get unimplemented al_destroy functions with object type.
}

#define SCOPE(type, x) template <>\
inline void al_destroy(type *object) { x(object); }
#include "scopetypes.inc"
#undef SCOPE

template<class T>
class Scope {
protected:
	T *object;
public:
	Scope() : object(NULL)  {}
	Scope(T *x) : object(x) {}
	~Scope()                { Destroy(); }
	inline void Destroy()   { if (object) { al_destroy(object); object = NULL; } }
	Scope& operator=(T *x)  { object = x; return *this; }
	T *GetObject()          { return object; }
	T *operator~()          { return object; }
	T *operator->()         { return object; }
	bool IsEmpty()          { return object == NULL; }
};

#define CONCAT_DEF(a, b) a##b
#define CONCAT(a, b)    CONCAT_DEF(a, b)
#define ENUM_NAME(name) CONCAT(E_, name)
#define SCOPE(type, x) ENUM_NAME(type),
enum E_TYPES {
	#include "scopetypes.inc"
};
#undef SCOPE

template <class T>
E_TYPES al_get_destroy_enum(T *object) {
	object();
}

#define SCOPE(type, x) template <>\
inline E_TYPES al_get_destroy_enum(type *object) {\
	return ENUM_NAME(type);\
}
#include "scopetypes.inc"
#undef SCOPE
#undef ENUM_NAME

#define DESTROY_NAME(name) CONCAT(al_void_destroy_, name)
#define SCOPE(type, x)\
static void DESTROY_NAME(type)(void *object) {\
	type *p = (type *)object;\
	if (p) { x(p); p = NULL; }\
}
#include "scopetypes.inc"
#undef SCOPE

inline void al_void_destroy(void *object, E_TYPES type)
{
#define SCOPE(type, x) DESTROY_NAME(type),
	typedef void (*Destroy)(void *object);
	static Destroy void_destroy_list[] = {
#include "scopetypes.inc"
	};
#undef SCOPE
	void_destroy_list[(int)type](object);
}
#undef DESTROY_NAME

#include <map>
#include <queue>

class ScopeList {
protected:
	template <class T>
	struct greater_second : std::binary_function<T, T, bool> {
		inline bool operator()(const T& lhs, const T& rhs) {
			return lhs.second > rhs.second;
		}
	};

	typedef std::pair<void *, E_TYPES> map_pair;
	std::map<void *, E_TYPES> list;
public:
	~ScopeList()             { Destroy(); }
	template <class T>
	T *Add(T *object)        { object(); return object; }
	template <class T>
	T *operator<<(T *object) { return Add(object); }
	bool IsEmpty() const     { return list.empty(); }
	void Destroy() {
		if (list.empty()) return;

		std::priority_queue<map_pair, std::deque<map_pair>, greater_second<map_pair> >
			pq(list.begin(), list.end());

		while (!pq.empty()) {
			const map_pair& p = pq.top();
			al_void_destroy(p.first, p.second);
			pq.pop();
		}

		list.clear();
	}
};

#define SCOPE(type, x) template <>\
inline type *ScopeList::Add(type *object) {\
	list.insert(map_pair((void *)object, al_get_destroy_enum(object)));\
	return object;\
}
#include "scopetypes.inc"
#undef SCOPE

#undef CONCAT
#undef CONCAT_DEF

#endif
