#include "App.h"

bool GameEngine::Init(int w, int h)
{
	if (!al_init()) {
		SetError("Failed to initialize Allegro");
		return false;
	}

	if (!al_install_keyboard()) {
		SetError("Failed to install keyboard");
		return false;
	}

	redrawSpeed = ALLEGRO_BPS_TO_SECS(60);
	timer = sl << al_create_timer(redrawSpeed);
	queue = sl << al_create_event_queue();
	width = w, height = h;
	display = sl << al_create_display(width, height);

	al_register_event_source(queue, al_get_display_event_source(display));
	al_register_event_source(queue, al_get_keyboard_event_source());
	al_register_event_source(queue, al_get_timer_event_source(timer));

	return true;
}

void GameEngine::Run()
{
	al_clear_to_color(al_map_rgb(0, 0, 0));
	al_flip_display();

	bool redraw = true;
	al_start_timer(timer);
	
	ALLEGRO_COLOR color;

	for (ALLEGRO_EVENT event;;) {
		al_wait_for_event(queue, &event);

		if (event.type == ALLEGRO_EVENT_TIMER) {
			redraw = true;
			color = al_map_rgb(rand() % 255 , rand() % 255, rand() % 255);
			int x = rand() % width,
				y = rand() % height;

			al_draw_pixel(x, y, color);
			if (rand() % 10 == 5) {
				al_draw_pixel(x, y - 1, color);
				al_draw_pixel(x, y + 1, color);
				al_draw_pixel(x - 1, y, color);
				al_draw_pixel(x + 1, y, color);
			}
		} else
		if (event.type == ALLEGRO_EVENT_KEY_DOWN) {
			const int key = event.keyboard.keycode;
			if (key == ALLEGRO_KEY_ESCAPE)
				break;
		} else
		if (event.type == ALLEGRO_EVENT_DISPLAY_CLOSE)
			break;

		if (redraw && al_event_queue_is_empty(queue)) {
			redraw = false;
			al_flip_display();
		}
	}
}
