function toggleBarVisibility() {
	var e = document.getElementById("bar_blank");
	e.style.display = (e.style.display == "block") ? "none" : "block";
}

function createRequestObject() {
	var http;
	if (navigator.appName == "Microsoft Internet Explorer") {
		http = new ActiveXObject("Microsoft.XMLHTTP");
	}
	else {
		http = new XMLHttpRequest();
	}
	return http;
}

function sendRequest() {
	var http = createRequestObject();
	var session = document.getElementById('session').value;
	var time = document.getElementById('submittime').value;
	http.open("GET", "progress?uploadid=" + session + time);
	http.onreadystatechange = function () { handleResponse(http); };
	http.send(null);
}

function handleResponse(http) {
	var response;
	if (http.readyState == 4) {
		response = http.responseText;
		document.getElementById("bar_color").style.width = response + "%";
		document.getElementById("status").innerHTML = response + "%";
		
		if (response < 100) {
			setTimeout("sendRequest()", 200);
		}
		else {
			toggleBarVisibility();
			document.getElementById("status").innerHTML = "Done.";
		}
	}
}

function startUpload() {
	// sets an unique 'uploadid' field composed by session cookie and current time
	var session = document.getElementById('session').value;
	var time = Date.now();
	document.getElementById('submittime').value = time;
	this.action = "upload?uploadid=" + session + time;
	document.getElementById("bar_color").style.width = 0;
	toggleBarVisibility();
	setTimeout("sendRequest()", 200);
}

(function () {
	document.getElementById("myForm").onsubmit = startUpload;
})();
