#include <CtrlLib/CtrlLib.h>

#include <Protect/Protect.h>

using namespace Upp;

#define LAYOUTFILE <ProtectCrash/protectCrash.lay>
#include <CtrlCore/lay.h>

struct MyApp : WithMyAppLayout<TopWindow> {

	typedef MyApp CLASSNAME;
	MyApp()
	{
		CtrlLayout(*this, "Protect test");
	}
};

String GetKey(void)
{
	String rv = ScanHexString("AABBCCDDEEFF00112233445566778899");
	
	return rv;
}

void Decrypt(byte *start, size_t len, byte const *nonce, size_t nonceLen)
{
	PROTECT_DECRYPT ( start, len, GetKey(), nonce, nonceLen );
}

void DoMain()
{
	PROTECT_START_FUNC(Decrypt);
	
	MyApp app;
	app.Run();	
	
	PROTECT_END_FUNC;
}

GUI_APP_MAIN
{
	ON_PROTECT_BAD_KEY(Decrypt)
	{
		bool res = PromptYesNo("Bad key !!&Do you want to continue anyways ?");
		if(!res)
			exit(0);
	}

	DoMain();				
}

