#include <ScatterCtrl/ScatterCtrl.h>
using namespace Upp;

#define LAYOUTFILE <TestScatter/TestScatter.lay>
#include <CtrlCore/lay.h>

class TestScatter : public WithTestScatterLayout<TopWindow> {
public:
	enum {
		NPOINTS = 1000,
	};
	typedef TestScatter CLASSNAME;
	Vector<Pointf> points;
	TestScatter();
};

TestScatter::TestScatter()
{
	int x,y,yMax = 0;
	
	
	points.SetCount(NPOINTS);
	Pointf * pv = points.Begin();
	
	for(x = 0; x < NPOINTS; x++, pv++) {
		pv->x = (double)x;
		y = rand();
		if(yMax < y) {
			yMax = y;
		}
		pv->y = (double)(y);
	}
	
	sv.AddSeries(points).Legend("Y").Opacity(0.3).NoMark().Stroke(1);
	sv.SetFastViewX().SetSequentialX().SetDrawXReticle().SetDrawYReticle().SetSequentialXAll();
	sv.ShowInfo().ShowContextMenu().SetMouseHandling().SetMaxZoom(1000).SetMinZoom(10);
	sv.ShowHGrid(false).ShowVGrid(false).SetLabels("X","Y");
	sv.SetXYMin(0,0,0).SetRange(NPOINTS, yMax);
	sv.Refresh();

	Zoomable().Sizeable();
	CtrlLayout(*this, "Window title");
}

GUI_APP_MAIN
{
	TestScatter().Run();
}
