#include "PierHB.h"

VectorMap<String, Array<ComRequest> > 		reqBuffer;

void App::OpenNetwork() 
{
  unsigned int i, k;
  String r, porta;
  unsigned char nh[40];
	
	if(!networkOpen) 
	{
	  openBus = true;
	  
	  cs.success = 0;
	  cs.getErrors = 0;
	  cs.busFaults = 0;
	  cs.chkErrors = 0;
	  cs.datErrors = 0;
	  cs.tmtErrors = 0;
	  cs.pckErrors = 0;
	  cs.pckTmtErrors = 0;
	  cs.putErrors = 0;
	  cs.othErrors = 0;
	  cs.contErrors = 0;

	  //networkOpen = true;	
		fLeftSide.gMainTab.ClearFrames();
		fLeftSide.gMainTab.Reset();
    nodo.Clear();
		ei.Clear();
		es.Clear();
		eb.Clear();
		eh.Clear();
		itemDev.Clear();
		device.Clear();
		gDevice.Clear();
	  k = 0;
	  
  	Progress p;
  	p.SetTotal(fComDriver.gLastNode - fComDriver.gFirstNode);
	  p.Title(t_("Network scan... Wait!"));
	  p.AlignText(Ctrl::LEFT);
	  int l = 0;

	  for(i = (unsigned)fComDriver.gFirstNode; i <= (unsigned)fComDriver.gLastNode; i++) 
    {
      ComVar cv;
		  ReadVar(i, 0x1B, 0x0006, 1, &cv, true);
		  if(cv.r == 0) 
		  {
		    nodo.At(k).nt = cv.var[0];
		    
		    /* get node header data */
		    bool x = true;
		    for(int e = 0; e < 5; e++)
		    {
		      ReadVar(i, 'r', (e * 8), 8, &cv, true);
		      if(cv.r != 0)
		      {
		        x = false;
		        e = 6;
		      }
		      else memcpy((void *)&nh[e * 8], cv.var, 8);
		    }

				if(x == true)
				{
					/* check if the node type is correct. Only E101 are allowed */
					if(nh[0] == 'E' && nh[1] == 101)
					{
				    nodo.At(k).errCntr = 0;
				    nodo.At(k).lastErr = 0;
				    nodo.At(k).ctrlId = -1;		    
				    nodo.At(k).ctrlOpened = false;
				    nodo.At(k).modify = false;
				    nodo.At(k).acceptModify = false;
				    nodo.At(k).addr = i;

		      	memcpy((char *)&nodo.At(k).tipo, (char *)&nh[0], 1);
		      	memcpy((char *)&nodo.At(k).codice, (char *)&nh[1], 2);
		      	nodo.At(k).versione = nh[3] + nh[4] * 256;
		      	nodo.At(k).patch = nh[5] + nh[6] * 256;
		      	memcpy((char *)&nodo.At(k).model, (char *)&nh[7], 1);
			      memcpy((char *)&nodo.At(k).cfg1, (char *)&nh[8], 8);
			      memcpy((char *)&nodo.At(k).cfg2, (char *)&nh[16], 8);
			      memcpy((char *)&nodo.At(k).prtVer, (char *)&nh[25], 2);      
			      memcpy((char *)&nodo.At(k).prtPatch, (char *)&nh[27], 2);
			      memcpy((char *)&nodo.At(k).sn, (char *)&nh[32], 8);

			      r.Clear();
				    r.Cat(nodo.At(k).tipo);
				    r.Cat(String(String("000") + AsString(nodo.At(k).codice)).Right(3) + "." + String(String("000") + AsString((unsigned int)nodo.At(k).model)).Right(3) + "-V" + AsString(nodo.At(k).versione) + "." + AsString(nodo.At(k).patch));
		
				    int l = xn("Devices").FindTag(r);
			      if(l >= 0)
			      {
			        device.At(k) = xn("Devices").At(l); 			        
			      }
			      
			      k++;
					}
				}
		  }
		  l++;
		  p.Set(l, fComDriver.gLastNode - fComDriver.gFirstNode);
	  }
	  p.Close();
	  
	  if(k > 0) networkOpen = true;
	  else openBus = false;
  }
  else 
  {
    goOffline = true;
    if(commLoop == 1) return;
	  goOffline = false;
    networkOpen = false;
    fLeftSide.gMainTab.WhenSet.Clear();    
  }

  InitTree();
}

void App::CommLoop(void)
{
  String porta;

	while(true)
	{
	  if(openBus == true)
	  {
		  if(iniKeys.GetPut("Application").GetPut("UsedCommDriver").GetLength() > 0) 
		  {
		    gStat1.Set(iniKeys.GetPut("Application").GetPut("UsedCommDriver"));
		    if(iniKeys.GetPut("Application").GetPut("UsedCommDriver") == "RS232(USB)-AsBus")
		    {
		      Bus().Load(ConfigFile("AsBus.dll"));
		    }
		    else
		    if(iniKeys.GetPut("Application").GetPut("UsedCommDriver") == "RS232(USB)-HBus")
		    {
		      Bus().Load(ConfigFile("HBus.dll"));
		    }
		    else
		    {
			    Exclamation(t_("The communication driver has not yet been configured."));
			    break;	      
		    }
		  }
		  else 
		  {
		    Exclamation(t_("The communication driver has not yet been configured."));
		    break;
		  }
	
		  if(iniKeys.GetPut("CommDriver").GetPut("PortaCOM").GetLength() > 0) 
		  {
	    	porta = iniKeys.GetPut("CommDriver").GetPut("PortaCOM");
	    	ln = ScanInt(iniKeys.GetPut("CommDriver").GetPut("Nodo"));
	    	gStat2.Set(iniKeys.GetPut("CommDriver").GetPut("PortaCOM") + " - " + iniKeys.GetPut("CommDriver").GetPut("Nodo"));
		  }
			else
			{
				Exclamation(t_("The communication driver has not yet been configured."));
			}
		
		  vBusHandle = Bus().OpenPort(porta);
		  if(!Bus().IsPortOpen(vBusHandle)) 
		  {
		    Exclamation(t_("Error opening the port. The COM port could be in use or unavailable."));
		    break;
		  }

	    commLoop = 1;
	  
			for(int i = 0; i < reqBuffer.GetCount(); i++)
			{
			  Array<ComRequest> &v = reqBuffer[i];
	
				for(int j = 0; j < v.GetCount(); j++)
				{
				  if(Bus().IsPortOpen(vBusHandle) && commLoopStop == 0)
				  if(true)
				  {
				    
				    if(v[j].reqCode == 'G' || v[j].reqCode == 'r' || v[j].reqCode == 'R' && v[j].req)
				    {
							v[j].r = Bus().GetData(vBusHandle, ln, v[j].remAddr, v[j].reqCode, v[j].addr, v[j].len, (const char *)v[j].var.var);
							if(v[j].r == 0) 
							{
								v[j].req = false;
								v[j].done = true;
								v[j].error = false;
							}
							else
							{
								RLOG(String("CommLoop(): GetData - j=" + AsString(j) + ", r=" + AsString(v[j].r)));
								v[j].req = false;
								v[j].done = false;
								v[j].error = true;
							}
				    }
				    else if(v[j].reqCode == 'S' || v[j].reqCode == 'w' || v[j].reqCode == 'W' && v[j].req)
				    {
							v[j].r = Bus().PutData(vBusHandle, ln, v[j].remAddr, v[j].reqCode, v[j].addr, v[j].len, (const char *)v[j].var.var);
							if(v[j].r == 0) 
							{
								v[j].req = false;
								v[j].done = true;
								v[j].error = false;
							}
							else 
							{
								RLOG(String("CommLoop(): PutData - j=" + AsString(j) + ", r=" + AsString(v[j].r)));
								v[j].req = false;
								v[j].done = false;
								v[j].error = true;
							}
				    }
				  }
	    	  if(terminated == 1) break;
				}
	  	  if(terminated == 1) break;
			}
		}
		else
		{
	    commLoop = 0;
      if(Bus().IsPortOpen(vBusHandle)) Bus().ClosePort(&vBusHandle);	  
		}
	  if(terminated == 1) break;
	}

  commLoop = 0;
  if(Bus().IsPortOpen(vBusHandle)) Bus().ClosePort(&vBusHandle);	  
	
  AtomicDec(threads);
  return;
}

bool App::ReadVar(unsigned char node, unsigned char code, unsigned int addr, unsigned char len, ComVar *ret, bool sync)
{
	String n = AsString(node);

	while(true)	
	{
		Array<ComRequest> &v = reqBuffer.GetAdd(n);
		int j;
		for(j = 0; j < v.GetCount(); j++)
		{
			if(v[j].remAddr == node && v[j].reqCode == code && v[j].addr == addr && v[j].len == len)
			{
			  if(v[j].done)
			  {
					memcpy(ret->var, v[j].var.var, len);
					v[j].done = false;
					v[j].req = true;
					ret->quality = 100;
					ret->r = v[j].r;
					return true;
			  }
			  else if(v[j].error)
			  {
					v[j].done = false;
					v[j].req = true;
					v[j].error = false;
					ret->quality = 0;
					ret->r = v[j].r;
					return true;
			  }
			  else
			  {
			  	if(!sync)
			  	{
						memcpy(ret->var, v[j].var.var, len);
						v[j].req = true;
						ret->quality = 50;
						ret->r = v[j].r;
						return true;			  		
			  	}
			  	else j = v.GetCount() + 2;
			  }
			}
		}
	
		if(j == v.GetCount())
		{
			ComRequest r;
		
			r.remAddr = node;
			r.reqCode = code;
			r.addr = addr;
			r.len = len;
			r.req = true;
			r.done = false;
			for(int k = 0; k < len; k++) r.var.var[k] = 0;
			memcpy(ret->var, r.var.var, len);
			v.Add(r);
			ret->quality = 0;	
			ret->r = 0;
			if(!sync) break;
		}
	}
	return false;
}

bool App::WriteVar(unsigned char node, unsigned char code, unsigned int addr, unsigned char len, ComVar *data, bool sync)
{
	String n = AsString(node);

	while(true)	
	{
		Array<ComRequest> &v = reqBuffer.GetAdd(n);
		for(int j = 0; j < v.GetCount(); j++)
		{
			if(v[j].remAddr == node && v[j].reqCode == code && v[j].addr == addr && v[j].len == len)
			{
			  if(sync == true && (v[j].done == true || v[j].error == true))
			  {
			  	v[j].req = false;
			  	v[j].done = false;
			  	return true;  
			  }
			  if(v[j].req == false)
			  {
					memcpy(v[j].var.var, data->var, len);
					v[j].done = false;
					v[j].req = true;
					if(sync == false) return true;
			  }
			}
		}
	
		ComRequest r;
	
		r.remAddr = node;
		r.reqCode = code;
		r.addr = addr;
		r.len = len;
		r.req = true;
		r.done = false;
		memcpy(r.var.var, data->var, len);
		v.Add(r);
		if(sync == false) return true;
	}
	return false;
}

void App::CommBuffRemoveKey(unsigned char k)
{
	String key = AsString(k);
	reqBuffer.RemoveKey(key);
	
	return;
}