#include "PierHB.h"

GUI_APP_MAIN 
{
	LoadIniKeys(GetExeDirFile("Config.ini"), iniKeys);
  SetLanguage(LNGFromText(iniKeys.GetPut("Application").GetPut("Language")));
	SetDefaultCharset(CHARSET_UTF8);
  
	const Vector<String>& arg = CommandLine();
	for(int i = 0; i < arg.GetCount(); i++) 
	{
		if(arg[i] == "--uninstall") 
		{
			Uninstall();
			return;
		}  
	}

	Updates();						// be sure that all files was updated

	if(!Bus()) 
	{
		Exclamation(t_("Can not load library \"AsBus.dll\". The program is closed."));	
		return;
	}
  
  /* Get the devices tags list */
	xn = ParseXML(LoadFile(ConfigFile("Support/Devices.map")));
	if(xn("Devices").GetCount() < 1)
	{
    Exclamation(t_("Nodes catalogue absent or damaged. Unable to continue."));
    return;  	  
	}

	App app;
	app.Run();
	
	//Bus().Free();	
	
	Updates();						// Update downloaded files

}

App::App() 
{
	Draw::SetStdFont(Tahoma(11));
  
	CtrlLayout(*this, t_("PierHB Manager"));
	Sizeable().MaximizeBox().MinimizeBox();
	Icon(AppImg::PierHB_0_16());
	WhenClose = THISBACK(Quit);	
		
  // Layouts
	CtrlLayoutOKCancel(fPrgSettings, t_("Program settings"));
	CtrlLayout(fComDriver);
	CtrlLayoutOKCancel(fStpDrvBase, t_("Driver settings"));
	//CtrlLayout(fMainTab);
	CtrlLayout(fLeftSide);

	// Top frames
	AddFrame(bMenu);
	AddFrame(TopSeparatorFrame());
	//AddFrame(bTools);
	//AddFrame(TopSeparatorFrame());
	bMenu.Set(THISBACK(MainMenu));
  //SetToolsBar();  
  
  // Frame
	gMainFrame << fLeftSide;
  gLeftFrame.VSizePosZ(0, 22);
  gLeftFrame.Horz(gTree, gMainFrame);
  gLeftFrame.SetPos(2500);
	Add(gLeftFrame);
	//gLeftFrame.Zoom(0);
	gMainFrame.Zoom(0);
  
  gTree <<= THISBACK(TreeCursor);  
  
  // Status bar
	gStatus.HSizePosZ(0, 0).BottomPosZ(1, 20);
	Add(gStatus);
	gStatus.AddFrame(gStat4.Right(90));
	gStatus.AddFrame(gStat3.Right(150));
	gStatus.AddFrame(gStat2.Right(150));
	gStatus.AddFrame(gStat1.Right(150));
	gStat4.Set(" ");
	gStat3.Set(" ");
	gStat2.Set(" ");
	gStat1.Set(" ");
	gStatus.SetDefault(Null);
	gStatus.Set(" ");
		
	gStat1.Set(iniKeys.GetPut("Application").GetPut("UsedCommDriver"));
  gStat2.Set(iniKeys.GetPut("CommDriver").GetPut("PortaCOM") + " - " + iniKeys.GetPut("CommDriver").GetPut("Nodo"));
  fComDriver.gFirstNode.SetData(ScanInt(iniKeys.GetPut("Application").GetPut("FirstScanNode")));
  fComDriver.gLastNode.SetData(ScanInt(iniKeys.GetPut("Application").GetPut("LastScanNode")));
  RestoreKeys(Decode64(iniKeys.GetPut("Application").GetPut("Keys")));
  
	//Initializations
	networkOpen = false;
  changeTab = false;
  openBus = false;
  vBusHandle = 0;	
	fullCommunication = false;
  lastTabInModify = 0;

	const Vector<String>& arg = CommandLine();
	for(int i=0; i<arg.GetCount(); i++) 
	{
		if(arg[i] == "/Full") fullCommunication = true;
	}

	InitTree();

	// Launch hidden threads
	terminated = 0;
	AtomicInc(threads);
	cl.Run(THISBACK(CommLoop));			
	AtomicInc(threads);
	ud.Run(callback(GetUpdates));
}

App::~App()
{
	terminated = 1;
	while(threads) Sleep(10);
}

void App::Quit() 
{
  goOffline = true;
  commLoopStop = 1;
  while(commLoop == 1) Sleep(1);
  Bus().ClosePort(&vBusHandle);
  iniKeys.GetPut("Application").GetPut("Keys") = Encode64(StoreKeys());
  SaveIniKeys(GetExeDirFile("Config.ini"), iniKeys);
	Close();
	
	return;
}

void App::ShowTab(int n)  
{
  String s, t;

  if(n < 1) return;  
  dev = n - 1;

  if(nodo.At(dev).ctrlId == -1) 
  {
    fLeftSide.gMainTab.WhenSet.Clear();    
    CtrlLayout(gDevice.At(dev));
    fLeftSide.gMainTab.Add(gDevice.At(dev).SizePos(), AppImg::PierHB_0_16(), t_("Node ") + AsString((int)nodo.At(dev).addr)); 
    gDevice.At(dev).gModify.WhenPush << THISBACK(Modify);
    gDevice.At(dev).gModify.SetLabel(t_("Modify")).Tip(t_("Modify the values"));
    gDevice.At(dev).gCancel.WhenPush << THISBACK(CancelModify);
    gDevice.At(dev).gCancel.SetLabel(t_("Cancel")).Tip(t_("Cancel modify"));
    //gDevice.At(dev).gPlc.WhenPush << THISBACK1(uPlcEdit, dev);
    //gDevice.At(dev).gPlc.SetLabel(t_("uPLC")).Tip(t_("uPLC code editor"));
    //if(nodo.At(dev).codice == 101) gDevice.At(dev).gPlc.Enable();
    //else gDevice.At(dev).gPlc.Enable(false);
		nodo.At(dev).ctrlId = fLeftSide.gMainTab.GetCount() - 1;      
		itemDev.At(fLeftSide.gMainTab.GetCount() - 1) = dev;
	  	  
	  ArrayCtrl &ac = gDevice.At(dev).gMainAc;
	  
		ac.AddColumn("Parametro", 30);
		ac.AddColumn("Valore", 35);
		ac.AddColumn("Rapr.", 13);
		ac.AddColumn("Commento", 60);
		ac.AddColumn("editorIdx", -1);
		t.Clear();
		t.Cat("000");
		t.Cat(AsString(nodo.At(dev).codice));
		s.Clear();
 		s.Cat(nodo.At(dev).tipo);
 		s.Cat(t.Right(3));
		ac.Add(t_("Name"), s);
		ac.EnableLine(ac.GetCount()-1, false);
		s.Clear();
		s.Cat(AsString(nodo.At(dev).versione));
		s.Cat(".");
		s.Cat(AsString(nodo.At(dev).patch));
		ac.Add(t_("Release"), s);			
		ac.EnableLine(ac.GetCount()-1, false);
		ac.Add(t_("Serial number"), (int64)nodo.At(dev).sn);
		ac.SetCtrl(ac.GetCount()-1, 1, eh.Add());
		ac.EnableLine(ac.GetCount()-1, true);			
		ac.Set(ac.GetCount()-1, 2, "HEX.");
		ac.Set(ac.GetCount()-1, 4, eh.GetCount() - 1);
		ac.Add(t_("Address"), (int)nodo.At(dev).addr);			
		ac.SetCtrl(ac.GetCount()-1, 1, ei.Add().Max(255).Min(11));
		ac.EnableLine(ac.GetCount()-1, true);
		ac.Set(ac.GetCount()-1, 2, "DEC.");
		ac.Set(ac.GetCount()-1, 4, ei.GetCount()-1);
		
		uPlcSetToolsBar();
		
		fLeftSide.gMainTab.Set(fLeftSide.gMainTab.GetCount() - 1);
		ChangeTab();						
  }
  else fLeftSide.gMainTab.Set(nodo.At(dev).ctrlId);
	
	return;
}

void App::ChangeTab()
{
  if(networkOpen)
  {
		if(commLoop == 1) 
		{
		  changeTab = true;
		  return;
		}
		else
		{
    	dev = itemDev.At(fLeftSide.gMainTab.Get());
		  CancelModify();
			changeTab = false;
			fLeftSide.gMainTab.WhenSet << THISBACK(ChangeTab);		
			DevGetData();
		}
  }
	
	return;
}
