#include "PierHB.h"

// images
#define IMAGECLASS 		AppImg
#define IMAGEFILE 		<PierHB/App.iml>
#include 							<Draw/iml_source.h>

// keys
#define KEYGROUPNAME 	"Manager"
#define KEYNAMESPACE 	ManagerKeys
#define KEYFILE      	<PierHB/App.key>
#include             	<CtrlLib/key_source.h>

using namespace ManagerKeys;

void App::MainMenu(Bar& bar) 
{
	bar.Add(t_("File"), THISBACK(FileMenu));
	bar.Add(t_("Settings"), THISBACK(SettingsMenu));
	bar.Add(t_("Communication"), THISBACK(CommMenu));
	bar.Add(t_("Help"), THISBACK(HelpMenu));	
}

void App::FileMenu(Bar& bar) 
{
	bar.Add(readingLoop, AK_SAVE, CommonImg::save_1_16(), THISBACK(FileSave));
	bar.Add(readingLoop, AK_LOAD, CommonImg::load_1_16(), THISBACK(FileLoad));
	bar.Separator();
	bar.Add(AK_QUIT, CommonImg::quit_1_16(), THISBACK(Quit));
}

void App::SettingsMenu(Bar& bar) 
{
	bar.Add(AK_SETUP, THISBACK(PrgSetup));  
	bar.Add(t_("Languages"), THISBACK(Languages));
	bar.Separator();
	bar.Add(t_("Restore hidden updates"), callback(RestoreHiddenInstall));
	bar.Separator();
  bar.Add(AK_TASTIVELOCI, CommonImg::keys_1_16(), callback(EditKeys));
}

void App::CommMenu(Bar& bar) 
{
  bar.Add(AK_ONLINE, THISBACK(OpenNetwork)).Check(networkOpen);
}

void App::SetToolsBar() 
{
	bTools.Set(THISBACK(ToolsBar));
	return;	
}

void App::ToolsBar(Bar& bar) 
{

	return;
}

// TreeCtrl
void App::InitTree() 
{
  int i, j;
  String r;
	
	gTree.Clear();
  if(Bus().IsPortOpen(vBusHandle))
  {
		gTree.SetRoot(AppImg::network_1_16(), t_("Bus"));
	  for(j = 0; j < nodo.GetCount(); j++) 
	  {
	    r.Clear();
	    r.Cat(nodo.At(j).tipo);
	    r.Cat(String(String("000") + AsString(nodo.At(j).codice)).Right(3) + "." + String(String("000") + AsString((unsigned int)nodo.At(j).model)).Right(3) + "-V" + AsString(nodo.At(j).versione) + "." + AsString(nodo.At(j).patch) + " (");
	    r.Cat(nodo.At(j).nt);
	    r.Cat(")");
			i = gTree.Add(0, AppImg::PierHB_0_16(), j + 1, r, false);
			gTree.Open(0);    
	  }
  }
	return;	
}

void App::TreeCursor() 
{
  if(Bus().IsPortOpen(vBusHandle))
  {
		if(!IsNull(gTree)) 
		{
			ShowTab((int)~gTree);
		}
  }
	return;
}

void App::Languages(Bar& bar) 
{
	bar.Add(t_("English"), Flags::EN_1_16_2D(), THISBACK1(SelectLanguage, "EN-US")).Check(GetCurrentLanguage() == LNGFromText("EN-US"));
	bar.Add(t_("Italian"), Flags::IT_1_16_2D(), THISBACK1(SelectLanguage, "IT-IT")).Check(GetCurrentLanguage() == LNGFromText("IT-IT"));
}

void App::HelpMenu(Bar& bMenu) 
{
	//bMenu.Add(AK_HELPINDEX, GenIcons::Help_1_16_2D(), THISBACK(HelpIndex));
	//bMenu.Separator();
	//bMenu.Add(t_("Whats new"), THISBACK(WhatsNew)); 
	bMenu.Add(AK_INFO, THISBACK(About));
}
