#include "PierHB.h"

#define LLOG(x) //  LOG(x)

CodeEdit::CodeEdit() 
{
	isdrag = false;
	nohbar = false;
	showtabs = false;
	tabsize = 1;
	font = Courier(12);
	SetFrame(ViewFrame());
	sb.NoBox();
	AddFrame(sb);
	sb.WhenScroll = THISBACK(Scroll);
	cutline = true;
	bordercolumn = -1;
	bordercolor = Null;
	overwrite = false;
	filter = NULL;
	showspaces = false;
	errors = false;

	il = device.At(dev)("uPLC")("IL");
	ma = device.At(dev)("uPLC")("MA");
}

CodeEdit::~CodeEdit() {}

void CodeEdit::MouseWheel(Point, int zdelta, dword keyflags) 
{
	if(keyflags & K_SHIFT)
		sb.WheelX(zdelta);
	else
		sb.WheelY(zdelta);
}

void   CodeEdit::Clear() 
{
	gcolumn = 0;
	TextCtrl::Clear();
	sb.SetTotal(0, 0);
	sb.Set(0, 0);
	NewScrollPos();
	PlaceCaret(0, false);
}

CodeEdit& CodeEdit::TabSize(int n) {
	tabsize = n;
	PlaceCaret0(GetColumnLine(cursor));
	Refresh();
	return *this;
}

CodeEdit& CodeEdit::BorderColumn(int col, Color c)
{
	bordercolumn = col;
	bordercolor = c;
	Refresh();
	return *this;
}

CodeEdit& CodeEdit::SetFont(Font f) 
{
	font = f;
	Layout();
	TabSize(tabsize);
	SetSb();
	return *this;
}

Size CodeEdit::GetFontSize() const 
{
	FontInfo fi = font.Info();
	return Size(max(fi['M'], fi['W']), fi.GetHeight());
}

void CodeEdit::LineFormat(int l)
{
  /* 
  	per velocizzare l'editor, questa routine dovrebbe essere eseguita
    solo sulla riga su cui si trova il cursore.
  */
  Point sc = sb;
  
	WString ax;
	WString tx = line[l];
	int b = tx.GetLength();
	
	/* replacing tab with space */
	for (int j = 0; j < tx.GetCount(); j++)
	{
	  if(tx[j] == '\t') ax.Cat(' ');
	  else ax.Cat(ToUpper(tx[j]));
	}
	line[l] = ax;	
	Vector<String> sp = Split(AsString(ax), " ");

	if(sp.GetCount() > 0)
	{
	  if(sp[0].GetLength() > 8) 
	  {
		  sp[0] = sp[0].Left(8);
	  	line[l] = WString(sp[0]);
	  }
	}

	if(sp.GetCount() > 1)
	{
	  bool a = false;
	  sp[0].Cat(' ', 10 - sp[0].GetLength());
	  sp[0].Cat(sp[1].Left(1));
	  if(sp[1].GetLength() > 1) 
	  {
	  	sp[0].Cat(" ");
	  	sp[0].Cat(sp[1].Mid(1));
	  	a = true;  
	  }
	  
	  if(sp.GetCount() > 2)
	  {
    	if(!a) sp[0].Cat(" ");
    	for(int k = 2; k < sp.GetCount(); k++)
    	{
	  	  sp[0].Cat(sp[k]);
    	}
	  }
  
  	line[l] = WString(sp[0]);
	}

	int c = line[l].GetLength();
  total += c - b;
  PlaceCaret(cursor + (c - b), false);

	return;
}

void   CodeEdit::Paint0(Draw& w) 
{
	int sell, selh;
	GetSelection(sell, selh);
	
	if(!IsEnabled())
		sell = selh = 0;
	
	Size sz = GetSize();
	Size fsz = GetFontSize();
	Point sc = sb;
	int ll = min(line.GetCount(), sz.cy / fsz.cy + sc.y + 1);
	int  y = 0;
	cpos = GetPos(sc.y);
	cline = sc.y;
	sell -= cpos;
	selh -= cpos;
	int pos = cpos;
	Vector<int> dx, dx2;
	int fascent = font.Info().GetAscent();
	
	// rows loop
	errors = false;
	for(int i = sc.y; i < ll; i++) 
	{
		LineFormat(i);
		WString tx = line[i];
		int len = tx.GetLength();
		
		if(w.IsPainting(0, y, sz.cx, fsz.cy)) 
		{
		  /* to CUT
			Highlight ih;
			ih.ink = color[IsShowEnabled() ? INK_NORMAL : INK_DISABLED];
			ih.paper = color[IsReadOnly() || !IsShowEnabled() ? PAPER_READONLY : PAPER_NORMAL];
			
			if(nobg)
				ih.paper = Null;
			
			ih.font = font;
			ih.chr = 0;
			Vector<Highlight> hl;										// row highligth
			hl.SetCount(len + 1, ih);								// default colors for each chars in row
			
			for(int q = 0; q < tx.GetCount(); q++)
				hl[q].chr = tx[q];
			*/

			/* 
				highlighted chars 
				by default the line is wrong, (red)
				next the analyzer will adjust the colors
			*/
			Vector<Highlight> 				hl;										// row highligth
  		Vector<String> 						sp;
  		uPlcSplitLineCode(AsString(tx), sp);
  		
			Highlight ch;
			
			ch.ink = LtRed();		
			ch.paper = color[IsReadOnly() || !IsShowEnabled() ? PAPER_READONLY : PAPER_NORMAL];
			ch.font = font;
			hl.Set(0, ch, len + 1);
			for(int q = 0; q < tx.GetCount(); q++) hl[q].chr = tx[q];					

			/* Andrebbe fatto un analizzatore di sintassi di tutta la riga e solo se corretta
			   e completa accettarne la colorazione
			*/
			bool correct = true;
			if(sp.GetCount() > 0)
			{
			  for(int k = 0; k < il.GetCount(); k ++)
			  {
			    if (il[k].GetTag() == "I")
			    {
						if (sp[0] == il[k].GatherText())
						{
							ch.ink = LtBlue();
							hl.Set(0, ch, sp[0].GetLength());
							WString ax = sp[0];					
							for(int q = 0; q < ax.GetCount(); q++) hl[q].chr = ax[q];
														
							if(sp.GetCount() > 1)
							{
							  for(int m = 0; m < ma.GetCount(); m ++)
							  {
							    if (ma[m].GetTag() == "A")
							    {
										if (sp[1] == ma[m].GatherText())
										{										  
										  if(sp[1] == "#")
										  {
										    if(ScanBool(il[k].Attr("AllowConstant")) == false) correct = false;
										  }
										  else
										  {
										    if(ScanBool(il[k].Attr("AllowAddress")) == false) correct = false;
										  }
										  
										  if(correct)
										  {
												ch.ink = LtMagenta();
												hl.Set(10, ch, 1);
												WString ax = sp[1];					
												hl[10].chr = ax[0];
																								
												if(sp.GetCount() > 2)
												{
												  Vector<String> adr = Split(sp[2], '.');
												  
												  if(sp[1] == "#")
												  {
												    if(adr.GetCount() > 1) correct = false;
												    if(ScanInt(adr[0]) < ScanInt(il[k].Attr("Min"))) correct = false;
												    if(ScanInt(adr[0]) > ScanInt(il[k].Attr("Max"))) correct = false;
												  }
												  else
												  {
												    int node, mem, bit;
												    if(adr.GetCount() == 1)
												    {
												      node = 0;
												      mem = ScanInt(adr[0]);
												      bit = 0;
												      if(ScanBool(il[k].Attr("Bool")) == true) correct = false;  
												    }
												    else if(adr.GetCount() == 2)
												    {
												      node = 0;
												      mem = ScanInt(adr[0]);
												      bit = ScanInt(adr[1]);  
												      if(ScanBool(ma[m].Attr("AllowBool")) == false) correct = false;  
												    }
												    else if(adr.GetCount() == 3)
												    {
												      node = ScanInt(adr[0]);
												      mem = ScanInt(adr[1]);
												      bit = ScanInt(adr[2]);
												      if(ScanBool(il[k].Attr("Remote")) == false) correct = false;  
												    }
												    else correct = false;
												    
												    if(correct)
												    {
												      int size = ScanBool(ma[m].Attr("AllowBool")) ? mem * 8 + bit + 1 : mem + 1;
												      
												      if(node == 0 && size > ScanInt(ma[m].Attr("Size"))) correct = false;
												      if(bit > 7) correct = false;	  
												      if((node < 11 || node > 255) && node != 0) correct = false; // The bus standard allow to use node number from 11 to 255
												      																						 // Node number 0 is reserved as broacast messages
												      																						 // Node number from 1 to 10 are reserved for special devices
												    }
												  }
												  
												  if(correct)
												  {
														ch.ink = Black();
														hl.Set(12, ch, sp[2].GetLength());
														WString ax = sp[2];					
														for(int q = 0; q < ax.GetCount(); q++) hl[q + 12].chr = ax[q];
												  }
												  else errors = true; // errors found
												}

												/* force exit loop */
												m = ma.GetCount() + 1;
												
										  }
								    }
							    }							  
							  }
							}

							/* force exit loop */
							k = il.GetCount() + 1;
							
				    }
			    }
			  }
			}
			/* end highlighted chars */
			
			/* selected chars */
			HighlightLine(i, hl, pos);
			int ln = hl.GetCount() - 1;
			int l = max(sell, 0);
			int h = selh > len ? len : selh;
			
			if(l < h)
				for(int i = l; i < h; i++) 
				{
					hl[i].paper = color[PAPER_SELECTED];
					hl[i].ink = color[INK_SELECTED];
				}
			
			if(sell <= len && selh > len)
				for(int i = len; i < hl.GetCount(); i++) 
				{
					hl[i].paper = color[PAPER_SELECTED];
					hl[i].ink = color[INK_SELECTED];
				}
			/* end selected chars */
			
			Buffer<wchar> txt(ln);
			
			for(int i = 0; i < ln; i++)
				txt[i] = hl[i].chr;
			
			/* draw */
			for(int pass = 0; pass < 2; pass++) 
			{
				int gp = 0;
				int scx = fsz.cx * sc.x;
				if(ln >= 0) 
				{
					int q = 0;
					while(q < ln) 
					{
						Highlight& h = hl[q];
						if(txt[q] == '\t') 
						{
							int ngp = (gp + tabsize) / tabsize * tabsize;
							int l = ngp - gp;
							LLOG("Highlight -> tab[" << q << "] paper = " << h.paper);
							if(pass == 0) 
							{
								w.DrawRect(gp * fsz.cx - scx, y, fsz.cx * l, fsz.cy, h.paper);
								if(showtabs && h.paper != SColorHighlight && q < tx.GetLength()) 
								{
									Color c = Blend(SColorLight, SColorHighlight);
									w.DrawRect(gp * fsz.cx - scx + 2, y + fsz.cy / 2, l * fsz.cx - 4, 1, c);
									w.DrawRect(ngp * fsz.cx - scx - 3, y + 3, 1, fsz.cy - 6, c);
								}
								if(bordercolumn > 0 && bordercolumn >= gp && bordercolumn < gp + l)
									w.DrawRect((bordercolumn - sc.x) * fsz.cx, y, 1, fsz.cy, bordercolor);
								
							}
							q++;
							gp = ngp;
						}
						else if(txt[q] == ' ') 
						{
					    LLOG("Highlight -> space[" << q << "] paper = " << h.paper);
					    if(pass == 0) 
					    {
				        w.DrawRect(gp * fsz.cx - scx, y, fsz.cx, fsz.cy, h.paper);
				        if(showspaces && h.paper != SColorHighlight && q < tx.GetLength()) 
				        {
				          Color c = Blend(SColorLight, SColorHighlight);
				          w.DrawRect(gp * fsz.cx - scx + fsz.cx / 2, y + fsz.cy / 2, 2, 2, c);
				        }
				        if(bordercolumn > 0 && bordercolumn >= gp && bordercolumn < gp + 1)
				          w.DrawRect((bordercolumn - sc.x) * fsz.cx, y, 1, fsz.cy, bordercolor);
					    }
					    q++;
					    gp++;
						}
						else 
						{
							bool cjk = IsCJKIdeograph(txt[q]);
							int p = q + 1;
							
							while(p < len && h == hl[p] && txt[p] != '\t' && txt[p] != ' ' && IsCJKIdeograph(txt[p]) == cjk && p - q < 128)
								p++;
							
							int l = p - q;
							int ll = cjk ? 2 * l : l;
							LLOG("Highlight -> paper[" << q << "] = " << h.paper);
							int x = gp * fsz.cx - scx;
							int xx = x + (gp + ll) * fsz.cx;
							
							if(max(x, 0) < min(xx, sz.cx))
								if(pass == 0) 
								{
									w.DrawRect(x, y, fsz.cx * ll, fsz.cy, h.paper);
									if(bordercolumn > 0 && bordercolumn >= gp && bordercolumn < gp + ll)
										w.DrawRect((bordercolumn - sc.x) * fsz.cx, y, 1, fsz.cy, bordercolor);
								}
								else 
								{
									if(cjk)
										dx2.At(l, 2 * fsz.cx);
									else
										dx.At(l, fsz.cx);
									
									w.DrawText(x, y + fascent - h.font.Info().GetAscent(), ~txt + q, h.font, h.ink, l, cjk ? dx2 : dx);
								}
							
							q = p;
							gp += ll;
							
							if(x > sz.cx)
								break;
						
						}
					}
				}
				
				if(pass == 0) 
				{
					int gpx = gp * fsz.cx - scx;
					w.DrawRect(gpx, y, sz.cx - gpx, fsz.cy, hl.Top().paper);
					
					if(bordercolumn > 0 && bordercolumn >= gp)
						w.DrawRect((bordercolumn - sc.x) * fsz.cx, y, 1, fsz.cy, bordercolor);
					
				}
			}
		}
		y += fsz.cy;
		sell -= len + 1;
		selh -= len + 1;
		pos += len + 1;
	}
	w.DrawRect(0, y, sz.cx, sz.cy - y, color[IsReadOnly() || !IsShowEnabled() ? PAPER_READONLY : PAPER_NORMAL]);
	DrawTiles(w, DropCaret(), CtrlImg::checkers());
}

void CodeEdit::Paint(Draw& w)
{
	Paint0(w);
	scroller.Set(sb);
}

struct CodeEdit::RefreshDraw : public NilDraw {
	Ctrl  *ctrl;
	bool (*chars)(int c);
	Size   fsz;
	virtual void DrawTextOp(int x, int y, int angle, const wchar *text, Font,
	                        Color, int n, const int *dx) {
		if(dx)
			while(n > 0) {
				if((*chars)(*text))
					ctrl->Refresh(x, y, fsz.cx, fsz.cy);
				text++;
				x += *dx++;
				n--;
			}
	}
	bool IsPaintingOp(const Rect& r) const {
		return true;
	}
};

void CodeEdit::RefreshChars(bool (*chars)(int c))
{
	RefreshDraw rw;
	rw.ctrl = this;
	rw.fsz = GetFontSize();
	rw.chars = chars;
	Paint(rw);
}

void   CodeEdit::Layout() {
	Size sz = sb.GetReducedViewSize();
	if(nohbar || isdrag)
		sz.cy = GetSize().cy;
	sb.SetPage(sz / GetFontSize());
	SetHBar();
}

int   CodeEdit::GetGPos(int ln, int cl) const {
	ln = minmax(ln, 0, line.GetCount() - 1);
	WString txt = line[ln];
	const wchar *b = txt;
	const wchar *e = txt.End();
	const wchar *s = b;
	int gl = 0;
	while(s < e) {
		if(*s == '\t')
			gl = (gl + tabsize) / tabsize * tabsize;
		else
			gl += 1 + IsCJKIdeograph(*s);
		if(cl < gl) break;
		s++;
	}
	return GetPos(ln, int(s - b));
}

Point CodeEdit::GetColumnLine(int pos) const {
	Point p;
	if(pos > total) pos = total;
	p.y = GetLinePos(pos);
	p.x = 0;
	WString txt = line[p.y];
	const wchar *s = txt;
	while(pos--) {
		if(*s == '\t')
			p.x = (p.x + tabsize) / tabsize * tabsize;
		else
			p.x += 1 + IsCJKIdeograph(*s);
		s++;
	}
	return p;
}

Point CodeEdit::GetIndexLine(int pos) const
{
	Point p;
	if(pos > total) pos = total;
	p.y = GetLinePos(pos);
	p.x = minmax(pos, 0, line[p.y].GetLength());
	return p;
}

int CodeEdit::GetIndexLinePos(Point pos) const
{
	if(pos.y < 0)
		return 0;
	if(pos.y >= GetLineCount())
		return total;
	return GetPos(pos.y, minmax(pos.x, 0, line[pos.y].GetLength()));
}

void CodeEdit::RefreshLine(int i) {
	Size sz = GetSize();
	int fcy = GetFontSize().cy;
	Refresh(0, (i - sb.Get().y) * fcy, sz.cx, fcy);
}

Rect CodeEdit::GetLineScreenRect(int line) const {
	int fcy = GetFontSize().cy;
	Rect r = RectC(0, (line - sb.Get().y) * fcy, GetSize().cx, fcy);
	r.Offset(GetScreenView().TopLeft());
	return r;
}

void CodeEdit::SetSb() {
	sb.SetTotalY(line.GetCount());
	SetHBar();
}

void CodeEdit::NewScrollPos() {}
void CodeEdit::HighlightLine(int line, Vector<Highlight>& h, int pos) {}

void CodeEdit::AlignChar() {
	int c = GetCursor();
	if(c == 0)
		return;
	Point pos = GetColumnLine(c);
	if(pos.x == 0)
		return;
	for(int d = 1; d <= pos.y && d < 100; d++) {
		int lny = pos.y - d;
		WString above = GetWLine(lny);
		int offset = GetGPos(lny, pos.x) - GetPos(lny);
		int end = offset;
		char ch = GetChar(c - 1);
		if(ch == ' ')
		{
			offset++;
			while(end < above.GetLength() && above[end] != ' ')
				end++;
			while(end < above.GetLength() && above[end] == ' ')
				end++;
		}
		else
			while(end < above.GetLength() && above[end] != ch)
				end++;
		if(end < above.GetLength()) {
			int count = end - offset + 1;
			WString s(' ', count);
			Insert(c - 1, s, true);
			SetCursor(c + count);
			return;
		}
	}
}

void CodeEdit::PlaceCaret0(Point p) {
	Size fsz = GetFontSize();
	p -= sb;
	caretpos = Point(p.x * fsz.cx, p.y * fsz.cy);
	if(overwrite)
		SetCaret(caretpos.x, caretpos.y + fsz.cy - 2, fsz.cx, 2);
	else
		SetCaret(caretpos.x, caretpos.y, 2, fsz.cy);
}

int CodeEdit::PlaceCaretNoG(int newcursor, bool sel) {
	if(newcursor > total) newcursor = total;
	Point p = GetColumnLine(newcursor);
	if(sel) {
		if(anchor < 0) {
			anchor = cursor;
		}
		RefreshLines(p.y, GetLine(cursor));
	}
	else
		if(anchor >= 0) {
			RefreshLines(GetLine(cursor), GetLine(anchor));
			anchor = -1;
		}
	cursor = newcursor;
	ScrollIntoCursor();
	PlaceCaret0(p);
	SelectionChanged();
	WhenSel();
	if(IsSelection())
		SetSelectionSource(ClipFmtsText());
	return p.x;
}

void CodeEdit::PlaceCaret(int newcursor, bool sel) {
	gcolumn = PlaceCaretNoG(newcursor, sel);
}

void CodeEdit::TopCursor(int lines)
{
	sb.SetY(max(0, GetLine(cursor) - lines));
}

void CodeEdit::CenterCursor() {
	int cy = sb.GetPage().cy;
	if(cy > 4)
		sb.SetY(max(min(GetLine(cursor) - cy / 2, line.GetCount() - cy), 0));
}

void CodeEdit::Scroll() {
	PlaceCaret0(GetColumnLine(cursor));
	scroller.Scroll(*this, GetSize(), sb.Get(), GetFontSize());
	SetHBar();
	NewScrollPos();
}

int CodeEdit::GetMousePos(Point p) const {
	Size fsz = GetFontSize();
	p = (p + fsz.cx / 2 + fsz * (Size)sb.Get()) / fsz;
	return GetGPos(p.y, p.x);
}

void CodeEdit::LeftDown(Point p, dword flags) {
	mpos = GetMousePos(p);
	int l, h;
	if(GetSelection(l, h) && mpos >= l && mpos < h) {
		selclick = true;
		return;
	}
	PlaceCaret(mpos, flags & K_SHIFT);
	SetWantFocus();
	SetCapture();
}

void CodeEdit::LeftUp(Point p, dword flags)
{
	if(!HasCapture() && selclick) {
		mpos = GetMousePos(p);
		PlaceCaret(mpos, flags & K_SHIFT);
		SetWantFocus();
	}
	selclick = false;
}

void CodeEdit::RightDown(Point p, dword flags)
{
	mpos = GetMousePos(p);
	SetWantFocus();
	int l, h;
	if(!GetSelection(l, h) || mpos < l || mpos >= h)
		PlaceCaret(mpos, false);
	MenuBar::Execute(WhenBar);
}

void CodeEdit::LeftDouble(Point, dword)
{
	int l, h;
	if(GetWordSelection(cursor, l, h))
		SetSelection(l, h);
}

void CodeEdit::LeftTriple(Point, dword)
{
	int q = cursor;
	int i = GetLinePos(q);
	q = cursor - q;
	SetSelection(q, q + GetLineLength(i) + 1);
}

void CodeEdit::MouseMove(Point p, dword flags) {
	if((flags & K_MOUSELEFT) && HasFocus() && HasCapture()) {
		int c = GetMousePos(p);
		PlaceCaret(c, mpos != c || HasCapture());
	}
}

void CodeEdit::LeftRepeat(Point p, dword flags) {
	if(HasCapture()) {
		int c = GetMousePos(p);
		if(mpos != c)
			PlaceCaret(c, true);
	}
}

Image CodeEdit::CursorImage(Point, dword) {
	return Image::IBeam();
}

void CodeEdit::MoveUpDown(int n, bool sel) {
	int cl = cursor;
	int ln = GetLinePos(cl);
	ln = minmax(ln + n, 0, line.GetCount() - 1);
	PlaceCaretNoG(GetGPos(ln, gcolumn), sel);
}

void CodeEdit::MoveLeft(bool sel) {
	if(cursor)
		PlaceCaret(cursor - 1, sel);
}

void CodeEdit::MoveRight(bool sel) {
	if(cursor < total)
		PlaceCaret(cursor + 1, sel);
}

void CodeEdit::MoveUp(bool sel) {
	MoveUpDown(-1, sel);
}

void CodeEdit::MoveDown(bool sel) {
	MoveUpDown(1, sel);
}

void CodeEdit::MovePage(int dir, bool sel) {
	int n = dir * max(GetSize().cy / GetFontSize().cy - 2, 2);
	sb.SetY(Point(sb).y + n);
	MoveUpDown(n, sel);
}

void CodeEdit::MovePageUp(bool sel) {
	MovePage(-1, sel);
}

void CodeEdit::MovePageDown(bool sel) {
	MovePage(1, sel);
}

inline bool sTabSpace(int c) { return c == '\t' || c == ' '; }

void CodeEdit::MoveHome(bool sel) {
	int cl = cursor;
	int li = GetLinePos(cl);
	int i = 0;
	WString l = line[li];
	while(sTabSpace(l[i]))
		i++;
	PlaceCaret(GetPos(li, cl == i ? 0 : i), sel);
}

void CodeEdit::MoveEnd(bool sel) {
	int i = GetLine(cursor);
	PlaceCaret(GetPos(i, line[i].GetLength()), sel);
}

void CodeEdit::MoveTextBegin(bool sel) {
	PlaceCaret(0, sel);
}

void CodeEdit::MoveTextEnd(bool sel) {
	PlaceCaret(total, sel);
}

bool CodeEdit::InsertChar(dword key, int count, bool canow) {
	if(key == K_TAB && !processtab)
		return false;
	if(filter && key >= 32 && key < 65535)
		key = (*filter)(key);
	if(!IsReadOnly() && (key >= 32 && key < 65536 || key == '\t' || key == '\n' ||
	   key == K_ENTER && processenter || key == K_SHIFT_SPACE)) {
		if(key >= 128 && key < 65536 && (charset != CHARSET_UNICODE && charset != CHARSET_UTF8_BOM)
		   && FromUnicode((wchar)key, charset) == DEFAULTCHAR)
			return true;
		if(!RemoveSelection() && overwrite && key != '\n' && key != K_ENTER && canow) {
			int q = cursor;
			int i = GetLinePos(q);
			if(q + count - 1 < GetLineLength(i))
				Remove(cursor, count);
		}
		WString text(key == K_ENTER ? '\n' : key == K_SHIFT_SPACE ? ' ' : key, count);
		Insert(cursor, text, true);
		PlaceCaret(cursor + count);
		Action();
		return true;
	}
	return false;
}

void CodeEdit::DeleteChar() {
	if(IsReadOnly() || RemoveSelection()) {
		Action();
		return;
	}
	if(cursor < total) {
		Remove(cursor, 1);
		Action();
	}
}

void CodeEdit::Backspace() {
	if(IsReadOnly() || RemoveSelection() || cursor == 0) return;
	MoveLeft();
	DeleteChar();
	Action();
}

void CodeEdit::DeleteLine()
{
	int b, e;
	if(GetSelection(b, e) && GetLine(b) != GetLine(e)) {
		RemoveSelection();
		return;
	}
	int i = GetLine(cursor);
	int p = GetPos(i);
	Remove(p, line[i].GetLength() + 1);
	PlaceCaret(p);
	Action();
}

void CodeEdit::CutLine()
{
	if(IsReadOnly()) return;
	int b, e;
	if(GetSelection(b, e) && GetLine(b) != GetLine(e)) {
		Cut();
		return;
	}
	int i = GetLine(cursor);
	int p = GetPos(i);
	WString txt = Get(p, line[i].GetLength() + 1).ToWString();
	WriteClipboardUnicodeText(txt);
	AppendClipboardText(txt.ToString());
	ClearSelection();
	DeleteLine();
}

void CodeEdit::EditPos::Serialize(Stream& s) {
	int version = 0;
	s / version;
	s % sby % cursor;
}

CodeEdit::EditPos CodeEdit::GetEditPos() const {
	EditPos pos;
	pos.sby = sb.Get().y;
	pos.cursor = cursor;
	return pos;
}

void CodeEdit::SetEditPos(const CodeEdit::EditPos& pos) {
	sb.SetY(minmax(pos.sby, 0, line.GetCount() - 1));
	SetCursor(pos.cursor);
}

void CodeEdit::SetEditPosSb(const CodeEdit::EditPos& pos) {
	SetCursor(pos.cursor);
	sb.SetY(minmax(pos.sby, 0, line.GetCount() - 1));
}

void CodeEdit::SetHBar()
{
	int mpos = 0;
	if(!nohbar && !isdrag) {
		int m = min(sb.y + sb.GetPage().cy + 2, line.GetCount());
		for(int i = sb.y; i < m; i++) {
			int pos = 0;
			WString l = line[i];
			const wchar *s = l;
			const wchar *e = l.End();
			while(s < e) {
				if(*s == '\t')
					pos = (pos + tabsize) / tabsize * tabsize;
				else
					pos += 1 + IsCJKIdeograph(*s);
				s++;
			}
			mpos = max(mpos, pos);
		}
	}
	sb.SetTotalX(mpos + 1);
}

void CodeEdit::ScrollIntoCursor()
{
	Point p = GetColumnLine(GetCursor());
	sb.ScrollInto(p);
	SetHBar();
	sb.ScrollInto(p);
}

bool CodeEdit::Key(dword key, int count) {
	NextUndo();
	switch(key) {
	case K_CTRL_UP:
		ScrollUp();
		return true;
	case K_CTRL_DOWN:
		ScrollDown();
		return true;
	case K_INSERT:
		OverWriteMode(!IsOverWriteMode());
		break;
	}
	bool sel = key & K_SHIFT;
	switch(key & ~K_SHIFT) {
	case K_CTRL_LEFT:
		{
			PlaceCaret(GetPrevWord(cursor), sel);
			break;
		}
	case K_CTRL_RIGHT:
		{
			PlaceCaret(GetNextWord(cursor), sel);
			break;
		}
	case K_LEFT:
		MoveLeft(sel);
		break;
	case K_RIGHT:
		MoveRight(sel);
		break;
	case K_HOME:
		MoveHome(sel);
		break;
	case K_END:
		MoveEnd(sel);
		break;
	case K_UP:
		MoveUp(sel);
		break;
	case K_DOWN:
		MoveDown(sel);
		break;
	case K_PAGEUP:
		MovePageUp(sel);
		break;
	case K_PAGEDOWN:
		MovePageDown(sel);
		break;
	case K_CTRL_PAGEUP:
	case K_CTRL_HOME:
		MoveTextBegin(sel);
		break;
	case K_CTRL_PAGEDOWN:
	case K_CTRL_END:
		MoveTextEnd(sel);
		break;
	case K_CTRL_C:
	case K_CTRL_INSERT:
		Copy();
		break;
	case K_CTRL_A:
		SelectAll();
		break;
	default:
		if(IsReadOnly())
			return MenuBar::Scan(WhenBar, key);
		switch(key) {
		case K_DELETE:
			DeleteChar();
			break;
		case K_BACKSPACE:
		case K_SHIFT|K_BACKSPACE:
			Backspace();
			break;
	   	case K_SHIFT_TAB:
			AlignChar();
			break;
		case K_CTRL_Y:
		case K_CTRL_L:
			if(cutline) {
				CutLine();
				break;
			}
		default:
			if(InsertChar(key, count, true))
				return true;
			return MenuBar::Scan(WhenBar, key);
		}
		return true;
	}
	Sync();
	return true;
}

void CodeEdit::DragAndDrop(Point p, PasteClip& d)
{
	if(IsReadOnly()) return;
	int c = GetMousePos(p);
	if(AcceptText(d)) {
		NextUndo();
		int a = sb.y;
		int sell, selh;
		if(GetSelection(sell, selh)) {
			if(c >= sell && c < selh) {
				RemoveSelection();
				if(IsDragAndDropSource())
					d.SetAction(DND_COPY);
				c = sell;
			}
			else
			if(d.GetAction() == DND_MOVE && IsDragAndDropSource()) {
				if(c > sell)
					c -= selh - sell;
				RemoveSelection();
				d.SetAction(DND_COPY);
			}
		}
		int count = Insert(c, GetWString(d));
		sb.y = a;
		SetFocus();
		SetSelection(c, c + count);
		Action();
		return;
	}
	if(!d.IsAccepted()) return;
	if(!isdrag) {
		isdrag = true;
		ScrollIntoCursor();
	}
	Point dc = Null;
	if(c >= 0)
		dc = GetColumnLine(c);
	if(dc != dropcaret) {
		RefreshDropCaret();
		dropcaret = dc;
		RefreshDropCaret();
	}
}

Rect CodeEdit::DropCaret()
{
	if(IsNull(dropcaret))
		return Rect(0, 0, 0, 0);
	Size fsz = GetFontSize();
	Point p = dropcaret - sb;
	p = Point(p.x * fsz.cx, p.y * fsz.cy);
	return RectC(p.x, p.y, 1, fsz.cy);
}

void CodeEdit::RefreshDropCaret()
{
	Refresh(DropCaret());
}

void CodeEdit::DragRepeat(Point p)
{
	sb.y = (int)sb.y + GetDragScroll(this, p, 1).y;
}

void CodeEdit::DragLeave()
{
	RefreshDropCaret();
	dropcaret = Null;
	isdrag = false;
	Layout();
}

void CodeEdit::LeftDrag(Point p, dword flags)
{
	int c = GetMousePos(p);
	int l, h;
	if(!HasCapture() && GetSelection(l, h) && c >= l && c < h) {
		WString sample = GetW(l, min(h - l, 3000));
		Size sz = StdSampleSize();
		ImageDraw iw(sz);
		iw.DrawRect(sz, Black());
		iw.Alpha().DrawRect(sz, Black());
		DrawTLText(iw.Alpha(), 0, 0, 9999, sample, Courier(10), White());
		NextUndo();
		if(DoDragAndDrop(ClipFmtsText(), iw) == DND_MOVE) {
			RemoveSelection();
			Action();
		}
	}
}
