#include "PierHB.h"

void App::FileSave() 
{
	FileSelector fs;
	int i;
	
	i = fLeftSide.gMainTab.Get();
  ArrayCtrl &ac = gDevice.At(i).gMainAc;
	
	String r;
	r.Cat(nodo.At(i).tipo);
	r.Cat(String( "000" + AsString(nodo.At(i).codice)).Right(3) + "-V" + AsString(nodo.At(i).versione) + "." + AsString(nodo.At(i).patch));

	fs.Type("epd files", "*.epd").DefaultExt("epd").ActiveDir(GetHomeDirectory());
	if(!fs.ExecuteSaveAs(t_("Save as.."))) {
		return;
	}
	
	XmlNode t;
	t.Add("Device").SetAttr("id", r);
  t("Device").Add("parameters");
	t("Device").Add("cyclical");
	t("Device").Add("variables");
	for(int j = 4; j < ac.GetCount(); j++)
	{
		if((int)ac.Get(j, 5) == 'p')
		{
		  t("Device")("parameters").Add(AsString(ac.Get(j, 0))).SetAttr("value", AsString(ac.Get(j, 1)));
		}
		else if((int)ac.Get(j, 5) == 'c')
		{
		  t("Device")("cyclical").Add(AsString(ac.Get(j, 0))).SetAttr("value", AsString(ac.Get(j, 1)));
		}
		else if((int)ac.Get(j, 5) == 'v')
		{
		  t("Device")("variables").Add(AsString(ac.Get(j, 0))).SetAttr("value", AsString(ac.Get(j, 1)));
		}
	}
	
	String xml = AsXML(t, XML_HEADER);
	SaveFile(fs.Get(), xml);
	return;		
}

void App::FileLoad() 
{
	FileSelector fs;
	int i, j;
	
	i = fLeftSide.gMainTab.Get();
  ArrayCtrl &ac = gDevice.At(i).gMainAc;
	XmlNode &l = device.At(i).At(0);
	
	String r;
	r.Cat(nodo.At(i).tipo);
	r.Cat(String( "000" + AsString(nodo.At(i).codice)).Right(3) + "-V" + AsString(nodo.At(i).versione) + "." + AsString(nodo.At(i).patch));

	fs.Type("epd files", "*.epd").DefaultExt("epd").ActiveDir(GetHomeDirectory());
	if(!fs.ExecuteOpen(t_("Save as.."))) {
		return;
	}
  
  XmlNode n = ParseXML(LoadFile(fs.Get()));
  if(n("Device").Attr("id") != r)
  {
    Exclamation(t_("The selected file is not for the device connected at the opened node."));
    return;
  }
  
  int res = PromptOKCancel(t_("If you continue all the data of the selected file will be transferred to the device permanently. Continue?"));
  if(res != 1)
  {
    PromptOK(t_("Load aborted."));
    return;
  }
  
  for(j = 4; j < ac.GetCount(); j++)
  {
    if(n("Device")("parameters").FindTag(AsString(ac.Get(j, 0))) > -1) 
    {
      if(ScanInt(l.Attr("Tipo")) == 2) ac.Set(j, 1, n("Device")("parameters")(AsString(ac.Get(j, 0))).Attr("value"));
      else ac.Set(j, 1, ScanInt(n("Device")("parameters")(AsString(ac.Get(j, 0))).Attr("value")));
    }
    if(n("Device")("cyclical").FindTag(AsString(ac.Get(j, 0))) > -1) 
    {
      if(ScanInt(l.Attr("Tipo")) == 2) ac.Set(j, 1, n("Device")("cyclical")(AsString(ac.Get(j, 0))).Attr("value"));
      else ac.Set(j, 1, ScanInt(n("Device")("cyclical")(AsString(ac.Get(j, 0))).Attr("value")));
    }
    if(n("Device")("variables").FindTag(AsString(ac.Get(j, 0))) > -1) 
    {
      if(ScanInt(l.Attr("Tipo")) == 2) ac.Set(j, 1, n("Device")("variables")(AsString(ac.Get(j, 0))).Attr("value"));
      else ac.Set(j, 1, ScanInt(n("Device")("variables")(AsString(ac.Get(j, 0))).Attr("value")));
    }
  }
  
  DevicePutData();
  
	return;		
}
