#ifndef _main_h_
#define _main_h_

#include <Core/Core.h>
#include <CtrlCore/CtrlCore.h>
#include <CtrlLib/CtrlLib.h>
#include <Web/Web.h>

using namespace Upp;

#include <AsBus/AsBusDll.h>
#include "Support.h"
#include "MyHelp.h"
#include "IniFile.h"
#include "MyProgress.h"
#include "String.h"
#include "help.h"
#include "Uninstall.h"
#include "Version.h"
#include "uPlcCodeEditor.h"
#include "CommServer.h"

// layout
#define LAYOUTFILE 		<PierHB/App.lay>
#include 							<CtrlCore/lay.h>

// images
#define IMAGECLASS 		CommonImg
#define IMAGEFILE 		<PierHB/Common.iml>
#include 							<Draw/iml_header.h>

#define IMAGECLASS 		AppImg
#define IMAGEFILE 		<PierHB/App.iml>
#include 							<Draw/iml_header.h>

#define IMAGECLASS 		Flags
#define IMAGEFILE 		<PierHB/Flags.iml>
#include 							<Draw/iml_header.h>

#define IMAGECLASS 		MyHelpImg
#define IMAGEFILE 		<PierHB/MyHelp.iml>
#include 							<Draw/iml_header.h>

// keys
#define KEYGROUPNAME 	"Manager"
#define KEYNAMESPACE 	ManagerKeys
#define KEYFILE      	<PierHB/App.key>
#include             	<CtrlLib/key_header.h>

// Bus
#define DLLFILENAME 	"AsBus.dll"
#define DLIMODULE   	Bus
#define DLIHEADER   	<PierHB/AsBus.dli>
#define DLLCALL       STDAPICALLTYPE
#include 							<Core/dli_header.h>

#include "uPlc.h"

struct 
{
  unsigned char    Out1;
  unsigned char    Out2;
  unsigned char    Out3;
  unsigned char    Out4;
  unsigned char    Out5;
  unsigned char    Out6;
  unsigned char    Out7;
  unsigned char    Out8;
  unsigned char    In1;
  unsigned char    In2;
  unsigned char    In3;
  unsigned char    In4;
  unsigned char    In5;
  unsigned char    In6;
  unsigned char    In7;
  unsigned char    In8;
} typedef Cd;

struct 
{
  unsigned       char    tipo;     		// tipo dispositivo ('E')
  unsigned short int     codice;      // codice dispositivo
  unsigned 			 char    model;       // modello dispositivo 
  unsigned short int     versione;    // versione del dispositivo
  unsigned short int     patch;       // patch della versione
  unsigned       char    byte7;
  unsigned       char    cfg1[8];
  unsigned       char    cfg2[8];
  unsigned       char    addr;     		// Indirizzo in rete
  unsigned short int     prtVer;   		// versione protocollo
  unsigned short int     prtPatch; 		// patch della versione protocollo
  unsigned       char    byte29;
  unsigned       char    byte30;
  unsigned       char    byte31;
  unsigned       __int64 sn;
  unsigned       char    nt;       		// tipo di nodo: 'M', 's'.
  unsigned       int     errCntr;     // numero di errori comunicaz. occorsi
  unsigned       int     lastErr;     // ultimo errore di comunicaz. occorso
  
  // Controls
  int                    ctrlId;
  bool                   ctrlOpened;
  bool									 modify;
  bool                   acceptModify;
  int                    btnIdx;  
} typedef Nodo;

struct
{
  unsigned				int  	success;
  unsigned 				int		getErrors;
  unsigned				int		busFaults;
  unsigned				int		chkErrors;
  unsigned				int		datErrors;
  unsigned				int		tmtErrors;
  unsigned				int   pckErrors;
  unsigned				int		pckTmtErrors;
  unsigned				int		putErrors;
  unsigned				int		othErrors;	
  unsigned        char  contErrors;  
} typedef CommStats;

extern XmlNode 							xn;
extern int                  dev;
extern VectorMap<String, VectorMap<String, String> > iniKeys;
extern volatile Atomic 			terminated, threads;

extern Array<Nodo>										nodo;
extern Array<String>     							cdInBuff;
extern Array<String>     							cdOutBuff;
extern Array<int>        							itemDev;
extern Array<XmlNode>									device;

class App : public WithAppLayout<TopWindow> 
{
public:		  
  bool														networkOpen;
  bool              							readingLoop;
  bool              							goOffline, changeTab;
  bool              							fullCommunication;
  int															lastTabInModify;
  CommStats												cs;

  Array<EditInt> 									ei;
  Array<EditString>								es;
  Array<EditHexInt64> 						eh;
  Array<EditBinInt64> 						eb;
  
  // MT
	Thread 													cl, ud;
  
  // GUI
	MenuBar     										bMenu;
	ToolBar     										bTools;
	Splitter												gLeftFrame, gMainFrame;
	StatusBar												gStatus;
	InfoCtrl												gStat1, gStat2, gStat3, gStat4;
	TreeCtrl												gTree;

	// Layouts
	WithlPrgSettings<TopWindow> 		fPrgSettings;
  WithlSetComDriver<ParentCtrl> 	fComDriver;
	WithlDrvStg_1<TopWindow> 				fStpDrvBase;
  //WithlMainTab<ParentCtrl> 	      fMainTab;
  WithlLeftSide<ParentCtrl> 	    fLeftSide;
  Array<WithlDevice<ParentCtrl> > gDevice;
	
  // main.cpp
  void Quit();
  void ShowTab(int n);
  void ChangeTab();
  
  // menu.cpp
  void MainMenu(Bar& bar);
  void FileMenu(Bar& bar);
  void SettingsMenu(Bar& bar);
  void CommMenu(Bar& bar);
	//void HelpMenu(Bar& bMenu);
	void ToolsBar(Bar& bar);
 	void SetToolsBar();
 	void InitTree();
 	void TreeCursor();
 	void Languages(Bar& bar);
 	void HelpMenu(Bar& bMenu);
 	
 	// VarAnimation.cpp
 	void DevGetData();
 	void Modify();
 	void CancelModify();
 	void DevicePutData();
	void Statistics(int r);

	//files.cpp
	void FileSave();
	void FileLoad();
 	
 	// setup.cpp
 	void PrgSetup();
 	void ProgramSetup(int vTab=0);
 	void DriverSettings();
 	void SelectLanguage(const String& lng);
 	
  // help.cpp
  void About()                      { strTopic = "Help/About"; CallHelp(); return; }
  //void WhatsNew()										{ strTopic = "Docs/WhatsNew#2100"; CallHelp(); return; }
  //void HelpIndex()									{ strTopic = "Docs/Index"; CallHelp(); return; }

	//uPlc.cpp
private:
	String						strFileName;
	uPLC_CtrlBuff  		ctrl;
	
public:
	void uPlcSetToolsBar();
	void uPlcToolsBar(Bar& bar);
	
	void uPlcOpenFile(const String &fn);
	void uPlcNewFile();
	void uPlcFileSave();
	void uPlcFileSaveAs();
	
	bool uPlcIsRun();
	bool uPlcIsStop();
	void uPlcSetRun(bool s = true);
	void uPlcDownload();
	void uPlcUpload();

	int uPlcCompiler(Array<PC>& c);

	// CommServer.cpp
 	void OpenNetwork();
	void CommLoop(void);
	bool ReadVar(unsigned char node, unsigned char code, unsigned int addr, unsigned char len, ComVar *ret, bool sync = false);
	bool WriteVar(unsigned char node, unsigned char code, unsigned int addr, unsigned char len, ComVar *data, bool sync = false);
	void CommBuffRemoveKey(unsigned char k);

	typedef App CLASSNAME;
	
	App();
	~App();
};

#include "Updates.h"
#include "CommServer.h"

#endif

