#include "PierHB.h"

void App::PrgSetup() 
{
	ProgramSetup(0);
	return;
}

void App::ProgramSetup(int vTab)
{
	
	UseHomeDirectoryConfig(false);
	
	XmlNode xn = ParseXML(LoadFile(ConfigFile("Support/Driver.cat")));
	
	// Tabs
	fPrgSettings.gTabs.Reset();
	fPrgSettings.gTabs.Add(fComDriver, t_("Communication driver"));

	// Communication driver tab
	fComDriver.gDriverSettings <<= THISBACK(DriverSettings);
	if(xn("CommDriverList").GetCount() > 0) 
  {
	  fComDriver.gDriverList.Enable(true);
	  fComDriver.gDriverList.Clear();
		for(int i = 0; i < xn("CommDriverList").GetCount(); i++) 
		{
		  fComDriver.gDriverList.Add(xn("CommDriverList").At(i).Attr("Sigla"));
		}
	}

  fComDriver.gDriverList.SetData(iniKeys.GetPut("Application").GetPut("UsedCommDriver"));
  fComDriver.gFirstNode.SetData(ScanInt(iniKeys.GetPut("Application").GetPut("FirstScanNode")));
  fComDriver.gLastNode.SetData(ScanInt(iniKeys.GetPut("Application").GetPut("LastScanNode")));
  
	if(fPrgSettings.Execute() == IDOK) 
	{
    iniKeys.GetPut("Application").GetPut("UsedCommDriver") = AsString(~fComDriver.gDriverList);
    iniKeys.GetPut("Application").GetPut("FirstScanNode") = FormatInt(fComDriver.gFirstNode);
    iniKeys.GetPut("Application").GetPut("LastScanNode") = FormatInt(fComDriver.gLastNode);
    gStat1.Set(~fComDriver.gDriverList);
    
    SaveIniKeys(GetExeDirFile("Config.ini"), iniKeys);
	}	
	return;	
}

void App::DriverSettings() 
{
  
  // Parametri cavo di base RS232 - AsBus    
  if(AsString(~fComDriver.gDriverList) == "RS232(USB)-AsBus" || AsString(~fComDriver.gDriverList) == "RS232(USB)-HBus") 
  {
    fStpDrvBase.gPortList.Clear();
    
		HKEY hkey;
		char temp[512];
		dword len;
	
		// recupero i nomi delle porte seriali installate
		if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Hardware\\DeviceMap\\SerialComm", 0, KEY_READ, &hkey) == ERROR_SUCCESS) 
		{
			for(dword dw = 0; len = sizeof(temp), RegEnumValue(hkey, dw, temp, &len, 0, 0, 0, 0) == ERROR_SUCCESS; dw++)
				fStpDrvBase.gPortList.Add(GetWinRegString(temp, "Hardware\\DeviceMap\\SerialComm"));
			
			RegCloseKey(hkey);
		}
		if(fStpDrvBase.gPortList.GetCount() > 0 ) fStpDrvBase.gPortList.Enable(true);
		
		fStpDrvBase.gNodeList.Clear();
		fStpDrvBase.gNodeList.Add((int)1);
		fStpDrvBase.gNodeList.Add((int)2);
		fStpDrvBase.gNodeList.Add((int)3);
		fStpDrvBase.gNodeList.Add((int)4);
		fStpDrvBase.gNodeList.Add((int)5);
		fStpDrvBase.gNodeList.Add((int)6);
		fStpDrvBase.gNodeList.Add((int)7);
		fStpDrvBase.gNodeList.Add((int)8);
		fStpDrvBase.gNodeList.Add((int)9);
	  fStpDrvBase.gNodeList.Enable(true);
		
		fStpDrvBase.gPortList.SetData(iniKeys.GetPut("CommDriver").GetPut("PortaCOM"));
		fStpDrvBase.gNodeList.SetData(ScanInt(iniKeys.GetPut("CommDriver").GetPut("Nodo")));
	
		if(fStpDrvBase.Execute() == IDOK) 
		{
  		iniKeys.GetPut("CommDriver").GetPut("PortaCOM") = AsString(~fStpDrvBase.gPortList);
	  	iniKeys.GetPut("CommDriver").GetPut("Nodo") = AsString(~fStpDrvBase.gNodeList);
			gStat2.Set(AsString(~fStpDrvBase.gPortList) + " - " + AsString(~fStpDrvBase.gNodeList) );
		}	    
  }
  return;
}

void App::SelectLanguage(const String& lng)
{
  
  iniKeys.GetPut("Application").GetPut("Language") = lng;
	SetLanguage(LNGFromText(lng)); 
	PromptOK(t_("The program now will be closed."));
	Quit();
	
	return;
}
