#ifndef _EpdManager_Support_h_
#define _EpdManager_Support_h_

class ConvertHexInt64 : public Convert 
{
public:
	virtual Value Format(const Value& q) const;
	virtual Value Scan(const Value& text) const;
	virtual int   Filter(int chr) const;

protected:
	int64 minval, maxval;
	bool  notnull;

public:
	ConvertHexInt64& MinMax(int64 _min, int64 _max)		{ minval = _min; maxval = _max; return *this; }
	ConvertHexInt64& Min(int64 _min)  	             	{ minval = _min; return *this; }
	ConvertHexInt64& Max(int64 _max) 		             	{ maxval = _max; return *this; }
	ConvertHexInt64& NotNull(bool b = true)         	{ notnull = b; return *this; }
	ConvertHexInt64& NoNotNull()                    	{ return NotNull(false); }
	int64       GetMin() const                    		{ return minval; }
	int64       GetMax() const                    		{ return maxval; }
	bool        IsNotNull() const                 		{ return notnull; }

	ConvertHexInt64(int64 minval = INT64_MIN, int64 maxval = INT64_MAX, bool notnull = false);
	virtual ~ConvertHexInt64();
};

class ConvertBinInt64 : public Convert 
{
public:
	virtual Value Format(const Value& q) const;
	virtual Value Scan(const Value& text) const;
	virtual int   Filter(int chr) const;

protected:
	int64 minval, maxval;
	bool  notnull;

public:
	ConvertBinInt64& MinMax(int64 _min, int64 _max) { minval = _min; maxval = _max; return *this; }
	ConvertBinInt64& Min(int64 _min)               	{ minval = _min; return *this; }
	ConvertBinInt64& Max(int64 _max)               	{ maxval = _max; return *this; }
	ConvertBinInt64& NotNull(bool b = true)         { notnull = b; return *this; }
	ConvertBinInt64& NoNotNull()                    { return NotNull(false); }
	int64       GetMin() const                    	{ return minval; }
	int64       GetMax() const                    	{ return maxval; }
	bool        IsNotNull() const                 	{ return notnull; }

	ConvertBinInt64(int64 minval = -INT_MAX, int64 maxval = INT_MAX, bool notnull = false);
	virtual ~ConvertBinInt64();
};

typedef EditMinMax<int64, ConvertBinInt64>          EditBinInt64;
typedef EditMinMax<int64, ConvertHexInt64>          EditHexInt64;

struct DisplayHexChar : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertHexInt64 convert(-128, 127);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayHexShort : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertHexInt64 convert(-32768, 32767);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayHexInt : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertHexInt64 convert(-21467483648, 21467483647);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayHexInt64 : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertHexInt64 convert(INT64_MIN, INT64_MAX);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayBinChar : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertBinInt64 convert(-128, 127);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayBinShort : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertBinInt64 convert(-32768, 32767);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayBinInt : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertBinInt64 convert(-21467483648, 21467483647);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

struct DisplayBinInt64 : Display 
{
	virtual void Paint(Draw& w, const Rect& r, const Value& q, Color ink, Color paper, dword style) const
	{
    ConvertBinInt64 convert(INT64_MIN, INT64_MAX);
		String txt = convert.Format(q);
		w.DrawRect(r, paper);
		w.DrawText(r.left, r.top, txt);
	}  
};

bool ScanBool(const String &s);
String MyFormatBinInt64(int64 q, int s);
String MyFormatHexInt64(int64 q, int s);
bool MyDeleteFolderDeep(const char *dir, bool onlyEmpty = false);

#endif
