#include "PierHB.h"

void Updates(void)
{
  XmlNode ln = ParseXML(LoadFile(GetExeDirFile("Support/local.upd")));

  /* move the downloaded files to the destination path */
  /* the files are updated automatically in hidden mode for the user */
  int i;
  for(i = 0; i < ln("files").GetCount(); i++)
  { 		
    FileDelete(GetExeDirFile(ln("files").At(i).Attr("relative_dest_path") + ln("files").At(i).Attr("name")));
    FileMove(ln("files").At(i).Attr("temp_path"), GetExeDirFile(ln("files").At(i).Attr("relative_dest_path") + ln("files").At(i).Attr("name")));
    ln("updates")("files").GetAdd(ln("files").At(i).GetTag());
    for(int n = 0; n < ln("files").At(i).GetAttrCount(); n++)
    {
      if(ln("files").At(i).AttrId(n) != "temp_path") ln("updates")("files").GetAdd(ln("files").At(i).GetTag()).SetAttr(ln("files").At(i).AttrId(n), ln("files").At(i).Attr(n));
    }
  }
  if(i >= ln("files").GetCount()) ln("files").Clear();
  SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));

  /* check for new downloaded installation */
  /* The user is able to choose for new installation or not */
  if(ln("installation").GetCount() > 0)
  {
    if(ScanBool(ln("installation").At(0).Attr("isHiddenFromUser")) == false)
    {
	    //int r = PromptOKCancel(t_("[ [ [2 This program has a new release available. V") + ln("installation").At(0).Attr("prog_version") + t_(" build ") + ln("installation").At(0).Attr("progBuild") + t_("]&][ [2 Do you wish to install it?]]"));
	    int r = Prompt(t_("New updates"), CtrlImg::exclamation(), t_("[ [ [2 This program has a new release available. V") + ln("installation").At(0).Attr("prog_version") + t_(" build ") + ln("installation").At(0).Attr("progBuild") + t_("]&][ [2 Do you wish to install it?]]"), t_("O&k"), t_("&Hide it"), t_("&Cancel"));
	    if(r == 1)
	    {
	      WinExec(ln("installation").At(0).Attr("temp_path"), SW_SHOWNORMAL);
	      exit(0);
	    }
	    else if(r == 0)
	    {
	      ln("installation").At(0).SetAttr("isHiddenFromUser", "true");
	      SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));
	    }
    }
  }
    
  // if can, remove temp folder.
  MyDeleteFolderDeep(GetExeDirFile("temp\\"), true);
  
  return;
}

void RestoreHiddenInstall(void)
{
  XmlNode ln = ParseXML(LoadFile(GetExeDirFile("Support/local.upd")));

  if(ln("installation").GetCount() > 0)
  {
    if(FindFile(ln("installation").At(0).Attr("temp_path")))
    { 
    	ln("installation").At(0).SetAttr("isHiddenFromUser", "false");
    	PromptOK(t_("Hidden updates restored. Close the program for install."));
    }
    else 
    {
    	ln("installation").Clear();
    	PromptOK(t_("Updates lost. Restart the program for new download."));
    }
  }
  SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));
  
  return;
}

void GetUpdates(void)
{
  bool done = false;
	HttpClient client;
	client.TimeoutMsecs(3600000);				// 1 hour
	MyHideProgress pi(&terminated);
	String urlRadix;
	urlRadix = iniKeys.GetPut("Application").GetPut("UpdateUrl");
		  
  while(!done)
  {
    while(!done)
    {
			client.URL(urlRadix + "updates.xml");
			String r = client.ExecuteRedirect(HttpClient::DEFAULT_MAX_REDIRECT, HttpClient::DEFAULT_RETRIES, pi);
		  if(client.IsError()) break;
			
			if(r.GetCount() < 1) break;
			XmlNode rn = ParseXML(r);
		  XmlNode ln = ParseXML(LoadFile(GetExeDirFile("Support/local.upd")));
		
		  /* check for new installation */
		  if(rn("updates")("EpdManager")("installation").GetCount() > 0)
		  {
		    // New installation ?
		    if(ScanInt(ln("installation").At(0).Attr("progBuild")) < ScanInt(rn("updates")("EpdManager")("installation").At(0).Attr("progBuild")))
		    {
		      // The build number is higher ?
			    if(ScanInt(rn("updates")("EpdManager")("installation").At(0).Attr("progBuild")) > ScanInt(String(PROG_BUILD)))
			    {
			      // New installation, save the file in local folder
			      client.URL(urlRadix + rn("updates")("EpdManager")("installation").At(0).Attr("downloadURL"));
			      RealizePath(GetExeDirFile("temp\\" + rn("updates")("EpdManager")("installation").At(0).Attr("relative_url")));
			      String file = client.ExecuteRedirect(HttpClient::DEFAULT_MAX_REDIRECT, HttpClient::DEFAULT_RETRIES, pi);
			      if(client.IsError()) break;
			      
			      SaveFile(GetExeDirFile("temp\\" + rn("updates")("EpdManager")("installation").At(0).Attr("relative_url") + rn("updates")("EpdManager")("installation").At(0).Attr("name")), file);
			      ln.GetAdd("installation").GetAdd(rn("updates")("EpdManager")("installation").At(0).GetTag());
			      for(int i = 0; i < rn("updates")("EpdManager")("installation").At(0).GetAttrCount(); i++)
			      {
			        ln("installation").GetAdd(rn("updates")("EpdManager")("installation").At(0).GetTag()).SetAttr(rn("updates")("EpdManager")("installation").At(0).AttrId(i), rn("updates")("EpdManager")("installation").At(0).Attr(i));
			      }
			      // Adding some local vars
			      ln("installation").GetAdd(rn("updates")("EpdManager")("installation").At(0).GetTag()).SetAttr("temp_path", GetExeDirFile("temp\\" + rn("updates")("EpdManager")("installation").At(0).Attr("relative_url") + rn("updates")("EpdManager")("installation").At(0).Attr("name")));
			      ln("installation").GetAdd(rn("updates")("EpdManager")("installation").At(0).GetTag()).SetAttr("isHiddenFromUser", "false");
			      
			      // Save the local updates file
			      SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));
			    }
		    }
		  }
		
		  /* check for new files */
		  if(rn("updates")("EpdManager")("files").GetCount() > 0)
		  {
		    bool brk = false;
		    for(int n = 0; n < rn("updates")("EpdManager")("files").GetCount(); n++)
		    {
		      bool download = false;
		      // Same program build ?
		      if(rn("updates")("EpdManager")("files").At(n).Attr("progBuild") == String(PROG_BUILD))
		      {
		        int j;
			      if((j = ln("updates")("files").FindTag(rn("updates")("EpdManager")("files").At(n).GetTag())) >= 0)
			      {
					    if(ScanInt(rn("updates")("EpdManager")("files").At(n).Attr("fileBuild")) > ScanInt(ln("updates")("files").At(j).Attr("fileBuild")))
					    {
					      download = true;
					    }
		        }
		        else download = true;
		      }
		      if(download)
		      {
			      // New file , save in the local folder
			      client.URL(urlRadix + rn("updates")("EpdManager")("files").At(n).Attr("downloadURL"));
			      RealizePath(GetExeDirFile("temp\\" + rn("updates")("EpdManager")("files").At(n).Attr("relative_url")));
			      String file = client.ExecuteRedirect(HttpClient::DEFAULT_MAX_REDIRECT, HttpClient::DEFAULT_RETRIES, pi);
			      if(client.IsError()) 
			      {
      		    brk = true;
		          break;
			      }
			      
			      if(ScanBool(rn("updates")("EpdManager")("files").At(n).Attr("runtimeOverwritable")))
			      {
			        SaveFile(GetExeDirFile(rn("updates")("EpdManager")("files").At(n).Attr("relative_dest_path") + rn("updates")("EpdManager")("files").At(n).Attr("name")), file);
				      for(int i = 0; i < rn("updates")("EpdManager")("files").At(n).GetAttrCount(); i++)
				      {
				        ln("updates")("files").GetAdd(rn("updates")("EpdManager")("files").At(n).Attr("name")).SetAttr(rn("updates")("EpdManager")("files").At(n).AttrId(i), rn("updates")("EpdManager")("file").At(n).Attr(i));
					      // Save the local updates file
					      SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));
				        
				      }
			      }
			      else
			      {
				      SaveFile(GetExeDirFile("temp\\" + rn("updates")("EpdManager")("files").At(n).Attr("relative_url") + rn("updates")("EpdManager")("files").At(n).Attr("name")), file);
				      ln.GetAdd("files");
				      for(int i = 0; i < rn("updates")("EpdManager")("files").At(n).GetAttrCount(); i++)
				      {
				        ln("files").GetAdd(rn("updates")("EpdManager")("files").At(n).GetTag()).SetAttr(rn("updates")("EpdManager")("files").At(n).AttrId(i), rn("updates")("EpdManager")("files").At(n).Attr(i));
				      }
				      // Adding some local vars
				      ln("files").GetAdd(rn("updates")("EpdManager")("files").At(n).GetTag()).SetAttr("temp_path", GetExeDirFile("temp\\" + rn("updates")("EpdManager")("files").At(n).Attr("relative_url") + rn("updates")("EpdManager")("files").At(n).Attr("name")));
				      ln("files").GetAdd(rn("updates")("EpdManager")("files").At(n).GetTag()).SetAttr("isHiddenFromUser", "false");
				      // Save the local updates file
				      SaveFile(GetExeDirFile("Support/local.upd"), AsXML(ln, XML_HEADER));
			      }
		      }
		      
		      if(terminated) 
		      {
		        brk = true;
		        break;
		      }
		    }
		    if(brk) break;
		  }
		  
		  done = true;
	  }
	  	  
	  if(!done) 
	  {
   		int time = msecs();
   		while(msecs(time) < 5000)
   		{
        Sleep(10);
   		  if(terminated == 1) break;
   		}
	  }
	  if(terminated == 1) break;
  }
  
  AtomicDec(threads);
  return;
}
