#include "PierHB.h"

void App::uPlcSetToolsBar() 
{
	gDevice.At(dev).gMenuBar.Set(THISBACK(uPlcToolsBar));
	return;	
}

void App::uPlcToolsBar(Bar& bar) 
{
	bar.Add(CommonImg::New_0_16(), THISBACK(uPlcNewFile));
	bar.Add(CommonImg::Open_0_16(), THISBACK1(uPlcOpenFile, ""));
	bar.Add(CommonImg::Save_0_16(), THISBACK(uPlcFileSaveAs));
	bar.Separator();
	bar.Add(AppImg::Run_0_16(), THISBACK1(uPlcSetRun, true));
	bar.Add(AppImg::Stop_0_16(), THISBACK1(uPlcSetRun, false));	
	bar.Separator();
	bar.Add(AppImg::uPlcDevDl_1_16(), THISBACK(uPlcDownload));
	bar.Add(AppImg::uPlcDevUl_1_16(), THISBACK(uPlcUpload));
	
	return;
}

void App::uPlcOpenFile(const String &fn) 
{
	FileSelector fs;

	fs.Type("hpc files", "*.hpc").DefaultExt("hpc").ActiveDir(GetHomeDirectory());
	if(!fs.ExecuteOpen(t_("Open"))) {
		return;
	}
  
  XmlNode n = ParseXML(LoadFile(fs.Get()));
  gDevice.At(dev).gCodeEdit.Set(Decode64(n("HomePlc")("Source").GatherText()));

	return;
}

void App::uPlcNewFile() 
{
	gDevice.At(dev).gCodeEdit.Clear();
	
	return;	
}

void App::uPlcFileSave() 
{

	XmlNode t;
	t.Add("HomePlc");
  t("HomePlc").Add("Source");
  
  t("HomePlc")("Source").At(0).CreateText(Encode64(gDevice.At(dev).gCodeEdit.Get()));
	
	String xml = AsXML(t, XML_HEADER);
	SaveFile(strFileName, xml);
	return;	
}

void App::uPlcFileSaveAs() 
{
	FileSelector fs;

	fs.Type("hpc files", "*.hpc").DefaultExt("hpc");
	if(!fs.ExecuteSaveAs(t_("Select file"))) {
		return;
	}
	strFileName = fs;
	uPlcFileSave();	
	
	return;		
}

bool App::uPlcIsRun()
{
	ComVar cv;
		
	ReadVar((unsigned char)nodo.At(dev).addr, 'G', 0x0000, 8, &cv, true);
	if(cv.quality == 100)
	{
	  memcpy(ctrl.In, cv.var, 8);
		return (cv.var[0] & 0x01) == 0x01;  
	}
	else return false;	
}

bool App::uPlcIsStop()
{
	ComVar cv;
		
	ReadVar((unsigned char)nodo.At(dev).addr, 'G', 0x0000, 8, &cv, true);
	if(cv.quality == 100)
	{
	  memcpy(ctrl.In, cv.var, 8);
		return (cv.var[0] & 0x01) == 0x00;  
	}
	else return false;	
}

void App::uPlcSetRun(bool s)
{
	ComVar cv;
		
	// control buffer
	if(s)
	{
		ctrl.Out[0] = ctrl.Out[0] & 0xfc | 0x02;  
	}
	else
	{
		ctrl.Out[0] = ctrl.Out[0] & 0xfc | 0x01;  
	}
	
	memcpy(cv.var, ctrl.Out, 8);	  
	WriteVar((unsigned char)nodo.At(dev).addr, 'S', 0x0000, 8, &cv);
	
	return;	
}

void App::uPlcDownload() 
{
  String  porta, r;
 	XmlNode &dm = device.At(dev).At(0);	
	XmlNode &features = dm("uPLC")("Features");
	ComVar cv;

	porta = iniKeys.GetPut("CommDriver").GetPut("PortaCOM");
	
 	if(gDevice.At(dev).gCodeEdit.IsError())
 	{
 		PromptOK(t_("Program errors. Download not possible."));  
 		#ifdef _DEBUG
 			RLOG(String("uPlcDownload(): ") + String(t_("Program errors. Download not possible.")));
 		#endif
 		return;
 	}
 	
 	Array<PC> compiled;
	if(uPlcCompiler(compiled) == 0)
	{
	  // good compiling
	  #ifdef _DEBUG
		  for(int i = 0; i < compiled.GetCount(); i++)
		  {
		    PC &pc = compiled.At(i);
		    RLOG(String("Compiled: ") + AsString(i) + String(" - ") + FormatIntHexUpper((int)pc.b0, 2) + String(" ") + FormatIntHexUpper((int)pc.b1, 2) + String(" ") + FormatIntHexUpper((int)pc.b2, 2));
		  }
		#endif
		
	  if(!Bus().IsPortOpen(vBusHandle)) 
	  {
		  vBusHandle = Bus().OpenPort(porta);
		  if(!Bus().IsPortOpen(vBusHandle)) 
		  {
		    Exclamation(t_("Error opening the port. The COM port could be in use or unavailable."));
		    return;
		  }
	  }

		int adr = ScanInt(features.Attr("IstrStartAddr"));

	  for(int i = 0; i < compiled.GetCount(); i++)
	  {
	    PC &pc = compiled.At(i);
	    cv.var[0] = pc.b0;
	    cv.var[1] = pc.b1;
	    cv.var[2] = pc.b2;
	    
		  bool r = WriteVar((unsigned char)nodo.At(dev).addr, 'w', adr, 3, &cv, true);
		  if(r == false) 
		  {
				#ifdef _DEBUG
					RLOG(String("uPlcDownload(): PutData error."));
				#endif		    
		  	return; 
		  }
		  adr += 3;
	  }		
	}
	
  return;
}

void App::uPlcUpload() 
{
 	XmlNode &dm = device.At(dev).At(0);
 	String data("0123456789abcdefghijklmnopq");

	String porta = iniKeys.GetPut("CommDriver").GetPut("PortaCOM");
	
  if(!Bus().IsPortOpen(vBusHandle)) 
  {
	  vBusHandle = Bus().OpenPort(porta);
	  if(!Bus().IsPortOpen(vBusHandle)) 
	  {
	    Exclamation(t_("Error opening the port. The COM port could be in use or unavailable."));
	    return;
	  }
  }

	int r = Bus().SendServBuffer(vBusHandle, ln, nodo.At(dev).addr, 21, 21, data.GetLength(), ~data);
	return;
}

int App::uPlcCompiler(Array<PC>& c)
{
 	XmlNode &dm = device.At(dev).At(0);

	XmlNode &il 			= dm("uPLC")("IL");
	XmlNode &ma 			= dm("uPLC")("MA");
	XmlNode &features = dm("uPLC")("Features");
	XmlNode &dobj 		= dm("uPLC")("DevicesObjects");
	XmlNode &pn 			= dm("uPLC")("PartnerNode");

	c.Clear();

	for(int i = 0; i < gDevice.At(dev).gCodeEdit.GetLineCount(); i++)
	{
		String line = gDevice.At(dev).gCodeEdit.GetEncodedLine(i);
		#ifdef _DEBUG
			RLOG(String("uPlcCompiler(): line = ") + line);
		#endif
		Vector<String> re;	// row elements
		uPlcSplitLineCode(line, re);
		
		PC		pc;
		pc.b0 = pc.b1 = pc.b2 = 0;
		
		if(re.GetCount() > 0)
		{
		  int j;
	  	for(j = 0; j < il.GetCount(); j ++)
	  	{
				if(il[j].GatherText() == re[0])
				{
					pc.b0 = (ScanInt(il[j].Attr("Binary"), NULL, 16) << 3 & 0xf8);
					j = il.GetCount() + 1;
				}
	  	}
	  	if(j == il.GetCount())
	  	{
	  		c.Clear();
				#ifdef _DEBUG
					RLOG(String("uPlcCompiler(): error -2. Program line: ") + AsString(i));
				#endif
	  		return -2;	// Instruction not recognized  
	  	}
		}
  	
		if(re.GetCount() > 1)
		{
		  int j;
	  	for(j = 0; j < ma.GetCount(); j ++)
	  	{
				if(ma[j].GatherText() == re[1])
				{
					pc.b0 = pc.b0 | (ScanInt(ma[j].Attr("Area"), NULL, 16) & 0x07);
					j = ma.GetCount() + 1;
				}
	  	}
	  	if(j == ma.GetCount())
	  	{
	  		c.Clear();
				#ifdef _DEBUG
					RLOG(String("uPlcCompiler(): error -3. Program line: ") + AsString(i));
				#endif
	  		return -3;	// Memory area type not recognized  
	  	}
		}
		
		if(re.GetCount() > 2)
		{
			Vector<String> adr = Split(re[2], '.');
			if(re[1] == "#")
			{
			  int a = ScanInt(adr[0]);
			  pc.b1 = a / 256;
			  pc.b2 = a & 0xff;
			}
			else
			{
			  if(adr.GetCount() > 2)
			  {
			  	pc.b1 = ScanInt(adr[0]);  
			  	pc.b2 = (ScanInt(adr[1]) << 3) & 0xf8;  
			  	pc.b2 |= ScanInt(adr[2]) & 0x07;  
			  }
			  else if(adr.GetCount() > 1)
			  {
			  	pc.b2 = (ScanInt(adr[0]) << 3) & 0xf8;  
			  	pc.b2 |= ScanInt(adr[1]) & 0x07;
			  }
			  else if(adr.GetCount() == 1)
			  {
			  	pc.b2 = (ScanInt(adr[0]) << 3) & 0xf8;  
			  }
			  else
			  {
		  		c.Clear();
					#ifdef _DEBUG
						RLOG(String("uPlcCompiler(): error -5. Program line: ") + AsString(i));
					#endif
		  		return -5;	// Address not recognized  		  			    
			  }
			}
		}
		//else
		//{
  	//	c.Clear();
		//	#ifdef _DEBUG
		//		RLOG(String("uPlcCompiler(): error -4. Program line: ") + AsString(i));
		//	#endif
  	//	return -4;	// Uncomplete row  		  
		//}
		
		// Add next compiled row
		c.Add(pc);
  	
  	if(c.GetCount() > ScanInt(features.Attr("IstrMaxSize")))
  	{
  		c.Clear();
			#ifdef _DEBUG
				RLOG(String("uPlcCompiler(): error -1. Program line: ") + AsString(i));
			#endif
  		return -1;			// Program size exceding device capacity  
  	}
	}
	
	for(int i = c.GetCount(); i < ScanInt(features.Attr("IstrMaxSize")); i++)
	{
		PC v;
		v.b0 = v.b1 = v.b2 = 0;
		c.Add(v);  
	}
  
  return 0;
}

void uPlcSplitLineCode(String &s, Vector<String> &r)
{
  r = Split(s, " ");
  return;
}
