#include "PierHB.h"

void LoadIniKeys(const char *filename, VectorMap<String, VectorMap<String, String> >& key) 
{
	int c;
	bool s, n, o, p, lf;
	FileIn in(filename);

	if(!in) return;
	
	key.Clear();
	key.Add(""); // first record is for undefined group
	
	if((c = in.Get()) < 0) return;
	for(;;) 
	{
		String g, k, v;
		o = false; // Group
		p = false; // End group
		n = false; // Key
		s = false; // Value
		lf = false;
		for(;;) 
		{
			if((IsAlNum(c) || c == '_') && !s && !o) // is a key
			{ 
				n = true;
				k.Cat(c);
			}
	    else if((c == '[' || o) && !p && !n && !s) // is a group
	    {
	      if(c >= ' ' && c != '[' && c != ']') 
	        g.Cat(c);
	      
	      if(c == ']')
	        p = true;
	      
	      o = true;
			}
			else if(c >= ' ' && !n && !o) // is other
			{
				s = true;
				v.Cat(c);
		  }
		  if(n && (c == ' ' || c == '=')) break;
			if((c = in.Get()) < ' ') break;
		}
		if(n) // Key found, search the value
		{
			for(;;) {
				if(c != '=' && c != ' ') break;
				if((c = in.Get()) < 0) return;
			}
			for(;;) {
				if(c < ' ') break;
				v.Cat(c);
				if((c = in.Get()) < 0) break;
			}
		}
		// Row scan ended
		
		if(!g.IsEmpty())
		{
		  key.Add(g);
		}
		
		if(!k.IsEmpty() || s)
		{
			key[key.GetCount()-1].Add(k, v);
		}
				
		if(k == "LINK") 
		{
			in.Close();
			if(!in.Open(v) || (c = in.Get()) < 0) return;
		}
		if( c < 0 ) return;
		if((c = in.Get()) < 0) return;
		
		if(g.IsEmpty() && k.IsEmpty() && v.IsEmpty() && (c == 10))
		{
		  key[key.GetCount()-1].Add(k, v);
		}		
	}
}

void SaveIniKeys(const char *filename, VectorMap<String, VectorMap<String, String> >& keys) 
{
  int i, j;
  
  DeleteFile(filename + String(".bak"));
  FileMove(filename, filename + String(".bak"));
  //DeleteFile(filename);
  
	FileOut out(filename);
  for (i=0; i<keys.GetCount(); i++)
  {
    if(!keys.GetKey(i).IsEmpty())
    {
      out.PutLine("[" + keys.GetKey(i) + "]");
    }
    VectorMap<String, String> &l = keys[i];  
		for (j=0; j<l.GetCount(); j++)
		{
		  if( l.GetKey(j).IsEmpty() )
		  {
		    out.PutLine(l[j]); 
		  }
		  else
		  {
		    out.PutLine(l.GetKey(j) + "=" + l[j]); 
		  }
		}
  }
	out.Close();
  DeleteFile(filename + String(".bak"));
  return;
}
