#include "PierHB.h"

#ifdef PLATFORM_WIN32

String GetShellFolder(const char *name, HKEY type) 
{
	return GetWinRegString(name, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", type);
}

void RemoveWindowsItems() 
{
	DeleteFile(AppendFileName(GetShellFolder("Desktop", HKEY_CURRENT_USER), "EpdManager.lnk"));

	DeleteWinReg("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\EpdManager", HKEY_LOCAL_MACHINE);
	if(!PromptYesNo(t_("Do you wish to remove all registry key?"))) return;
	DeleteWinReg(".epd", HKEY_CLASSES_ROOT);
	DeleteWinReg("EpdManager.epd", HKEY_CLASSES_ROOT);
	
	return;
}

void Uninstall() 
{
  LoadIniKeys(GetExeDirFile("Config.ini"), iniKeys);

  SetLanguage(LNGFromText(iniKeys.GetPut("Application").GetPut("Language")));
	SetDefaultCharset(CHARSET_UTF8);
	Draw::SetStdFont(Tahoma(11));
  
	String path = GetExeFilePath();
	String dir = GetFileFolder(path);
	String bat = AppendFileName(dir.Left(2), "ERemove.bat");
	if(!PromptYesNo(t_("[*3 Do you wish to remove the tool EpdManager from the computer ?&&]"
	                "All the file and program folder will be removed."))) return;
	MyDeleteFolderDeep(dir, false);
	RemoveWindowsItems();
	MyDeleteFolderDeep(~String(GetShellFolder("Programs", HKEY_CURRENT_USER) + "\\" + iniKeys.GetPut("InstallUninstall").GetPut("StartFolderPath")), false);
	SaveFile(bat,
		":Repeat\r\n"
		"@del \"" + path + "\"\r\n"
		"if exist \"" + path + "\" goto Repeat\r\n"
		"rmdir \"" + dir + "\"\r\n"		
		"@del \"" + bat + "\"\r\n"
	);

	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;
	char h[512];
	strcpy(h, bat);
	if(!CreateProcess(NULL, h, NULL, NULL, FALSE, IDLE_PRIORITY_CLASS, NULL, dir.Left(2), &si, &pi))
		Exclamation(t_("Removal incomplete ... Unable to delete some files."));
	else
		Exclamation(t_("Removal completed successfully."));
}	

#else

void Uninstall() {}

#endif
