#include "PierHB.h"

void App::DevGetData() 
{
	int j, l;
	String s;
	String porta;
	int64  a, b, c, d, e, f, g, h, v;
		
	bool cdBuff = false;
	
  ArrayCtrl &ac = gDevice.At(dev).gMainAc;
	XmlNode &n = device.At(dev);
  String &In = cdInBuff.At(dev);
    		
	for(int l = 0; l < n.GetCount(); l++)
	{
		if(ScanBool(n.At(l).Attr("isCyclic"))) cdBuff = true;
	}
		
	if(n.GetCount() > 0) 
	{
    // preparazione struttura dell'array
    // i campi simboli vengono visualizzati nello stesso
    // ordine con cui sono scritti nel database
    if(nodo.At(dev).ctrlOpened == false) 
    {
			// Aggiungo una riga vuota di separazione
			ac.Add("---", "");
			for(int l = 0; l < n.GetCount(); l++)
			{
			  if(ScanBool(n.At(l).Attr("Hidden")) == false)
			  {
	        ac.Add(n.At(l).GetTag(), "", "", n.At(l).Attr("DescrizioneDato"));
	        if(ScanBool(n.At(l).Attr("isWritable"))) 
	        {
		        if(ScanInt(n.At(l).Attr("Tipo")) == 2) 			// String
		        {
		      	  ac.SetCtrl(ac.GetCount()-1, 1, es.Add().MaxLen(8).NotNull(false) );
		      	  ac.Set(ac.GetCount()-1, 4, es.GetCount()-1);
		        }
		        else if(ScanInt(n.At(l).Attr("Tipo")) > 2) 	// integer Numbers
		        {
		          if(ScanInt(n.At(l).Attr("Visualizzazione")) == 3)  				// Decimal
		          {
		      	  	ac.SetCtrl(ac.GetCount()-1, 1, ei.Add().Max(ScanInt(n.At(l).Attr("ValoreMassimo"))).Min(ScanInt(n.At(l).Attr("ValoreMinimo"))));
		      	  	ac.Set(ac.GetCount()-1, 4, ei.GetCount()-1);
		          }
		          else if(ScanInt(n.At(l).Attr("Visualizzazione")) == 2)  	// Binary
		          {
	      	  	  ac.SetCtrl(ac.GetCount()-1, 1, eb.Add().Max(ScanInt(n.At(l).Attr("ValoreMassimo"))).Min(ScanInt(n.At(l).Attr("ValoreMinimo"))));
	      	  	  ac.Set(ac.GetCount()-1, 4, eb.GetCount()-1);
		          }
		          else if(ScanInt(n.At(l).Attr("Visualizzazione")) == 1)  	// Hexadecimal
		          {
	      	  	  ac.SetCtrl(ac.GetCount()-1, 1, eh.Add().Max(ScanInt(n.At(l).Attr("ValoreMassimo"))).Min(ScanInt(n.At(l).Attr("ValoreMinimo"))));
	      	  	  ac.Set(ac.GetCount()-1, 4, eh.GetCount()-1);
		          }
		        }
	        }
	        else
	        {
	          if(ScanInt(n.At(l).Attr("Tipo")) > 2)
	          {
	            if(ScanInt(n.At(l).Attr("Visualizzazione")) == 2)
	            {
	              if(ScanInt(n.At(l).Attr("Tipo")) == 3 || ScanInt(n.At(l).Attr("Tipo")) == 5)
	              {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayBinChar>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 4 || ScanInt(n.At(l).Attr("Tipo")) == 6)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayBinShort>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 7 || ScanInt(n.At(l).Attr("Tipo")) == 8)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayBinInt>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 9 || ScanInt(n.At(l).Attr("Tipo")) == 10)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayBinInt64>());
		            }
	
	            }
	            else if(ScanInt(n.At(l).Attr("Visualizzazione")) == 1)
	            {
	              if(ScanInt(n.At(l).Attr("Tipo")) == 3 || ScanInt(n.At(l).Attr("Tipo")) == 5)
	              {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayHexChar>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 4 || ScanInt(n.At(l).Attr("Tipo")) == 6)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayHexShort>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 7 || ScanInt(n.At(l).Attr("Tipo")) == 8)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayHexInt>());
		            }
		            if(ScanInt(n.At(l).Attr("Tipo")) == 9 || ScanInt(n.At(l).Attr("Tipo")) == 10)
		            {
	                ac.SetDisplay(ac.GetCount() - 1, 1, Single<DisplayHexInt64>());
		            }
	            }
	          }
	        }
        }
	              
    	  /* Tipo rappresentazione */
    	  switch(ScanInt(n.At(l).Attr("Visualizzazione")))
    	  {
    	    case 3:
    	      ac.Set(ac.GetCount()-1, 2, "DEC.");
    	      break;
    	    
          case 2:
    	      ac.Set(ac.GetCount()-1, 2, "BIN.");
    	      break;
          
          case 1:
    	      ac.Set(ac.GetCount()-1, 2, "HEX.");
    	      break;
          
          default:
            break;  
    	  }        
			}
			nodo.At(dev).ctrlOpened = true;
    }
        
		while(true)
		{
		  commLoopStop = 0;
		  ComVar cv;
		  	
			/* header fields */
	    if(!nodo.At(dev).modify || !fullCommunication)
	    {
	      eh.At(ac.Get(2, 4)).SetReadOnly();
	      ei.At(ac.Get(3, 4)).SetReadOnly();
	      ac.EnableLine(2, false);
	      ac.EnableLine(3, false);
	    }
	    else
	    {
	      eh.At(ac.Get(2, 4)).SetEditable();
	      ei.At(ac.Get(3, 4)).SetEditable();
	      ac.EnableLine(2, true);
	      ac.EnableLine(3, true);
	    }

	    j = 5; // Prima riga dell'array su cui compaiono i dati

			//read cyclic data
			if(cdBuff) 
			{
				ReadVar((unsigned char)nodo.At(dev).addr, 'G', 0x0000, 8, &cv);
				In.Clear();
				In.Cat(cv.var, 8);
			}

			// show data
			for(l = 0; l < n.GetCount(); l++)
			{
			  
				if(ScanBool(n.At(l).Attr("Hidden")) == false)
				{
		      if(ScanBool(n.At(l).Attr("isWritable")))
		      {
		        if(!nodo.At(dev).modify) 
		        {
		          ac.EnableLine(j, false);
			        if(ScanInt(n.At(l).Attr("Tipo")) == 2) es.At(ac.Get(j, 4)).SetReadOnly();
			        else
			        {
			          if(ScanInt(n.At(l).Attr("Visualizzazione")) == 3) ei.At(ac.Get(j, 4)).SetReadOnly();
			          else if (ScanInt(n.At(l).Attr("Visualizzazione")) == 2) eb.At(ac.Get(j, 4)).SetReadOnly();
								else if (ScanInt(n.At(l).Attr("Visualizzazione")) == 1) eh.At(ac.Get(j, 4)).SetReadOnly();
			        }
		        }
		        else
		        {
		          ac.EnableLine(j, true);
			        if(ScanInt(n.At(l).Attr("Tipo")) == 2) es.At(ac.Get(j, 4)).SetEditable();
			        else
			        {
			          if(ScanInt(n.At(l).Attr("Visualizzazione")) == 3) ei.At(ac.Get(j, 4)).SetEditable();
			          else if (ScanInt(n.At(l).Attr("Visualizzazione")) == 2) eb.At(ac.Get(j, 4)).SetEditable();
								else if (ScanInt(n.At(l).Attr("Visualizzazione")) == 1) eh.At(ac.Get(j, 4)).SetEditable();
			        }
			        ac.Select(-1);
		        }
		      }
		      else
		      {
		      	ac.EnableLine(j, false);  
		      }
				  
		      /* vars fields */
				  if(ScanBool(n.At(l).Attr("isCyclic")) && ScanBool(n.At(l).Attr("isReadable"))) 
				  {
		        if(ScanInt(n.At(l).Attr("Tipo")) == 2) 									// Stringa
		        {
		          if((!ScanBool(n.At(l).Attr("isWritable")) || !nodo.At(dev).modify))
		          {
		            ac.Set(j, 1, AsString(In[ScanInt(n.At(l).Attr("Indirizzo"))]));
		          }
		        }
		        else
		        {
				      if(ScanInt(n.At(l).Attr("Tipo")) == 3) 			    			// unsigned char
			        {
			          if(In.GetLength() >= 1)
			          {
				          a = (uint64)In[ScanInt(n.At(l).Attr("Indirizzo"))+0] & 0xff;
				          v = a;
			          }
			          else v = Null;
			        }
			        else if(ScanInt(n.At(l).Attr("Tipo")) == 4) 					// unsigned int 2 byte
			        {
			          int x = ScanInt(n.At(l).Attr("Indirizzo"));
			          String z = In;
			          if(z.GetLength() >= x + 2)
			          {
				          a = ((uint64)z[x+0]) & 0xff;
				          b = ((uint64)z[x+1]) & 0xff;
				          v = (b << 8) + a;
			          }
			          else v = Null;
			        }
				      else if(ScanInt(n.At(l).Attr("Tipo")) == 5) 			    // signed char
			        {
			          if(In.GetLength() >= 1)
			          {
				          a = ((uint64)In[ScanInt(n.At(l).Attr("Indirizzo"))+0]) & 0xff;
				          v = a;
				          if (v >= 128) v = (uint64)v - (int)256;
			          }
			          else v = Null;
			        }
			        else if(ScanInt(n.At(l).Attr("Tipo")) == 6) 					// short 2 byte
			        {
			          int x = ScanInt(n.At(l).Attr("Indirizzo"));
			          String z = In;
			          if(z.GetLength() >= x + 2)
			          {
				          a = ((uint64)z[x+0]) & 0xff;
				          b = ((uint64)z[x+1]) & 0xff;
				          v = (b << 8) + a;
				          if(v >= 32768) v = (uint64)v - (int)65536;
			          }
			          else v = Null;
			        }
			        else if(ScanInt(n.At(l).Attr("Tipo")) == 7) 					// int 4 byte
			        {
			          int x = ScanInt(n.At(l).Attr("Indirizzo"));
			          String z = In;
			          if(z.GetLength() >= x + 2)
			          {
				          a = ((uint64)z[x+0]) & 0xff;
				          b = ((uint64)z[x+1]) & 0xff;
				          c = ((uint64)z[x+2]) & 0xff;
				          d = ((uint64)z[x+3]) & 0xff;
				          v = (d << 24) + (c << 16) + (b << 8) + a;
				          if(v >= 2147483647) v = (uint64)v - (int)2147483647;
			          }
			          else v = Null;
			        }
			        else if(ScanInt(n.At(l).Attr("Tipo")) == 8) 					// unsigned int 4 byte
			        {
			          int x = ScanInt(n.At(l).Attr("Indirizzo"));
			          String z = In;
			          if(z.GetLength() >= x + 2)
			          {
				          a = ((uint64)z[x+0]) & 0xff;
				          b = ((uint64)z[x+1]) & 0xff;
				          c = ((uint64)z[x+2]) & 0xff;
				          d = ((uint64)z[x+3]) & 0xff;
				          v = (d << 24) + (c << 16) + (b << 8) + a;
			          }
			          else v = Null;
			        }
			        else if(ScanInt(n.At(l).Attr("Tipo")) == 9 || ScanInt(n.At(l).Attr("Tipo")) == 10) 					// int64 8 byte
			        {
			          int x = ScanInt(n.At(l).Attr("Indirizzo"));
			          String z = In;
			          if(z.GetLength() >= x + 2)
			          {
				          a = ((uint64)z[x+0]) & 0xff;
				          b = ((uint64)z[x+1]) & 0xff;
				          c = ((uint64)z[x+2]) & 0xff;
				          d = ((uint64)z[x+3]) & 0xff;
				          e = ((uint64)z[x+4]) & 0xff;
				          f = ((uint64)z[x+5]) & 0xff;
				          g = ((uint64)z[x+6]) & 0xff;
				          h = ((uint64)z[x+7]) & 0xff;
				          v = (h << 56) + (g << 48) + (f << 40) + (e << 32) + (d << 24) + (c << 16) + (b << 8) + a;
			          }
			          else v = Null;
			        }
			        
		          if((!ScanBool(n.At(l).Attr("isWritable")) || !nodo.At(dev).modify))
		          {
			          ac.Set(j, 1, v);
		          }	        
		        }
				  }
				  else 
				  {
				    
				    if(ScanBool(n.At(l).Attr("isParameter"))) 
				    {
							ReadVar((unsigned char)nodo.At(dev).addr, 'r', ScanInt(n.At(l).Attr("Indirizzo")), ScanInt(n.At(l).Attr("Lunghezza")), &cv);
				    }
				    else 
				    {
							ReadVar((unsigned char)nodo.At(dev).addr, 'R', ScanInt(n.At(l).Attr("Indirizzo")), ScanInt(n.At(l).Attr("Lunghezza")), &cv);
				    }
						s.Clear();
						s.Cat(cv.var, ScanInt(n.At(l).Attr("Lunghezza")));
		
		        if(cv.quality >= 50)
		        {
		          if(ScanInt(n.At(l).Attr("Tipo")) == 2)							// Stringa 
		          {
			          if((!ScanBool(n.At(l).Attr("isWritable")) || !nodo.At(dev).modify))
			          {
		              ac.Set(j, 1, AsString(s[0]));
			          }
		          }
		          else
			        {
			          if(ScanInt(n.At(l).Attr("Tipo")) == 3)  					// unsigned char
			          {
				          a = (uint64)s[0] & 0xff;
				          v = a;
			          }
			          else if(ScanInt(n.At(l).Attr("Tipo")) == 4)  			// unsigned int 2 byte
			          {
				          a = (uint64)s[0] & 0xff;
				          b = (uint64)s[1] & 0xff;
			            v = (b << 8) + a;	          
			          }
			          else if(ScanInt(n.At(l).Attr("Tipo")) == 5)  			// signed char
			          {
				          a = ((uint64)s[0]) & 0xff;
				          v = a;
			            if (v >= 128) v = (uint64)v - (int)256;
			          }
			          else if(ScanInt(n.At(l).Attr("Tipo")) == 6)  			// int 2 byte
			          {
				          a = ((uint64)s[0]) & 0xff;
				          b = ((uint64)s[1]) & 0xff;
			            v = (b << 8) + a;
			            if(v >= 32768) v = (uint64)v - (int)65536;
			          }
				        else if(ScanInt(n.At(l).Attr("Tipo")) == 7) 					// int 4 byte
				        {
				          a = ((uint64)s[0]) & 0xff;
				          b = ((uint64)s[1]) & 0xff;
				          c = ((uint64)s[2]) & 0xff;
				          d = ((uint64)s[3]) & 0xff;
				          v = (d << 24) + (c << 16) + (b << 8) + a;
				          if(v >= 2147483647) v = (uint64)v - (int)2147483647;
				        }
				        else if(ScanInt(n.At(l).Attr("Tipo")) == 8) 					// unsigned int 4 byte
				        {
				          a = ((uint64)s[0]) & 0xff;
				          b = ((uint64)s[1]) & 0xff;
				          c = ((uint64)s[2]) & 0xff;
				          d = ((uint64)s[3]) & 0xff;
				          v = (d << 24) + (c << 16) + (b << 8) + a;
				        }
				        else if(ScanInt(n.At(l).Attr("Tipo")) == 9 || ScanInt(n.At(l).Attr("Tipo")) == 10) 					// int64 8 byte
				        {
				          a = ((uint64)s[0]) & 0xff;
				          b = ((uint64)s[1]) & 0xff;
				          c = ((uint64)s[2]) & 0xff;
				          d = ((uint64)s[3]) & 0xff;
				          e = ((uint64)s[4]) & 0xff;
				          f = ((uint64)s[5]) & 0xff;
				          g = ((uint64)s[6]) & 0xff;
				          h = ((uint64)s[7]) & 0xff;
				          v = (h << 56) + (g << 48) + (f << 40) + (e << 32) + (d << 24) + (c << 16) + (b << 8) + a;
				        }
		
			          if((!ScanBool(n.At(l).Attr("isWritable")) || !nodo.At(dev).modify))
			          {
				          ac.Set(j, 1, v);
			          }		        
			        }
		        }
				  }
				  j++;
				}
			}
			ProcessEvents();
						
			if(goOffline || changeTab)
			{
			  commLoopStop = 1;
			  while(commLoop) Sleep(5);
				CommBuffRemoveKey((unsigned char)nodo.At(dev).addr);			  
			  if(changeTab) ChangeTab();
			  if(goOffline) OpenNetwork();
			  break;	    
			}
		}
	}
		
	return;
}

void App::Modify()
{
	int i;
	i = itemDev.At(fLeftSide.gMainTab.Get());

  if(!nodo.At(i).modify)
  {
    nodo.At(i).modify = true;
    gDevice.At(i).gModify.SetLabel(t_("Accept"));
    lastTabInModify = i;
  }
  else
  {    
    DevicePutData();    
    nodo.At(i).modify = false;
    gDevice.At(i).gModify.SetLabel(t_("Modify"));    
  }
    
  return;
}

void App::CancelModify()
{
  nodo.At(lastTabInModify).modify = false;
  gDevice.At(lastTabInModify).gModify.SetLabel(t_("Modify"));	
  
  return;
}

void App::DevicePutData()
{
	int j, k, r, l;
	String s;
  char ch[8];
	
	//i = itemDev.At(fLeftSide.gMainTab.Get());
  ArrayCtrl &ac = gDevice.At(dev).gMainAc;
  XmlNode &n = device.At(dev).At(0);

  for(l = 0; l < 8; l++) ch[l] = 0;
  
  // Put new values in the device
  cdOutBuff.At(dev).Clear();
  if(fullCommunication)
  {
    // Serial number
    s.Clear();
    int64 x = (int64)ac.Get(2, 1);
    s.Cat((char)(x));
    s.Cat((char)(x >> 8));
    s.Cat((char)(x >> 16));
    s.Cat((char)(x >> 24));
    s.Cat((char)(x >> 32));
    s.Cat((char)(x >> 40));
    s.Cat((char)(x >> 48));
    s.Cat((char)(x >> 56));    
    r = Bus().PutData(vBusHandle, ln, (char)nodo.At(dev).addr, 'w', 32, 8, s);
    Statistics(r);
    
    // node addr
    s.Clear();
    s.Cat((char)((int64)ac.Get(3, 1)));
    r = Bus().PutData(vBusHandle, ln, (char)nodo.At(dev).addr, 'w', 24, 1, s);
    Statistics(r);
  }
  
  // Put other vars
  k = 0;
  for(j = 5; j < ac.GetCount(); j++)
  {
    if(ScanBool(n.At(k).Attr("isWritable")) == true)									// var is writable
    {
      if(ScanBool(n.At(k).Attr("isCyclic")) == true)									// cyclic
      {
        if(ScanInt(n.At(k).Attr("Tipo")) == 2)							// String
        {
          s = String(ac.Get(j, 1)).Right(8);
          for(l = 0; l < ScanInt(n.At(k).Attr("Lunghezza")); l++)
          {
            ch[ScanInt(n.At(k).Attr("Indirizzo")) + l] = s[l];
          }
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 3 || ScanInt(n.At(k).Attr("Tipo")) == 5)				// 1 byte
        {
          ch[ScanInt(n.At(k).Attr("Tipo"))] = (char)((int)ac.Get(j, 1));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 4 || ScanInt(n.At(k).Attr("Tipo")) == 6)				// 2 byte
        {
          int x = ScanInt(n.At(k).Attr("Indirizzo"));
          int64 y = ac.Get(j, 1);
          ch[x + 0] = (char)y;
          ch[x + 1] = (char)(y >> 8);
        }      
        else if(ScanInt(n.At(k).Attr("Tipo")) == 7 || ScanInt(n.At(k).Attr("Tipo")) == 8)				// 4 byte
        {
          int x = ScanInt(n.At(k).Attr("Indirizzo"));
          int64 y = ac.Get(j, 1);
          ch[x + 0] = (char)y;
          ch[x + 1] = (char)(y >>  8);
          ch[x + 2] = (char)(y >> 16);
          ch[x + 3] = (char)(y >> 24);
        }      
        else if(ScanInt(n.At(k).Attr("Tipo")) == 9 || ScanInt(n.At(k).Attr("Tipo")) == 10)			// 8 byte
        {
          int x = ScanInt(n.At(k).Attr("Indirizzo"));
          int64 y = ac.Get(j, 1);
          ch[x + 0] = (char)y;
          ch[x + 1] = (char)(y >>  8);
          ch[x + 2] = (char)(y >> 16);
          ch[x + 3] = (char)(y >> 24);
          ch[x + 4] = (char)(y >> 32);
          ch[x + 5] = (char)(y >> 40);
          ch[x + 6] = (char)(y >> 48);
          ch[x + 7] = (char)(y >> 56);
        }     
      }
      else if(ScanBool(n.At(k).Attr("isParameter")) == true)																			// parameter
      {
        if(ScanInt(n.At(k).Attr("Tipo")) == 2)																								// String
        {
          s = String(ac.Get(j, 1)).Right(8);
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 3 || ScanInt(n.At(k).Attr("Tipo")) == 5)				// 1 byte
        {
          s.Clear();
          s.Cat((char)((int)ac.Get(j, 1)));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 4 || ScanInt(n.At(k).Attr("Tipo")) == 6)				// 2 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 7 || ScanInt(n.At(k).Attr("Tipo")) == 8)				// 4 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
          s.Cat((char)(y >> 16));
          s.Cat((char)(y >> 24));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 9 || ScanInt(n.At(k).Attr("Tipo")) == 10)			// 8 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
          s.Cat((char)(y >> 16));
          s.Cat((char)(y >> 24));
          s.Cat((char)(y >> 32));
          s.Cat((char)(y >> 40));
          s.Cat((char)(y >> 48));
          s.Cat((char)(y >> 56));
        }
        r = Bus().PutData(vBusHandle, ln, (char)nodo.At(dev).addr, 'w', ScanInt(n.At(k).Attr("Indirizzo")), ScanInt(n.At(k).Attr("Lunghezza")), s);
        Statistics(r);
      }  
      else																										// variable
      {
        if(ScanInt(n.At(k).Attr("Tipo")) == 2)																	// String
        {
          s = String(ac.Get(j, 1)).Right(8);
        }	        
        else if(ScanInt(n.At(k).Attr("Tipo")) == 3 || ScanInt(n.At(k).Attr("Tipo")) == 5)				// 1 byte
        {
          s.Clear();
          s.Cat((char)((int)ac.Get(j, 1)));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 4 || ScanInt(n.At(k).Attr("Tipo")) == 6)				// 2 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 7 || ScanInt(n.At(k).Attr("Tipo")) == 8)				// 4 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
          s.Cat((char)(y >> 16));
          s.Cat((char)(y >> 24));
        }
        else if(ScanInt(n.At(k).Attr("Tipo")) == 9 || ScanInt(n.At(k).Attr("Tipo")) == 10)			// 8 byte
        {
          s.Clear();
          int64 y = ac.Get(j, 1);
          s.Cat((char)(y));
          s.Cat((char)(y >> 8));
          s.Cat((char)(y >> 16));
          s.Cat((char)(y >> 24));
          s.Cat((char)(y >> 32));
          s.Cat((char)(y >> 40));
          s.Cat((char)(y >> 48));
          s.Cat((char)(y >> 56));
        }
        r = Bus().PutData(vBusHandle, ln, (char)nodo.At(dev).addr, 'W', ScanInt(n.At(k).Attr("Indirizzo")), ScanInt(n.At(k).Attr("Lunghezza")), s);
        Statistics(r);
      }
    }
    k++;
  }
  cdOutBuff.At(dev).Cat(&ch[0], 8);
  r = Bus().PutData(vBusHandle, ln, (char)nodo.At(dev).addr, 'S', 0x0000, 8, cdOutBuff.At(dev));
  Statistics(r);

  return;  
}

void App::Statistics(int r)
{
  switch(r)
  {
    case BUS_SUCCESS:
    cs.success++;
    cs.contErrors = 0;
    break;
    
    case GET_ERROR:      
    cs.getErrors++;
    cs.contErrors++;
    break;

    case BUS_FAULT:      
    cs.busFaults++;
    cs.contErrors++;
    break;

    case ERR_CHKSUM:      
    cs.chkErrors++;
    cs.contErrors++;
    break;

    case ERR_DATA:      
    cs.datErrors++;
    cs.contErrors++;
    break;

    case ERR_TIMEOUT:      
    cs.tmtErrors++;
    cs.contErrors++;
    break;

    case ERR_PACK:      
    cs.pckErrors++;
    cs.contErrors++;
    break;

    case ERR_PACKTMT:      
    cs.pckTmtErrors++;
    cs.contErrors++;
    break;

    case PUT_ERROR:      
    cs.putErrors++;
    cs.contErrors++;
    break;

    default:      
    cs.othErrors++;
    cs.contErrors++;
    break;       
  }
  
  fLeftSide.gEiSuccess = cs.success;
  fLeftSide.gEiGetErrs = cs.getErrors; 
  fLeftSide.gEiDatErrs = cs.datErrors;
  fLeftSide.gEiBusFlts = cs.busFaults;
  fLeftSide.gEiTmtErrs = cs.tmtErrors;
  fLeftSide.gEiPckErrs = cs.pckErrors;
  fLeftSide.gEiPckTmts = cs.pckTmtErrors;
  fLeftSide.gEiPutErrs = cs.putErrors;
  fLeftSide.gEiChkErrs = cs.chkErrors;
  fLeftSide.gEiOthErrs = cs.othErrors;   
  
  //if(cs.contErrors >= 5) goOffline = true;
  
  return;
}
