#include "PierHB.h"

bool ScanBool(const String &s)
{
  if(s == "1" || s == "true" || s == "TRUE") return true;
  else return false;
}

String MyFormatBinInt64(int64 q, int s)
{
  String r;
  int j;
  static const char itob[] = "01";
    
  for(j = ((s * 8) - 1); j >= 0; j--)
  {
    r.Cat( itob[(q >> j) & 0x01]);
  }

	//while(r[0] == '0' && r.GetCount() > 1) r.Remove(0, 1);
  return r;
}

String MyFormatHexInt64(int64 q, int s)
{
  String r;
  int j;
  static const char itoh[] = "0123456789ABCDEF";
  
  for(j = ((s * 2) - 1); j >= 0; j--)
  {
    r.Cat( itoh[(q >> (j*4)) & 0x0f] );
  }
  
  //while(r[0] == '0' && r.GetCount() > 1) r.Remove(0, 1);
  
  return r;
}

bool MyDeleteFolderDeep(const char *dir, bool onlyEmpty)
{
  bool empty = true;
  
	{
		FindFile ff(AppendFileName(dir, "*.*"));
		while(ff) 
		{
			String name = ff.GetName();
			String p = AppendFileName(dir, name);
			if(ff.IsFile()) 
			{
        if(!onlyEmpty) FileDelete(p);
        else empty = false;
			}
			else
			{
			  if(ff.IsFolder()) MyDeleteFolderDeep(p, onlyEmpty);
			}
			ff.Next();
		}
	}
	if(empty) return DirectoryDelete(dir);
	else return false;
}

ConvertHexInt64::ConvertHexInt64(int64 minval, int64 maxval, bool notnull)
	: minval(minval), maxval(maxval), notnull(notnull) {}

ConvertHexInt64::~ConvertHexInt64() {}

Value ConvertHexInt64::Scan(const Value& text) const 
{
	Value v = UPP::ScanInt64((const char*)String(text), NULL, 16);
	if(IsError(v)) return v;
	if(IsNull(v)) return notnull ? NotNullError() : v;
	int64 m = v;
	
	// Calculate the size in byte
	uint64 u = maxval - minval;
	int s;
	if(u < 256) s = 1;
	else if(u < 65536) s = 2;
	else if(u < 16777216) s = 3;
	else if(u < 4294967296) s = 4;
	else s = 8;
	
	switch(s)
	{
	  case 1:
	    if(m > 0x7F) m = 0xFF - m;
			break;  

	  case 2:
	    if(m > 0x7FFF) m = 0xFFFF - m;
			break;  

	  case 3:
	    if(m > 0x7FFFFF) m = 0xFFFFFF - m;
			break;  

	  case 4:
	    if(m > 0x7FFFFFFF) m = 0xFFFFFFFF - m;
			break;  

	  case 8:
	  default:
			break;  
	}
	
	if(m >= minval && m <= maxval) return v;
	return ErrorValue(UPP::Format(t_("Number must be between %X and %X."), minval, maxval));
}

Value ConvertHexInt64::Format(const Value& q) const
{
	if(IsNull(q)) return Null;

	// Calculate the size in byte
	uint64 u = maxval - minval;
	int s;
	if(u < 256) s = 1;
	else if(u < 65536) s = 2;
	else if(u < 16777216) s = 3;
	else if(u < 4294967296) s = 4;
	else s = 8;
	
  return MyFormatHexInt64(q, s);
}

int ConvertHexInt64::Filter(int chr) const 
{
	if(chr >= '0' && chr <= '9') return chr;
	if(chr >= 'A' && chr <= 'F') return chr;
	if(chr >= 'a' && chr <= 'f') return chr - 32;
	return 0;
}

ConvertBinInt64::ConvertBinInt64(int64 minval, int64 maxval, bool notnull)
	: minval(minval), maxval(maxval), notnull(notnull) {}

ConvertBinInt64::~ConvertBinInt64() {}

Value ConvertBinInt64::Scan(const Value& text) const 
{
	Value v = UPP::ScanInt64((const char*)String(text), NULL, 2);
	if(IsError(v)) return v;
	if(IsNull(v)) return notnull ? NotNullError() : v;
	int64 m = v;
	
	// Calculate the size in byte
	uint64 u = maxval - minval;
	int s;
	if(u < 0x100) s = 1;
	else if(u < 0x10000) s = 2;
	else if(u < 0x1000000) s = 3;
	else if(u < 0x100000000) s = 4;
	else s = 8;
	
	switch(s)
	{
	  case 1:
	    if(m > 0x7F) m = 0xFF - m;
			break;  

	  case 2:
	    if(m > 0x7FFF) m = 0xFFFF - m;
			break;  

	  case 3:
	    if(m > 0x7FFFFF) m = 0xFFFFFF - m;
			break;  

	  case 4:
	    if(m > 0x7FFFFFFF) m = 0xFFFFFFFF - m;
			break;  

	  case 8:
	  default:
			break;  
	}
	
	if(m >= minval && m <= maxval) return v;	
	return ErrorValue(UPP::Format(t_("Number must be between %X and %X."), minval, maxval));
}

Value ConvertBinInt64::Format(const Value& q) const
{
	if(IsNull(q)) return Null;

	// Calculate the size in byte
	uint64 u = maxval - minval;
	int s;	
	if(u < 256) s = 1;
	else if(u < 65536) s = 2;
	else if(u < 16777216) s = 3;
	else if(u < 4294967296) s = 4;
	else s = 8;
	
  return MyFormatBinInt64(q, s);
}

int ConvertBinInt64::Filter(int chr) const 
{
	if(chr >= '0' && chr <= '1') return chr;
	return 0;
}
