/*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*
 X                                                                          X
 X                                XXXXXXXX                                  X
 X                             XXXXXXXXXXXXXX                               X
 X                            XXXXXXXXXXXXXXXX                              X
 X                            XXXXXXXXXXXXXXXX                              X
 X                            XX  XXXXXXXX  XX                              X
 X                             X    XXXX    X                               X
 X                            XXXXXXX  XXXXXXX                              X
 X                            XXXXXX    XXXXXX                              X
 X                              XXXXXXXXXXXX                                X
 X                                XX XX XX                                  X
 X                                XX XX XX                                  X
 X                                                                          X
 X                              CONFIDENTIAL                                X
 X                Copyright Pirate Neural Transmissions 2010                X
 X                          All rights reserved.                            X
 X                                                                          X
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*
 X                                                                          X
 X  NAME:    MacroCntA.h                                                    X
 X  DATE:    6, 2010                                                        X
 X  AUTHOR:  Mark Riphenburg                                                X
 X  PURPOSE:                                                                X
      a simple macro counter that is incremented by including this file.
      mCounterAVal is a 2 digit literal decimal integer value (0-99) 
      the digits are individually accessable as mCntADg0 and mCntADg1
      they are initialized to 0, 0 if not explicitly defined previously
 X  NOTES:                                                                  X
      example usage:
      
      #define mCntADg1 1
      #define mCntADg0 5
      #include "MacroCounterA.h"  
      int A0 = mCounterAVal;      // A0 = 15
      #include mCounterA          // increment includes can use mCounterA
      int A1 = mCounterAVal;      // A1 = 16
      
      -make additional counters (B, C, ...) by copying this file
  X                                                                          X
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*/
 
#ifndef mCounterA
#include "MacroCore.h"
#define mCounterA "MacroCntA.h"
#define mCounterAVal mGlueDg( mCntADg0, mCntADg1 )
#ifndef mCntADg0
  #define mCntADg0 0
  #define mCntADg1 0
#endif
#define mCntACarry0 0
#else

#undef  mCntACarry0
#define mCntACarry0 0

#if   (mCounterAVal+1)%10 == 0
  #undef mCntADg0 
  #define mCntADg0 0
  #undef mCntACarry0
  #define mCntACarry0 10
#elif (mCounterAVal+1)%10 == 1
  #undef mCntADg0
  #define mCntADg0 1
#elif (mCounterAVal+1)%10 == 2
  #undef mCntADg0
  #define mCntADg0 2
#elif (mCounterAVal+1)%10 == 3
  #undef mCntADg0
  #define mCntADg0 3
#elif (mCounterAVal+1)%10 == 4
  #undef mCntADg0
  #define mCntADg0 4
#elif (mCounterAVal+1)%10 == 5
  #undef mCntADg0
  #define mCntADg0 5
#elif (mCounterAVal+1)%10 == 6
  #undef mCntADg0
  #define mCntADg0 6
#elif (mCounterAVal+1)%10 == 7
  #undef mCntADg0
  #define mCntADg0 7
#elif (mCounterAVal+1)%10 == 8
  #undef mCntADg0
  #define mCntADg0 8
#else //(mCounterAVal+1)%10 == 9
  #undef mCntADg0
  #define mCntADg0 9
#endif

#if   (mCounterAVal+mCntACarry0)/10 == 0
  #undef mCntADg1
  #define mCntADg1 0
  #undef mCntACarry
  #define mCntACarry 0
#elif (mCounterAVal+mCntACarry0)/10 == 1
  #undef mCntADg1
  #define mCntADg1 1
#elif (mCounterAVal+mCntACarry0)/10 == 2
  #undef mCntADg1
  #define mCntADg1 2
#elif (mCounterAVal+mCntACarry0)/10 == 3
  #undef mCntADg1
  #define mCntADg1 3
#elif (mCounterAVal+mCntACarry0)/10 == 4
  #undef mCntADg1
  #define mCntADg1 4
#elif (mCounterAVal+mCntACarry0)/10 == 5
  #undef mCntADg1
  #define mCntADg1 5
#elif (mCounterAVal+mCntACarry0)/10 == 6
  #undef mCntADg1
  #define mCntADg1 6
#elif (mCounterAVal+mCntACarry0)/10 == 7
  #undef mCntADg1
  #define mCntADg1 7
#elif (mCounterAVal+mCntACarry0)/10 == 8
  #undef mCntADg1
  #define mCntADg1 8
#elif (mCounterAVal+mCntACarry0)/10 == 9
  #undef mCntADg1
  #define mCntADg1 9
#else
  #undef mCntADg0
  #define mCntADg0 0
  #undef mCntADg1
  #define mCntADg1 0
#endif

#endif
