/*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*
 X                                                                          X
 X                                XXXXXXXX                                  X
 X                             XXXXXXXXXXXXXX                               X
 X                            XXXXXXXXXXXXXXXX                              X
 X                            XXXXXXXXXXXXXXXX                              X
 X                            XX  XXXXXXXX  XX                              X
 X                             X    XXXX    X                               X
 X                            XXXXXXX  XXXXXXX                              X
 X                            XXXXXX    XXXXXX                              X
 X                              XXXXXXXXXXXX                                X
 X                                XX XX XX                                  X
 X                                XX XX XX                                  X
 X                                                                          X
 X                              CONFIDENTIAL                                X
 X                Copyright Pirate Neural Transmissions 2010                X
 X                          All rights reserved.                            X
 X                                                                          X
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*
 X                                                                          X
 X  NAME:    MacroCore.h                                                    X
 X  DATE:    6, 2010                                                        X
 X  AUTHOR:  Mark Riphenburg                                                X
 X  PURPOSE:                                                                X
 X  NOTES:                                                                  X
      convention: all elements that are paren enclosed remain paren
      enclosed until mListEmit.  if they do not, commas and parenthesis
      will resolve at an arbitrary nesting depth and reinterperet or corrupt
      the list.  non parenthized elements are often used to trigger behavior
      such as indexing or pasting
 X                                                                          X
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX*/
#ifndef MacroCore_h
#define MacroCore_h
/****************************************************************************/
/*  CONVENTIONS                                                             */
/****************************************************************************/


/****************************************************************************/
/*  DEFINITIONS                                                             */
/****************************************************************************/
#define __NIL__ __NIL___
#define __NIL___ __NIL____
#define __NIL____ __NIL_____
#define __NIL_____ __NIL______
#define __NIL______ __NIL_______
#define __NIL_______ __NIL________
#define __NIL________ /* */
/* comma and space are problematic for macros */
/* where paren enclosed seperators are specified */
/* _SPACE_ or _COMMA_ - notice no parens enclosing them */
#define _NIL_ _NIL_()
#define _SPACE_ _SPACE_()
#define _COMMA_ _COMMA_()
#define _LPARN_ _LPARN_()
#define _RPARN_ _RPARN_()

#define __COMMA__ ,
#define __SPACE__ __SPACE_0 \
 __SPACE_0
#define __SPACE_0 
#define __LPARN__() (
#define __RPARN__() )
#define __POUND__() #
#define __DQUOT__() '"'
//#define __QUOTE__ '
//const char * __QUOTE___ = "'";
//const char __QUOTE__ = __QUOTE___[0];

/* creates a text string expansion of its arguments and stores it in gDebugOut */
mDeclare(char * gDebugHistory[10] = {"start","","","","","","","","",""}; STR mDebugOut = *gDebugHistory; )
mNotDeclare( extern char ** gDebugHistory; extern char * mDebugOut; )
#define mDebugOut(...) {gDebugHistory[10] = gDebugHistory[9]; gDebugHistory[9] = gDebugHistory[8];\
                       gDebugHistory[8] = gDebugHistory[7]; gDebugHistory[7] = gDebugHistory[6];\
                       gDebugHistory[6] = gDebugHistory[5]; gDebugHistory[5] = gDebugHistory[4];\
                       gDebugHistory[4] = gDebugHistory[3]; gDebugHistory[3] = gDebugHistory[2];\
                       gDebugHistory[2] = gDebugHistory[1]; gDebugHistory[1] = gDebugHistory[0];\
                       gDebugHistory[0] = mDebugOut = mString(__VA_ARGS__); }
#define mDebugExp(...) { gDebugHistory[10] = mDebugOut = mString(__VA_ARGS__); gDebugHistory[9] = mString_(__VA_ARGS__);\
                         gDebugHistory[8] = mString_0(__VA_ARGS__); gDebugHistory[7] = mString_1(__VA_ARGS__);\
                         gDebugHistory[6] = mString_2(__VA_ARGS__); gDebugHistory[5] = mString_3(__VA_ARGS__);\
                         gDebugHistory[4] = mString_4(__VA_ARGS__); gDebugHistory[3] = mString_5(__VA_ARGS__);\
                         gDebugHistory[2] = mString_6(__VA_ARGS__); gDebugHistory[1] = mString_7(__VA_ARGS__);\
                         gDebugHistory[0] = mDebugOut = #__VA_ARGS__; }

/* create a string of the argument at various depths */
#define mString( ... ) mString_(__VA_ARGS__)
#define mString_( ... ) mString_0(__VA_ARGS__)
#define mString_0( ... ) mString_1(__VA_ARGS__)
#define mString_1( ... ) mString_2(__VA_ARGS__)
#define mString_2( ... ) mString_3(__VA_ARGS__)
#define mString_3( ... ) mString_4(__VA_ARGS__)
#define mString_4( ... ) mString_5(__VA_ARGS__)
#define mString_5( ... ) mString_6(__VA_ARGS__)
#define mString_6( ... ) mString_7(__VA_ARGS__)
#define mString_7( ... ) mString_8(__VA_ARGS__)
#define mString_8( ... ) mString_9(__VA_ARGS__)
#define mString_9( ... ) #__VA_ARGS__

/* concatenate 2 arguments */
#define mGlue( A, B ) A##B

/* adds or removes a paren set to the single arity item A */
#define mParen(Bool,A) mParen_(Bool,A)
#define mParen_(Bool,A) mParen__(Bool,A)
#define mParen__(Bool,A) mBoolIfElse(Bool,mParenDe___##A,(A))
#define mParenDe___(A) A

/* removes a paren on a single arity item */
#define mDParen(A) mDParen_(A)
#define mDParen_(A) mDParen_0(A)
#define mDParen_0(A) mDParen_1(A)
#define mDParen_1(A) mDParen_2##A
#define mDParen_2(...) __VA_ARGS__
#define mDParen_2_COMMA_() ,
#define mDParen_2_LPARN_() (
#define mDParen_2_RPARN_() )
#define mDParen_2_NIL_()
#define mDParen_2_SPACE_() __SPACE__ \
 __SPACE__
/* removes a paren on a single arity item (recursion indirection level 0) */
#define mDParen0(A) mDParen0_(A)
#define mDParen0_(A) mDParen0_0(A)
#define mDParen0_0(A) mDParen0_1(A)
#define mDParen0_1(A) mDParen0_2##A
#define mDParen0_2(...) __VA_ARGS__
#define mDParen0_2_COMMA_() ,
#define mDParen0_2_LPARN_() (
#define mDParen0_2_RPARN_() )
#define mDParen0_2_NIL_()
#define mDParen0_2_SPACE_() __SPACE__ \
 __SPACE__

/* return 1 if paren (Arg) or 0 if no paren Arg */
/* if multiple arguments are passed, only the first argument is tested */
#define mParenTest(Arg,...) mParenTestB( mParenTest0( mParenTest_ Arg ) )
#define mParenTest0(Arg,...) mParenTest1(Arg)
#define mParenTest1(Arg) mRe##Arg )
#define mParenTest_(Arg,...) mParenTest1_ Arg
#define mRemParenTest_ ( 0,
#define mRemParenTest1_ ( 1,
#define mParenTestB( Arg ) mParenTestB_(Arg)
#define mParenTestB_( Arg ) mParenTestB__(Arg)
#define mParenTestB__( Arg ) mParenTestB___##Arg
#define mParenTestB___( Paren, ... ) Paren

/* return 1 if paren (Arg) or 0 if no paren Arg */
/* the special symbols _SPACE_,_NIL_,_COMMA_,_LPARN_,_RPARN_ are treated as parens */
#define mPTest(Arg,...) mPTestB( mPTest0( mPTest_ mPTestD(Arg) ) )
#define mPTest0(Arg,...) mPTest1(Arg)
#define mPTest1(Arg,...) mPTest2(Arg)
#define mPTest2(Arg,...) mPTest3(Arg)
#define mPTest3(Arg) mRe##Arg )
#define mPTest_(Arg,...) mPTest1_ Arg
#define mRemPTest_ ( 0,
#define mRemPTest1_ ( 1,
#define mPTestB( Arg ) mPTestB_(Arg)
#define mPTestB_( Arg ) mPTestB__(Arg)
#define mPTestB__( Arg ) mPTestB___##Arg
#define mPTestB___( Paren, ... ) Paren

#define mPTestD(A) mPTestD_(A)
#define mPTestD_(A) mPTestD_0(A)
#define mPTestD_0(A) mPTestD_1(A)
#define mPTestD_1(A) mPTestD_2##A
#define mPTestD_2(...) (__VA_ARGS__)
#define mPTestD_2_COMMA_() (1)
#define mPTestD_2_LPARN_() (1)
#define mPTestD_2_RPARN_() (1)
#define mPTestD_2_NIL_()   (1) 
#define mPTestD_2_SPACE_() (1)


#define mExpFn( Fn, Args ) mExpFn_( (Fn, Args) )
#define mExpFn_( P ) mExpFn_0( P )
#define mExpFn_0( P ) mExpFn_1( P )
#define mExpFn_1( P ) mExpFn_2( P )
#define mExpFn_2( P ) mExpFn_3##P
#define mExpFn_3( Fn, Args ) Fn##Args

#define mExpFn0( Fn, Args ) mExpFn0_( (Fn, Args) )
#define mExpFn0_( P ) mExpFn0_0( P )
#define mExpFn0_0( P ) mExpFn0_1( P )
#define mExpFn0_1( P ) mExpFn0_2( P )
#define mExpFn0_2( P ) mExpFn0_3##P
#define mExpFn0_3( Fn, Args ) Fn##Args

#define mExpFn1( Fn, Args ) mExpFn1_( (Fn, Args) )
#define mExpFn1_( P ) mExpFn1_0( P )
#define mExpFn1_0( P ) mExpFn1_1( P )
#define mExpFn1_1( P ) mExpFn1_2( P )
#define mExpFn1_2( P ) mExpFn1_3##P
#define mExpFn1_3( Fn, Args ) Fn##Args

/* this expands __VA_ARGS__ and macros before invoking it */
#define mExpDo( ... ) mExpDo_( (__VA_ARGS__) )
#define mExpDo_( Do ) mExpDo__( Do )
#define mExpDo__( Do ) mExpDo___##Do
#define mExpDo___( ... ) __VA_ARGS__

/* direct recursion is avoided by using this version internally by macro lib Fns */
#define mExpDo0( ... ) mExpDo0_( (__VA_ARGS__) )
#define mExpDo0_( Do ) mExpDo0__( Do )
#define mExpDo0__( Do ) mExpDo0___##Do
#define mExpDo0___( ... ) __VA_ARGS__

/* direct recursion is avoided by using this version internally by macro lib Fns */
#define mExpDo1( ... ) mExpDo1_( (__VA_ARGS__) )
#define mExpDo1_( Do ) mExpDo1__( Do )
#define mExpDo1__( Do ) mExpDo1___##Do
#define mExpDo1___( ... ) __VA_ARGS__


/****************************************************************************/
/*  CONDITONAL MACROS                                                       */
/****************************************************************************/
#if 1
/* Bool must be [0|1] 1:emits Do 0:emits nothing */
#define mBoolIf( Bool, ... ) mBoolIf_( Bool) (__VA_ARGS__)
#define mBoolIf_( Bool ) mBoolIf__( Bool)
#define mBoolIf__( Bool ) mBoolIf___( Bool)
#define mBoolIf___( Bool ) mBoolIf____( Bool )
#define mBoolIf____( Bool ) mBoolIf_##Bool
#define mBoolIf_0( ... )
#define mBoolIf_1( ... ) __VA_ARGS__

//#define mBoolIf( Bool, ... ) mBoolIf_( Bool, (__VA_ARGS__) )
//#define mBoolIf_( Bool, Do ) mBoolIf__( Bool, Do )
//#define mBoolIf__( Bool, Do ) mBoolIf___( Bool, Do )
//#define mBoolIf___( Bool, Do ) mBoolIf____( Bool, Do )
//#define mBoolIf____( Bool, Do ) mBoolIf_##Bool##Do
//#define mBoolIf_0( ... )
//#define mBoolIf_1( ... ) __VA_ARGS__

/* Bool must be [0|1] 1:emits Do 0:emits nothing */
#define mBoolIf0( Bool, ... ) mBoolIf0_( Bool, (__VA_ARGS__) )
#define mBoolIf0_( Bool, Do ) mBoolIf0__( Bool, Do )
#define mBoolIf0__( Bool, Do ) mBoolIf0___( Bool, Do )
#define mBoolIf0___( Bool, Do ) mBoolIf0_##Bool##Do
#define mBoolIf0_0( ... )
#define mBoolIf0_1( ... ) __VA_ARGS__

/* Bool must be [0|1] 1:emits nothing 0:emits Do */
#define mBoolNIf( Bool, ... ) mBoolNIf_( Bool, (__VA_ARGS__) )
#define mBoolNIf_( Bool, Do ) mBoolNIf__( Bool, Do )
#define mBoolNIf__( Bool, Do ) mBoolNIf___( Bool, Do )
#define mBoolNIf___( Bool, Do ) mBoolNIf_##Bool##Do
#define mBoolNIf_0( ... ) __VA_ARGS__
#define mBoolNIf_1( ... ) 

/* Bool must be [0|1] 1:emits nothing 0:emits Do */
#define mBoolNIf0( Bool, ... ) mBoolNIf0_( Bool, (__VA_ARGS__) )
#define mBoolNIf0_( Bool, Do ) mBoolNIf0__( Bool, Do )
#define mBoolNIf0__( Bool, Do ) mBoolNIf0___( Bool, Do )
#define mBoolNIf0___( Bool, Do ) mBoolNIf0_##Bool##Do
#define mBoolNIf0_0( ... ) __VA_ARGS__
#define mBoolNIf0_1( ... ) 

/* Bool must be [0|1] 1:emits Do 0:emits Else */
#define mBoolIfElse( Bool, Do, .../*Else*/ ) mBoolIfElse_( Bool) (Do, __VA_ARGS__ )
#define mBoolIfElse_( Bool ) mBoolIfElse__( Bool)
#define mBoolIfElse__( Bool ) mBoolIfElse___( Bool )
#define mBoolIfElse___( Bool ) mBoolIfElse____( Bool )
#define mBoolIfElse____( Bool ) mBoolIfElse_##Bool
#define mBoolIfElse_0( Do, .../*Else*/ ) __VA_ARGS__
#define mBoolIfElse_1( Do, .../*Else*/ ) Do

//#define mBoolIfElse( Bool, Do, .../*Else*/ ) mBoolIfElse_( Bool, (Do), (__VA_ARGS__) )
//#define mBoolIfElse_( Bool, Do, Else ) mBoolIfElse__( Bool, Do, Else )
//#define mBoolIfElse__( Bool, Do, Else ) mBoolIfElse___( Bool, Do, Else )
//#define mBoolIfElse___( Bool, Do, Else ) mBoolIfElse____( Bool, Do, Else )
//#define mBoolIfElse____( Bool, Do, Else ) mBoolIfElse_##Bool( Do, Else )
//#define mBoolIfElse_0( Do, Else ) mBoolIfElse_0_##Else
//#define mBoolIfElse_0_( ... ) __VA_ARGS__
//#define mBoolIfElse_1( Do, Else ) mBoolIfElse_1_##Do
//#define mBoolIfElse_1_( ... ) __VA_ARGS__

/* Bool must be [0|1] 1:emits Do 0:emits Else */
#define mBoolIfElse0( Bool, Do, .../*Else*/ ) mBoolIfElse0_( Bool, (Do), (__VA_ARGS__) )
#define mBoolIfElse0_( Bool, Do, Else ) mBoolIfElse0__( Bool, Do, Else )
#define mBoolIfElse0__( Bool, Do, Else ) mBoolIfElse0___( Bool, Do, Else )
#define mBoolIfElse0___( Bool, Do, Else ) mBoolIfElse0_##Bool( Do, Else )
#define mBoolIfElse0_0( Do, Else ) mBoolIfElse0_0_##Else
#define mBoolIfElse0_0_( ... ) __VA_ARGS__
#define mBoolIfElse0_1( Do, Else ) mBoolIfElse0_1_##Do
#define mBoolIfElse0_1_( ... ) __VA_ARGS__

/* Bool must be [0|1] 1:emits Do 0:emits Else */
#define mBoolNIfElse( Bool, Do, ... ) mBoolIfElse0_( Bool, (__VA_ARGS__), (Do) )

/* Bool must be [0|1] if( !Bool ) emits 1, else emits 0 */
#define mBoolNot( Bool ) mBoolNot_( Bool )
#define mBoolNot_( Bool ) mBoolNot__( Bool )
#define mBoolNot__( Bool ) mBoolNot##Bool
#define mBoolNot0 1
#define mBoolNot1 0

/* BoolA, BoolB must be [0|1] if( BoolA ^ BoolB ) emits 1, else emits 0 */
#define mBoolEqual( BoolA, BoolB ) mBoolEqual_( BoolA, BoolB )
#define mBoolEqual_( BoolA, BoolB ) mBoolEqual__( BoolA, BoolB )
#define mBoolEqual__( BoolA, BoolB ) mBoolEqual##BoolA##BoolB
#define mBoolEqual00 1
#define mBoolEqual01 0
#define mBoolEqual10 0
#define mBoolEqual11 1

/* BoolA, BoolB must be [0|1] if( BoolA & BoolB ) emits 1, else emits 0 */
#define mBoolAnd( BoolA, BoolB ) mBoolAnd_( BoolA, BoolB )
#define mBoolAnd_( BoolA, BoolB ) mBoolAnd__( BoolA, BoolB )
#define mBoolAnd__( BoolA, BoolB ) mBoolAnd##BoolA##BoolB
#define mBoolAnd00 0
#define mBoolAnd01 0
#define mBoolAnd10 0
#define mBoolAnd11 1

/* BoolA, BoolB must be [0|1] if( BoolA | BoolB ) emits 1, else emits 0 */
#define mBoolOr( BoolA, BoolB ) mBoolOr_( BoolA, BoolB )
#define mBoolOr_( BoolA, BoolB ) mBoolOr__( BoolA, BoolB )
#define mBoolOr__( BoolA, BoolB ) mBoolOr##BoolA##BoolB
#define mBoolOr00 0
#define mBoolOr01 1
#define mBoolOr10 1
#define mBoolOr11 1

/* BoolA, BoolB must be [0|1] if( BoolA ^ BoolB ) emits 1, else emits 0 */
#define mBoolXOr( BoolA, BoolB ) mBoolXOr_( BoolA, BoolB )
#define mBoolXOr_( BoolA, BoolB ) mBoolXOr__( BoolA, BoolB )
#define mBoolXOr__( BoolA, BoolB ) mBoolXOr##BoolA##BoolB
#define mBoolXOr00 0
#define mBoolXOr01 1
#define mBoolXOr10 1
#define mBoolXOr11 0

#endif


/****************************************************************************/
/*  DECIMAL LITERAL DIGIT MANIPULATION                                      */
/****************************************************************************/
#if 1
/* glues 2 decimal digits together as a number and removes leading zeros */
/* D0 is ones, D1 is tens. D0 and D1 must be [0|1|2|3|4|5|6|7|8|9] */
#define mGlueDg( D0, D1 ) mBoolIfElse( mBoolInt(D1), mGlueDg_( D0, D1 ), D0 )
#define mGlueDg_( D0, D1 ) D1##D0

/* increment a single digit */
#define mIncDg( iDg ) mIncDg_( iDg ) 
#define mIncDg_( iDg ) mIncInt0_##iDg

/* Increments an Int00 literal Int00 must be [0-99] */
#define mIncInt0( Int00 ) mIncInt0_( mDigit(Int00,0), mDigit(Int00,1) )
#define mIncInt0_( D0, D1 ) mIncInt0__( D0, D1 )
#define mIncInt0__( D0, D1 ) mGlueDg( mIncInt0_##D0, mBoolIfElse( mBoolInt(mIncInt_0##D0), D1, mIncInt_0##D1 ) )
#define mIncInt0_0 1
#define mIncInt0_1 2
#define mIncInt0_2 3
#define mIncInt0_3 4
#define mIncInt0_4 5
#define mIncInt0_5 6
#define mIncInt0_6 7
#define mIncInt0_7 8
#define mIncInt0_8 9
#define mIncInt0_9 0


/* decrement a single digit */
#define mDecDg( iDg ) mDecDg_( iDg ) 
#define mDecDg_( iDg ) mDecInt0_##iDg

/* Decrements an Int00 literal Int00 must be [0-99] */
#define mDecInt0( Int00 ) mDecInt0_( mDigit(Int00,0), mDigit(Int00,1) )
#define mDecInt0_( D0, D1 ) mDecInt0__( D0, D1 )
#define mDecInt0__( D0, D1 ) mGlueDg( mDecInt0_##D0, mBoolIfElse( mBoolInt0(D0), D1, mDecInt0_##D1 ) )
#define mDecInt0_0 9
#define mDecInt0_1 0
#define mDecInt0_2 1
#define mDecInt0_3 2
#define mDecInt0_4 3
#define mDecInt0_5 4
#define mDecInt0_6 5
#define mDecInt0_7 6
#define mDecInt0_8 7
#define mDecInt0_9 8

/* convert a single digit to a bool */
#define mBoolDg( iDg ) mBoolDg_( iDg ) 
#define mBoolDg_( iDg ) mBoolInt##iDg

/* converts an Int00 into a bool [0|1] */
#define mBoolInt( Int00 ) mBoolInt_( mDigit(Int00,0), mDigit(Int00,1) )
#define mBoolInt_( D0, D1 ) mBoolInt__( D0, D1 ) 
#define mBoolInt__( D0, D1 ) mBoolOr( mBoolInt##D0, mBoolInt##D1 )
#define mBoolInt0 0
#define mBoolInt1 1
#define mBoolInt2 1
#define mBoolInt3 1
#define mBoolInt4 1
#define mBoolInt5 1
#define mBoolInt6 1
#define mBoolInt7 1
#define mBoolInt8 1
#define mBoolInt9 1
#endif


/****************************************************************************/
/*  DECIMAL DIGIT DECREMENT (a--)                                           */
/****************************************************************************/
#if 1
//#define mDecInt( Int00 ) mDecInt_( (Int00) )
//#define mDecInt_( PInt00 ) mDecInt_0(PInt00)
#define mDecInt( PInt00 ) mDecInt_##PInt00

#define mDecInt_0 99
#define mDecInt_1 0
#define mDecInt_2 1
#define mDecInt_3 2
#define mDecInt_4 3
#define mDecInt_5 4
#define mDecInt_6 5
#define mDecInt_7 6
#define mDecInt_8 7
#define mDecInt_9 8

#define mDecInt_00 99
#define mDecInt_01 0
#define mDecInt_02 1
#define mDecInt_03 2
#define mDecInt_04 3
#define mDecInt_05 4
#define mDecInt_06 5
#define mDecInt_07 6
#define mDecInt_08 7
#define mDecInt_09 8

#define mDecInt_10 9
#define mDecInt_11 10
#define mDecInt_12 11
#define mDecInt_13 12
#define mDecInt_14 13
#define mDecInt_15 14
#define mDecInt_16 15
#define mDecInt_17 16
#define mDecInt_18 17
#define mDecInt_19 18

#define mDecInt_20 19
#define mDecInt_21 20
#define mDecInt_22 21
#define mDecInt_23 22
#define mDecInt_24 23
#define mDecInt_25 24
#define mDecInt_26 25
#define mDecInt_27 26
#define mDecInt_28 27
#define mDecInt_29 28

#define mDecInt_30 29
#define mDecInt_31 30
#define mDecInt_32 31
#define mDecInt_33 32
#define mDecInt_34 33
#define mDecInt_35 34
#define mDecInt_36 35
#define mDecInt_37 36
#define mDecInt_38 37
#define mDecInt_39 38

#define mDecInt_40 39
#define mDecInt_41 40
#define mDecInt_42 41
#define mDecInt_43 42
#define mDecInt_44 43
#define mDecInt_45 44
#define mDecInt_46 45
#define mDecInt_47 46
#define mDecInt_48 47
#define mDecInt_49 48

#define mDecInt_50 49
#define mDecInt_51 50
#define mDecInt_52 51
#define mDecInt_53 52
#define mDecInt_54 53
#define mDecInt_55 54
#define mDecInt_56 55
#define mDecInt_57 56
#define mDecInt_58 57
#define mDecInt_59 58

#define mDecInt_60 59
#define mDecInt_61 60
#define mDecInt_62 61
#define mDecInt_63 62
#define mDecInt_64 63
#define mDecInt_65 64
#define mDecInt_66 65
#define mDecInt_67 66
#define mDecInt_68 67
#define mDecInt_69 68

#define mDecInt_70 69
#define mDecInt_71 70
#define mDecInt_72 71
#define mDecInt_73 72
#define mDecInt_74 73
#define mDecInt_75 74
#define mDecInt_76 75
#define mDecInt_77 76
#define mDecInt_78 77
#define mDecInt_79 78

#define mDecInt_80 79
#define mDecInt_81 80
#define mDecInt_82 81
#define mDecInt_83 82
#define mDecInt_84 83
#define mDecInt_85 84
#define mDecInt_86 85
#define mDecInt_87 86
#define mDecInt_88 87
#define mDecInt_89 88

#define mDecInt_90 89
#define mDecInt_91 90
#define mDecInt_92 91
#define mDecInt_93 92
#define mDecInt_94 93
#define mDecInt_95 94
#define mDecInt_96 95
#define mDecInt_97 96
#define mDecInt_98 97
#define mDecInt_99 98
#endif


/****************************************************************************/
/*  DECIMAL DIGIT INCREMENT (a++)                                           */
/****************************************************************************/
#if 1
#define mIncInt( Int00 ) mIncInt_##Int00

#define mIncInt_0 1
#define mIncInt_1 2
#define mIncInt_2 3
#define mIncInt_3 4
#define mIncInt_4 5
#define mIncInt_5 6
#define mIncInt_6 7
#define mIncInt_7 8
#define mIncInt_8 9
#define mIncInt_9 10

#define mIncInt_00 1
#define mIncInt_01 2
#define mIncInt_02 3
#define mIncInt_03 4
#define mIncInt_04 5
#define mIncInt_05 6
#define mIncInt_06 7
#define mIncInt_07 8
#define mIncInt_08 9
#define mIncInt_09 10

#define mIncInt_10 11
#define mIncInt_11 12
#define mIncInt_12 13
#define mIncInt_13 14
#define mIncInt_14 15
#define mIncInt_15 16
#define mIncInt_16 17
#define mIncInt_17 18
#define mIncInt_18 19
#define mIncInt_19 20

#define mIncInt_20 21
#define mIncInt_21 22
#define mIncInt_22 23
#define mIncInt_23 24
#define mIncInt_24 25
#define mIncInt_25 26
#define mIncInt_26 27
#define mIncInt_27 28
#define mIncInt_28 29
#define mIncInt_29 30

#define mIncInt_30 31
#define mIncInt_31 32
#define mIncInt_32 33
#define mIncInt_33 34
#define mIncInt_34 35
#define mIncInt_35 36
#define mIncInt_36 37
#define mIncInt_37 38
#define mIncInt_38 39
#define mIncInt_39 40

#define mIncInt_40 41
#define mIncInt_41 42
#define mIncInt_42 43
#define mIncInt_43 44
#define mIncInt_44 45
#define mIncInt_45 46
#define mIncInt_46 47
#define mIncInt_47 48
#define mIncInt_48 49
#define mIncInt_49 50

#define mIncInt_50 51
#define mIncInt_51 52
#define mIncInt_52 53
#define mIncInt_53 54
#define mIncInt_54 55
#define mIncInt_55 56
#define mIncInt_56 57
#define mIncInt_57 58
#define mIncInt_58 59
#define mIncInt_59 60

#define mIncInt_60 61
#define mIncInt_61 62
#define mIncInt_62 63
#define mIncInt_63 64
#define mIncInt_64 65
#define mIncInt_65 66
#define mIncInt_66 67
#define mIncInt_67 68
#define mIncInt_68 69
#define mIncInt_69 70

#define mIncInt_70 71
#define mIncInt_71 72
#define mIncInt_72 73
#define mIncInt_73 74
#define mIncInt_74 75
#define mIncInt_75 76
#define mIncInt_76 77
#define mIncInt_77 78
#define mIncInt_78 79
#define mIncInt_79 80

#define mIncInt_80 81
#define mIncInt_81 82
#define mIncInt_82 83
#define mIncInt_83 84
#define mIncInt_84 85
#define mIncInt_85 86
#define mIncInt_86 87
#define mIncInt_87 88
#define mIncInt_88 89
#define mIncInt_89 90

#define mIncInt_90 91
#define mIncInt_91 92
#define mIncInt_92 93
#define mIncInt_93 94
#define mIncInt_94 95
#define mIncInt_95 96
#define mIncInt_96 97
#define mIncInt_97 98
#define mIncInt_98 99
#define mIncInt_99 0
#endif


/****************************************************************************/
/*  DECIMAL DECOMPOSITION TO DIGITS                                         */
/****************************************************************************/
#if 1
/* these macros emit a digit if the index matches its position */
#define mDigitIdx00( D0 ) D0
#define mDigitIdx10( D0 )
#define mDigitIdx01( D0 )
#define mDigitIdx11( D0 ) D0

/* Int00 [0-99] is the number to decompose, Dn [0|1] 0=ones digit, 1=tens digit */
#define mDigit(Int00,Dn) mDigit_(Int00,Dn)
#define mDigit_(N,Dn) mDigit##N(Dn)
#define mDigit0(D) mDigitIdx1##D(0)mDigitIdx0##D(0)
#define mDigit1(D) mDigitIdx1##D(0)mDigitIdx0##D(1)
#define mDigit2(D) mDigitIdx1##D(0)mDigitIdx0##D(2)
#define mDigit3(D) mDigitIdx1##D(0)mDigitIdx0##D(3)
#define mDigit4(D) mDigitIdx1##D(0)mDigitIdx0##D(4)
#define mDigit5(D) mDigitIdx1##D(0)mDigitIdx0##D(5)
#define mDigit6(D) mDigitIdx1##D(0)mDigitIdx0##D(6)
#define mDigit7(D) mDigitIdx1##D(0)mDigitIdx0##D(7)
#define mDigit8(D) mDigitIdx1##D(0)mDigitIdx0##D(8)
#define mDigit9(D) mDigitIdx1##D(0)mDigitIdx0##D(9)
#define mDigit00(D) mDigitIdx1##D(0)mDigitIdx0##D(0)
#define mDigit01(D) mDigitIdx1##D(0)mDigitIdx0##D(1)
#define mDigit02(D) mDigitIdx1##D(0)mDigitIdx0##D(2)
#define mDigit03(D) mDigitIdx1##D(0)mDigitIdx0##D(3)
#define mDigit04(D) mDigitIdx1##D(0)mDigitIdx0##D(4)
#define mDigit05(D) mDigitIdx1##D(0)mDigitIdx0##D(5)
#define mDigit06(D) mDigitIdx1##D(0)mDigitIdx0##D(6)
#define mDigit07(D) mDigitIdx1##D(0)mDigitIdx0##D(7)
#define mDigit08(D) mDigitIdx1##D(0)mDigitIdx0##D(8)
#define mDigit09(D) mDigitIdx1##D(0)mDigitIdx0##D(9)
#define mDigit10(D) mDigitIdx1##D(1)mDigitIdx0##D(0)
#define mDigit11(D) mDigitIdx1##D(1)mDigitIdx0##D(1)
#define mDigit12(D) mDigitIdx1##D(1)mDigitIdx0##D(2)
#define mDigit13(D) mDigitIdx1##D(1)mDigitIdx0##D(3)
#define mDigit14(D) mDigitIdx1##D(1)mDigitIdx0##D(4)
#define mDigit15(D) mDigitIdx1##D(1)mDigitIdx0##D(5)
#define mDigit16(D) mDigitIdx1##D(1)mDigitIdx0##D(6)
#define mDigit17(D) mDigitIdx1##D(1)mDigitIdx0##D(7)
#define mDigit18(D) mDigitIdx1##D(1)mDigitIdx0##D(8)
#define mDigit19(D) mDigitIdx1##D(1)mDigitIdx0##D(9)
#define mDigit20(D) mDigitIdx1##D(2)mDigitIdx0##D(0)
#define mDigit21(D) mDigitIdx1##D(2)mDigitIdx0##D(1)
#define mDigit22(D) mDigitIdx1##D(2)mDigitIdx0##D(2)
#define mDigit23(D) mDigitIdx1##D(2)mDigitIdx0##D(3)
#define mDigit24(D) mDigitIdx1##D(2)mDigitIdx0##D(4)
#define mDigit25(D) mDigitIdx1##D(2)mDigitIdx0##D(5)
#define mDigit26(D) mDigitIdx1##D(2)mDigitIdx0##D(6)
#define mDigit27(D) mDigitIdx1##D(2)mDigitIdx0##D(7)
#define mDigit28(D) mDigitIdx1##D(2)mDigitIdx0##D(8)
#define mDigit29(D) mDigitIdx1##D(2)mDigitIdx0##D(9)
#define mDigit30(D) mDigitIdx1##D(3)mDigitIdx0##D(0)
#define mDigit31(D) mDigitIdx1##D(3)mDigitIdx0##D(1)
#define mDigit32(D) mDigitIdx1##D(3)mDigitIdx0##D(2)
#define mDigit33(D) mDigitIdx1##D(3)mDigitIdx0##D(3)
#define mDigit34(D) mDigitIdx1##D(3)mDigitIdx0##D(4)
#define mDigit35(D) mDigitIdx1##D(3)mDigitIdx0##D(5)
#define mDigit36(D) mDigitIdx1##D(3)mDigitIdx0##D(6)
#define mDigit37(D) mDigitIdx1##D(3)mDigitIdx0##D(7)
#define mDigit38(D) mDigitIdx1##D(3)mDigitIdx0##D(8)
#define mDigit39(D) mDigitIdx1##D(3)mDigitIdx0##D(9)
#define mDigit40(D) mDigitIdx1##D(4)mDigitIdx0##D(0)
#define mDigit41(D) mDigitIdx1##D(4)mDigitIdx0##D(1)
#define mDigit42(D) mDigitIdx1##D(4)mDigitIdx0##D(2)
#define mDigit43(D) mDigitIdx1##D(4)mDigitIdx0##D(3)
#define mDigit44(D) mDigitIdx1##D(4)mDigitIdx0##D(4)
#define mDigit45(D) mDigitIdx1##D(4)mDigitIdx0##D(5)
#define mDigit46(D) mDigitIdx1##D(4)mDigitIdx0##D(6)
#define mDigit47(D) mDigitIdx1##D(4)mDigitIdx0##D(7)
#define mDigit48(D) mDigitIdx1##D(4)mDigitIdx0##D(8)
#define mDigit49(D) mDigitIdx1##D(4)mDigitIdx0##D(9)
#define mDigit50(D) mDigitIdx1##D(5)mDigitIdx0##D(0)
#define mDigit51(D) mDigitIdx1##D(5)mDigitIdx0##D(1)
#define mDigit52(D) mDigitIdx1##D(5)mDigitIdx0##D(2)
#define mDigit53(D) mDigitIdx1##D(5)mDigitIdx0##D(3)
#define mDigit54(D) mDigitIdx1##D(5)mDigitIdx0##D(4)
#define mDigit55(D) mDigitIdx1##D(5)mDigitIdx0##D(5)
#define mDigit56(D) mDigitIdx1##D(5)mDigitIdx0##D(6)
#define mDigit57(D) mDigitIdx1##D(5)mDigitIdx0##D(7)
#define mDigit58(D) mDigitIdx1##D(5)mDigitIdx0##D(8)
#define mDigit59(D) mDigitIdx1##D(5)mDigitIdx0##D(9)
#define mDigit60(D) mDigitIdx1##D(6)mDigitIdx0##D(0)
#define mDigit61(D) mDigitIdx1##D(6)mDigitIdx0##D(1)
#define mDigit62(D) mDigitIdx1##D(6)mDigitIdx0##D(2)
#define mDigit63(D) mDigitIdx1##D(6)mDigitIdx0##D(3)
#define mDigit64(D) mDigitIdx1##D(6)mDigitIdx0##D(4)
#define mDigit65(D) mDigitIdx1##D(6)mDigitIdx0##D(5)
#define mDigit66(D) mDigitIdx1##D(6)mDigitIdx0##D(6)
#define mDigit67(D) mDigitIdx1##D(6)mDigitIdx0##D(7)
#define mDigit68(D) mDigitIdx1##D(6)mDigitIdx0##D(8)
#define mDigit69(D) mDigitIdx1##D(6)mDigitIdx0##D(9)
#define mDigit70(D) mDigitIdx1##D(7)mDigitIdx0##D(0)
#define mDigit71(D) mDigitIdx1##D(7)mDigitIdx0##D(1)
#define mDigit72(D) mDigitIdx1##D(7)mDigitIdx0##D(2)
#define mDigit73(D) mDigitIdx1##D(7)mDigitIdx0##D(3)
#define mDigit74(D) mDigitIdx1##D(7)mDigitIdx0##D(4)
#define mDigit75(D) mDigitIdx1##D(7)mDigitIdx0##D(5)
#define mDigit76(D) mDigitIdx1##D(7)mDigitIdx0##D(6)
#define mDigit77(D) mDigitIdx1##D(7)mDigitIdx0##D(7)
#define mDigit78(D) mDigitIdx1##D(7)mDigitIdx0##D(8)
#define mDigit79(D) mDigitIdx1##D(7)mDigitIdx0##D(9)
#define mDigit80(D) mDigitIdx1##D(8)mDigitIdx0##D(0)
#define mDigit81(D) mDigitIdx1##D(8)mDigitIdx0##D(1)
#define mDigit82(D) mDigitIdx1##D(8)mDigitIdx0##D(2)
#define mDigit83(D) mDigitIdx1##D(8)mDigitIdx0##D(3)
#define mDigit84(D) mDigitIdx1##D(8)mDigitIdx0##D(4)
#define mDigit85(D) mDigitIdx1##D(8)mDigitIdx0##D(5)
#define mDigit86(D) mDigitIdx1##D(8)mDigitIdx0##D(6)
#define mDigit87(D) mDigitIdx1##D(8)mDigitIdx0##D(7)
#define mDigit88(D) mDigitIdx1##D(8)mDigitIdx0##D(8)
#define mDigit89(D) mDigitIdx1##D(8)mDigitIdx0##D(9)
#define mDigit90(D) mDigitIdx1##D(9)mDigitIdx0##D(0)
#define mDigit91(D) mDigitIdx1##D(9)mDigitIdx0##D(1)
#define mDigit92(D) mDigitIdx1##D(9)mDigitIdx0##D(2)
#define mDigit93(D) mDigitIdx1##D(9)mDigitIdx0##D(3)
#define mDigit94(D) mDigitIdx1##D(9)mDigitIdx0##D(4)
#define mDigit95(D) mDigitIdx1##D(9)mDigitIdx0##D(5)
#define mDigit96(D) mDigitIdx1##D(9)mDigitIdx0##D(6)
#define mDigit97(D) mDigitIdx1##D(9)mDigitIdx0##D(7)
#define mDigit98(D) mDigitIdx1##D(9)mDigitIdx0##D(8)
#define mDigit99(D) mDigitIdx1##D(9)mDigitIdx0##D(9)

/* direct decomposition of Int00 into 2 comma seperated arguments */
/* the digits are in Hi, Lo order */
/* mSplitInt( 39 ) emits: 3,9 */

#define mSplitInt( Int00 ) mSplitInt##Int00
#define mSplitInt0  0,0
#define mSplitInt1  0,1
#define mSplitInt2  0,2
#define mSplitInt3  0,3
#define mSplitInt4  0,4
#define mSplitInt5  0,5
#define mSplitInt6  0,6
#define mSplitInt7  0,7
#define mSplitInt8  0,8
#define mSplitInt9  0,9
#define mSplitInt00  0,0
#define mSplitInt01  0,1
#define mSplitInt02  0,2
#define mSplitInt03  0,3
#define mSplitInt04  0,4
#define mSplitInt05  0,5
#define mSplitInt06  0,6
#define mSplitInt07  0,7
#define mSplitInt08  0,8
#define mSplitInt09  0,9
#define mSplitInt10  1,0
#define mSplitInt11  1,1
#define mSplitInt12  1,2
#define mSplitInt13  1,3
#define mSplitInt14  1,4
#define mSplitInt15  1,5
#define mSplitInt16  1,6
#define mSplitInt17  1,7
#define mSplitInt18  1,8
#define mSplitInt19  1,9
#define mSplitInt20  2,0
#define mSplitInt21  2,1
#define mSplitInt22  2,2
#define mSplitInt23  2,3
#define mSplitInt24  2,4
#define mSplitInt25  2,5
#define mSplitInt26  2,6
#define mSplitInt27  2,7
#define mSplitInt28  2,8
#define mSplitInt29  2,9
#define mSplitInt30  3,0
#define mSplitInt31  3,1
#define mSplitInt32  3,2
#define mSplitInt33  3,3
#define mSplitInt34  3,4
#define mSplitInt35  3,5
#define mSplitInt36  3,6
#define mSplitInt37  3,7
#define mSplitInt38  3,8
#define mSplitInt39  3,9
#define mSplitInt40  4,0
#define mSplitInt41  4,1
#define mSplitInt42  4,2
#define mSplitInt43  4,3
#define mSplitInt44  4,4
#define mSplitInt45  4,5
#define mSplitInt46  4,6
#define mSplitInt47  4,7
#define mSplitInt48  4,8
#define mSplitInt49  4,9
#define mSplitInt50  5,0
#define mSplitInt51  5,1
#define mSplitInt52  5,2
#define mSplitInt53  5,3
#define mSplitInt54  5,4
#define mSplitInt55  5,5
#define mSplitInt56  5,6
#define mSplitInt57  5,7
#define mSplitInt58  5,8
#define mSplitInt59  5,9
#define mSplitInt60  6,0
#define mSplitInt61  6,1
#define mSplitInt62  6,2
#define mSplitInt63  6,3
#define mSplitInt64  6,4
#define mSplitInt65  6,5
#define mSplitInt66  6,6
#define mSplitInt67  6,7
#define mSplitInt68  6,8
#define mSplitInt69  6,9
#define mSplitInt70  7,0
#define mSplitInt71  7,1
#define mSplitInt72  7,2
#define mSplitInt73  7,3
#define mSplitInt74  7,4
#define mSplitInt75  7,5
#define mSplitInt76  7,6
#define mSplitInt77  7,7
#define mSplitInt78  7,8
#define mSplitInt79  7,9
#define mSplitInt80  8,0
#define mSplitInt81  8,1
#define mSplitInt82  8,2
#define mSplitInt83  8,3
#define mSplitInt84  8,4
#define mSplitInt85  8,5
#define mSplitInt86  8,6
#define mSplitInt87  8,7
#define mSplitInt88  8,8
#define mSplitInt89  8,9
#define mSplitInt90  9,0
#define mSplitInt91  9,1
#define mSplitInt92  9,2
#define mSplitInt93  9,3
#define mSplitInt94  9,4
#define mSplitInt95  9,5
#define mSplitInt96  9,6
#define mSplitInt97  9,7
#define mSplitInt98  9,8
#define mSplitInt99  9,9
#endif

/****************************************************************************/
/*  DECIMAL DIGIT COMPARE (00) (a-b)                                        */
/****************************************************************************/
#if 1
#define mLessDg( DgA, DgB ) mLessDg_( DgA,DgB )
#define mLessDg_( DgA, DgB ) mLessDg_0( (mSubDg##DgA##DgB) )
#define mLessDg_0( Ex ) mLessDg_1(Ex)
#define mLessDg_1( Ex ) mLessDg_2##Ex
#define mLessDg_2( Carry, Dif ) Carry
#define mLessEqDg( DgA, DgB ) mLessEqDg_( DgA,DgB )
#define mLessEqDg_( DgA, DgB ) mLessEqDg_0( (mSubDg##DgA##DgB) )
#define mLessEqDg_0( Ex ) mLessEqDg_1(Ex)
#define mLessEqDg_1( Ex ) mLessEqDg_2##Ex
#define mLessEqDg_2( Carry, Dif ) mBoolOr( Carry, mBoolNot( mBoolInt##Dif ) )
#define mMoreDg( DgA, DgB ) mMoreDg_( DgA,DgB )
#define mMoreDg_( DgA, DgB ) mMoreDg_0( (mSubDg##DgA##DgB) )
#define mMoreDg_0( Ex ) mMoreDg_1(Ex)
#define mMoreDg_1( Ex ) mMoreDg_2##Ex
#define mMoreDg_2( Carry, Dif ) mBoolAnd( mBoolNot( Carry ), mBoolInt##Dif )
#define mMoreEqDg( DgA, DgB ) mMoreEqDg_( DgA,DgB )
#define mMoreEqDg_( DgA, DgB ) mMoreEqDg_0( (mSubDg##DgA##DgB) )
#define mMoreEqDg_0( Ex ) mMoreEqDg_1(Ex)
#define mMoreEqDg_1( Ex ) mMoreEqDg_2##Ex
#define mMoreEqDg_2( Carry, Dif ) mBoolNot( Carry )
#define mEqualDg( DgA, DgB ) mEqualDg_( DgA,DgB )
#define mEqualDg_( DgA, DgB ) mEqualDg_0( (mSubDg##DgA##DgB) )
#define mEqualDg_0( Ex ) mEqualDg_1(Ex)
#define mEqualDg_1( Ex ) mEqualDg_2##Ex
#define mEqualDg_2( Carry, Dif ) mBoolNot( mBoolOr( Carry, mBoolInt##Dif ) )
#define mNEqualDg( DgA, DgB ) mNEqualDg_( DgA,DgB )
#define mNEqualDg_( DgA, DgB ) mNEqualDg_0( (mSubDg##DgA##DgB) )
#define mNEqualDg_0( Ex ) mNEqualDg_1(Ex)
#define mNEqualDg_1( Ex ) mNEqualDg_2##Ex
#define mNEqualDg_2( Carry, Dif ) mBoolOr( Carry, mBoolInt##Dif )
/* Int00 comparison operators */
#define mLessInt( Int00A, Int00B ) mLessInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mLessInt_( A0, A1, B0, B1 ) mBoolIfElse0( mNEqualDg( A1, B1 ), mLessDg(A1,B1), mLessDg(A0,B0) )
#define mLessEqInt( Int00A, Int00B ) mLessEqInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mLessEqInt_( A0, A1, B0, B1 ) mBoolIfElse0( mNEqualDg( A1, B1 ), mLessEqDg(A1,B1), mLessEqDg(A0,B0) )
#define mMoreInt( Int00A, Int00B ) mMoreInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mMoreInt_( A0, A1, B0, B1 ) mBoolIfElse0( mNEqualDg( A1, B1 ), mMoreDg(A1,B1), mMoreDg(A0,B0) )
#define mMoreEqInt( Int00A, Int00B ) mMoreEqInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mMoreEqInt_( A0, A1, B0, B1 ) mBoolIfElse0( mNEqualDg( A1, B1 ), mMoreEqDg(A1,B1), mMoreEqDg(A0,B0) )
#define mEqualInt( Int00A, Int00B ) mEqualInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mEqualInt_( A0, A1, B0, B1 ) mBoolAnd( mEqualDg( A1, B1 ), mEqualDg( A0, B0 ) )
#define mNEqualInt( Int00A, Int00B ) mNEqualInt_( mDigit(Int00A,0), mDigit(Int00A,1), mDigit(Int00B,0), mDigit(Int00B,1) )
#define mNEqualInt_( A0, A1, B0, B1 ) mBoolNot( mBoolAnd( mEqualDg( A1, B1 ), mEqualDg( A0, B0 ) ) )
#endif


/****************************************************************************/
/*  DECIMAL DIGIT SUBTRACTION (a-b)                                         */
/****************************************************************************/
#if 1
#define mSubDg( DgA, DgB ) mSubDg##DgA##DgB

#define mSubDg00 0,0
#define mSubDg01 1,9
#define mSubDg02 1,8
#define mSubDg03 1,7
#define mSubDg04 1,6
#define mSubDg05 1,5
#define mSubDg06 1,4
#define mSubDg07 1,3
#define mSubDg08 1,2
#define mSubDg09 1,1

#define mSubDg10 0,1
#define mSubDg11 0,0
#define mSubDg12 1,9
#define mSubDg13 1,8
#define mSubDg14 1,7
#define mSubDg15 1,6
#define mSubDg16 1,5
#define mSubDg17 1,4
#define mSubDg18 1,3
#define mSubDg19 1,2

#define mSubDg20 0,2
#define mSubDg21 0,1
#define mSubDg22 0,0
#define mSubDg23 1,9
#define mSubDg24 1,8
#define mSubDg25 1,7
#define mSubDg26 1,6
#define mSubDg27 1,5
#define mSubDg28 1,4
#define mSubDg29 1,3

#define mSubDg30 0,3
#define mSubDg31 0,2
#define mSubDg32 0,1
#define mSubDg33 0,0
#define mSubDg34 1,9
#define mSubDg35 1,8
#define mSubDg36 1,7
#define mSubDg37 1,6
#define mSubDg38 1,5
#define mSubDg39 1,4

#define mSubDg40 0,4
#define mSubDg41 0,3
#define mSubDg42 0,2
#define mSubDg43 0,1
#define mSubDg44 0,0
#define mSubDg45 1,9
#define mSubDg46 1,8
#define mSubDg47 1,7
#define mSubDg48 1,6
#define mSubDg49 1,5

#define mSubDg50 0,5
#define mSubDg51 0,4
#define mSubDg52 0,3
#define mSubDg53 0,2
#define mSubDg54 0,1
#define mSubDg55 0,0
#define mSubDg56 1,9
#define mSubDg57 1,8
#define mSubDg58 1,7
#define mSubDg59 1,6

#define mSubDg60 0,6
#define mSubDg61 0,5
#define mSubDg62 0,4
#define mSubDg63 0,3
#define mSubDg64 0,2
#define mSubDg65 0,1
#define mSubDg66 0,0
#define mSubDg67 1,9
#define mSubDg68 1,8
#define mSubDg69 1,7

#define mSubDg70 0,7
#define mSubDg71 0,6
#define mSubDg72 0,5
#define mSubDg73 0,4
#define mSubDg74 0,3
#define mSubDg75 0,2
#define mSubDg76 0,1
#define mSubDg77 0,0
#define mSubDg78 1,9
#define mSubDg79 1,8

#define mSubDg80 0,8
#define mSubDg81 0,7
#define mSubDg82 0,6
#define mSubDg83 0,5
#define mSubDg84 0,4
#define mSubDg85 0,3
#define mSubDg86 0,2
#define mSubDg87 0,1
#define mSubDg88 0,0
#define mSubDg89 1,9

#define mSubDg90 0,9
#define mSubDg91 0,8
#define mSubDg92 0,7
#define mSubDg93 0,6
#define mSubDg94 0,5
#define mSubDg95 0,4
#define mSubDg96 0,3
#define mSubDg97 0,2
#define mSubDg98 0,1
#define mSubDg99 0,0
#endif


/****************************************************************************/
/*  DECIMAL INT00 SUBTRACTION (a-b)                                         */
/****************************************************************************/
#define mSubInt( A, B ) mSubInt_( (A, B) )
#define mSubInt_( P ) mSubInt_0##P
#define mSubInt_0( A, B ) mSubInt_1( (mSplitInt(A), mSplitInt(B)))
#define mSubInt_1( P ) mSubInt_2(P)
#define mSubInt_2( P ) mSubInt_3##P
#define mSubInt_3( A1,A0,B1,B0 ) mSubInt_4((mSubDg(A1,B1),mSubDg(A0,B0)))
#define mSubInt_4( P ) mSubInt_5(P)
#define mSubInt_5( P ) mSubInt_6##P
#define mSubInt_6( C1,D1,C0,D0 ) mGlueDg(D0,mBoolIfElse(C0,mDecDg(D1),D1))


/****************************************************************************/
/*  DECIMAL DIGIT ADDITION (a+b)                                            */
/****************************************************************************/
#if 1
#define mAddDg( DgA, DgB ) mAddDg##DgA##DgB
#define mAddDg00 0,0
#define mAddDg01 0,1
#define mAddDg02 0,2
#define mAddDg03 0,3
#define mAddDg04 0,4
#define mAddDg05 0,5
#define mAddDg06 0,6
#define mAddDg07 0,7
#define mAddDg08 0,8
#define mAddDg09 0,9

#define mAddDg10 0,1
#define mAddDg11 0,2
#define mAddDg12 0,3
#define mAddDg13 0,4
#define mAddDg14 0,5
#define mAddDg15 0,6
#define mAddDg16 0,7
#define mAddDg17 0,8
#define mAddDg18 0,9
#define mAddDg19 1,0

#define mAddDg20 0,2
#define mAddDg21 0,3
#define mAddDg22 0,4
#define mAddDg23 0,5
#define mAddDg24 0,6
#define mAddDg25 0,7
#define mAddDg26 0,8
#define mAddDg27 0,9
#define mAddDg28 1,0
#define mAddDg29 1,1

#define mAddDg30 0,3
#define mAddDg31 0,4
#define mAddDg32 0,5
#define mAddDg33 0,6
#define mAddDg34 0,7
#define mAddDg35 0,8
#define mAddDg36 0,9
#define mAddDg37 1,0
#define mAddDg38 1,1
#define mAddDg39 1,2

#define mAddDg40 0,4
#define mAddDg41 0,5
#define mAddDg42 0,6
#define mAddDg43 0,7
#define mAddDg44 0,8
#define mAddDg45 0,9
#define mAddDg46 1,0
#define mAddDg47 1,1
#define mAddDg48 1,2
#define mAddDg49 1,3

#define mAddDg50 0,5
#define mAddDg51 0,6
#define mAddDg52 0,7
#define mAddDg53 0,8
#define mAddDg54 0,9
#define mAddDg55 1,0
#define mAddDg56 1,1
#define mAddDg57 1,2
#define mAddDg58 1,3
#define mAddDg59 1,4

#define mAddDg60 0,6
#define mAddDg61 0,7
#define mAddDg62 0,8
#define mAddDg63 0,9
#define mAddDg64 1,0
#define mAddDg65 1,1
#define mAddDg66 1,2
#define mAddDg67 1,3
#define mAddDg68 1,4
#define mAddDg69 1,5

#define mAddDg70 0,7
#define mAddDg71 0,8
#define mAddDg72 0,9
#define mAddDg73 1,0
#define mAddDg74 1,1
#define mAddDg75 1,2
#define mAddDg76 1,3
#define mAddDg77 1,4
#define mAddDg78 1,5
#define mAddDg79 1,6

#define mAddDg80 0,8
#define mAddDg81 0,9
#define mAddDg82 1,0
#define mAddDg83 1,1
#define mAddDg84 1,2
#define mAddDg85 1,3
#define mAddDg86 1,4
#define mAddDg87 1,5
#define mAddDg88 1,6
#define mAddDg89 1,7

#define mAddDg90 0,9
#define mAddDg91 1,0
#define mAddDg92 1,1
#define mAddDg93 1,2
#define mAddDg94 1,3
#define mAddDg95 1,4
#define mAddDg96 1,5
#define mAddDg97 1,6
#define mAddDg98 1,7
#define mAddDg99 1,8

#endif


/****************************************************************************/
/*  DECIMAL INT00 ADDITION (a+b)                                            */
/****************************************************************************/
#define mAddInt( A, B ) mAddInt_( (mSplitInt(A), mSplitInt(B)))
#define mAddInt_( P ) mAddInt_1(P)
#define mAddInt_1( P ) mAddInt_2##P
#define mAddInt_2( A1,A0,B1,B0 ) mAddInt_3((mAddDg(A1,B1),mAddDg(A0,B0)))
#define mAddInt_3( P ) mAddInt_4(P)
#define mAddInt_4( P ) mAddInt_5##P
#define mAddInt_5( C1,D1,C0,D0 ) mGlueDg(D0,mBoolIfElse(C0,mIncDg(D1),D1))


/****************************************************************************/
/*  DECIMAL DIGIT MULTIPLICATION (a*b) - yields an INT00                    */
/****************************************************************************/
#if 1
#define mMulDg( DgA, DgB ) mMulDg_((DgA,DgB))
#define mMulDg_( PL ) mMulDg_0##PL
#define mMulDg_0( DgA, DgB ) mMulDg##DgA##DgB

#define mMulDg00 0
#define mMulDg01 0
#define mMulDg02 0
#define mMulDg03 0
#define mMulDg04 0
#define mMulDg05 0
#define mMulDg06 0
#define mMulDg07 0
#define mMulDg08 0
#define mMulDg09 0

#define mMulDg10 0
#define mMulDg11 1
#define mMulDg12 2
#define mMulDg13 3
#define mMulDg14 4
#define mMulDg15 5
#define mMulDg16 6
#define mMulDg17 7
#define mMulDg18 8
#define mMulDg19 9

#define mMulDg20 0
#define mMulDg21 2
#define mMulDg22 4
#define mMulDg23 6
#define mMulDg24 8
#define mMulDg25 10
#define mMulDg26 12
#define mMulDg27 14
#define mMulDg28 16
#define mMulDg29 18

#define mMulDg30 0
#define mMulDg31 3
#define mMulDg32 6
#define mMulDg33 9
#define mMulDg34 12
#define mMulDg35 15
#define mMulDg36 18
#define mMulDg37 21
#define mMulDg38 24
#define mMulDg39 27

#define mMulDg40 0
#define mMulDg41 4
#define mMulDg42 8
#define mMulDg43 12
#define mMulDg44 16
#define mMulDg45 20
#define mMulDg46 24
#define mMulDg47 28
#define mMulDg48 32
#define mMulDg49 36

#define mMulDg50 0
#define mMulDg51 5
#define mMulDg52 10
#define mMulDg53 15
#define mMulDg54 20
#define mMulDg55 25
#define mMulDg56 30
#define mMulDg57 35
#define mMulDg58 40
#define mMulDg59 45

#define mMulDg60 0
#define mMulDg61 6
#define mMulDg62 12
#define mMulDg63 18
#define mMulDg64 24
#define mMulDg65 30
#define mMulDg66 36
#define mMulDg67 42
#define mMulDg68 48
#define mMulDg69 54

#define mMulDg70 0
#define mMulDg71 7
#define mMulDg72 14
#define mMulDg73 21
#define mMulDg74 28
#define mMulDg75 35
#define mMulDg76 42
#define mMulDg77 49
#define mMulDg78 56
#define mMulDg79 63

#define mMulDg80 0
#define mMulDg81 8
#define mMulDg82 16
#define mMulDg83 24
#define mMulDg84 32
#define mMulDg85 40
#define mMulDg86 48
#define mMulDg87 56
#define mMulDg88 64
#define mMulDg89 72

#define mMulDg90 0
#define mMulDg91 9
#define mMulDg92 19
#define mMulDg93 27
#define mMulDg94 36
#define mMulDg95 45
#define mMulDg96 54
#define mMulDg97 63
#define mMulDg98 72
#define mMulDg99 81
#endif


/****************************************************************************/
/*  REPETITION MACROS                                                       */
/****************************************************************************/
#if 1
/* repeat the token [Rpt] for [Cnt] iterations */
/*  EX: mRepeat( 4, XY ) emits XYXYXYXY */
#define mRepeat( Cnt, Rpt ) mRepeat_( (Cnt, Rpt) )
#define mRepeat_( P ) mRepeat_0(P)
#define mRepeat_0( P ) mRepeat_1(P)
#define mRepeat_1( P ) mRepeat_2(P)
#define mRepeat_2( P ) mRepeat_3##P
#define mRepeat_3( Cnt, Rpt ) mRep##Cnt( 0, Rpt, mRepNull, mRepNoFn )

/* repeat a token Cnt times to creat a comma seperated list */
#define mRepeatList( Cnt, Rpt ) mRepeatList_( (mDecInt(Cnt), Rpt) )
#define mRepeatList_( P ) mRepeatList_0(P)
#define mRepeatList_0( P ) mRepeatList_1(P)
#define mRepeatList_1( P ) mRepeatList_2(P)
#define mRepeatList_2( P ) mRepeatList_3##P
#define mRepeatList_3( Cnt, Rpt ) mExpDo0(Rpt)mRep##Cnt( 0, Rpt, mRepNull, mRepNoFnComma )

/* this performs a nested loop and executes mRepFn while passing it additional arguments */
/* the name of mRepFn must be begin with an m and be specified in the mDblLoop call without it */
/* mRepFn must be in the form m##Name( InnerCnt, OuterCnt, [Aux0,...] ) */
/* Ex: #define mMyRpt( InC, OutC, Ax0, Ax1 ) Ax1[InC,OutC]
/* Ex: mDblLoop( 10,3,0,2, mMyRpt, Some,List ) */
/* emits: List[0,10] List[1,10] List[0,11] List[1,11] List[0,12] List[1,12] */
#define mDblLoop(S0,R0,S1,R1,RepFn, ... ) mRepeatFnS_VA(S0,R0, mDblLoop_, RepFn, S1, R1, __VA_ARGS__)
#define mDblLoop_(...) mDblLoop_0((__VA_ARGS__))
#define mDblLoop_0(PL) mDblLoop_1##PL
#define mDblLoop_1( I0, RepFn, S1, R1, ... ) mRepeatFnS_VA0( S1, R1, RepFn, I0, __VA_ARGS__ )

/* repeat the macro[Rpt](Start) for [Cnt] iterations */
/* Start is incremented each iteration and passed as a parameter to Rpt */
/*  EX: #define mRepeater(Itr) S32 Var##Itr = Itr + 1;
/*      mRepeatFnS( 3, mRepeater, 10 ) */
/*      emits: S32 Var10 = 10 + 1; S32 Var11 = 11 + 1; S32 Var12 = 12 + 1; */ 
#define mRepeatFnS_VA( Start, Cnt, RepFn, ... ) mRep##Cnt( Start, (RepFn,__VA_ARGS__), mRepFnVA, mRepNull )
#define mRepeatFnS( Start, Cnt, Rpt ) mRep##Cnt( Start, Rpt, mRepFn, mRepNull )
/* repeat macro function with a 0 starting value */
#define mRepeatFn( Cnt, Rpt ) mRep##Cnt( 0, Rpt, mRepFn, mRepNull )
/* internally used standard repetition patterns */
#define mRepFnVA(Itr, RepFn) mRepFnVA_( (Itr, mDParen(RepFn)) )
#define mRepFnVA_(PL) mExpFn( mRepFnVA_0, PL )
#define mRepFnVA_0( Itr, RepFn, ... ) RepFn( Itr, __VA_ARGS__ )
#define mRepFn(Itr, Rpt) Rpt(Itr)
#define mRepNoFn(Itr, Rpt) Rpt
#define mRepNoFnComma(Itr, Rpt) ,Rpt
#define mRepNull(Itr, Rpt )

/* repetitions enter at the mRepN [N=Cnt] */
/* depth folding this is prohibited, but breadth folding may be allowed */
#define mRep0( Itr, Rpt, _PreFn, _Fn )
#define mRep1( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep0( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep2( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep1( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep3( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep2( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep4( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep3( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep5( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep4( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep6( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep5( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep7( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep6( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep8( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep7( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep9( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep8( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep10( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep9( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep11( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep10( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep12( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep11( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep13( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep12( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep14( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep13( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep15( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep14( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep16( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep15( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep17( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep16( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep18( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep17( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep19( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep18( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep20( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep19( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep21( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep20( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep22( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep21( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep23( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep22( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep24( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep23( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep25( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep24( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep26( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep25( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep27( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep26( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep28( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep27( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep29( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep28( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep30( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep29( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep31( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep30( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep32( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep31( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep33( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep32( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep34( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep33( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep35( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep34( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep36( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep35( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep37( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep36( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep38( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep37( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep39( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep38( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep40( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep39( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep41( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep40( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep42( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep41( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep43( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep42( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep44( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep43( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep45( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep44( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep46( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep45( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep47( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep46( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep48( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep47( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep49( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep48( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep50( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep49( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep51( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep50( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep52( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep51( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep53( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep52( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep54( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep53( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep55( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep54( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep56( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep55( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep57( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep56( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep58( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep57( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep59( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep58( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep60( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep59( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep61( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep60( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep62( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep61( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep63( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep62( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep64( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep63( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep65( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep64( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep66( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep65( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep67( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep66( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep68( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep67( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep69( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep68( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep70( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep69( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep71( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep70( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep72( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep71( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep73( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep72( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep74( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep73( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep75( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep74( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep76( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep75( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep77( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep76( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep78( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep77( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep79( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep78( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep80( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep79( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep81( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep80( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep82( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep81( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep83( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep82( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep84( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep83( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep85( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep84( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep86( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep85( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep87( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep86( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep88( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep87( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep89( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep88( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep90( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep89( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep91( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep90( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep92( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep91( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep93( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep92( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep94( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep93( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep95( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep94( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep96( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep95( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep97( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep96( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep98( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep97( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep99( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep98( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep100( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep99( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#endif

/* auxilary recursion layer 0 repeat - limited to 30 reps */ 
#if 1
/*  EX: mRepeat( 4, XY ) emits XYXYXYXY */
#define mRepeat0( Cnt, Rpt ) mRepeat0_( (Cnt, Rpt) )
#define mRepeat0_( P ) mRepeat0_0(P)
#define mRepeat0_0( P ) mRepeat0_1(P)
#define mRepeat0_1( P ) mRepeat0_2(P)
#define mRepeat0_2( P ) mRepeat0_3##P
#define mRepeat0_3( Cnt, Rpt ) mRep0##Cnt( 0, Rpt, mRepNull, mRepNoFn )

/* repeat a token Cnt times to creat a comma seperated list */
#define mRepeatList0( Cnt, Rpt ) mRepeatList0_( (mDecInt(Cnt), Rpt) )
#define mRepeatList0_( P ) mRepeatList0_0(P)
#define mRepeatList0_0( P ) mRepeatList0_1(P)
#define mRepeatList0_1( P ) mRepeatList0_2(P)
#define mRepeatList0_2( P ) mRepeatList0_3##P
#define mRepeatList0_3( Cnt, Rpt ) mExpDo0(Rpt)mRep0##Cnt( 0, Rpt, mRepNull0, mRepNoFnComma0 )

/* repeat the macro[Rpt](Start) for [Cnt] iterations */
/* Start is incremented each iteration and passed as a parameter to Rpt */
/*  EX: #define mRepeater(Itr) S32 Var##Itr = Itr + 1;
/*      mRepeatFnS( 3, mRepeater, 10 ) */
/*      emits: S32 Var10 = 10 + 1; S32 Var11 = 11 + 1; S32 Var12 = 12 + 1; */ 
#define mRepeatFnS_VA0( Start, Cnt, RepFn, ... ) mRep##Cnt( Start, (RepFn,__VA_ARGS__), mRepFnVA0, mRepNull0 )
#define mRepeatFnS0( Start, Cnt, Rpt ) mRep0##Cnt( Start, Rpt, mRepFn0, mRepNull0 )
/* repeat macro function with a 0 starting value */
#define mRepeatFn0( Cnt, Rpt ) mRepeatFn0_( Cnt, Rpt )
#define mRepeatFn0_( Cnt, Rpt ) mRep0##Cnt( 0, Rpt, mRepFn0, mRepNull0 )
/* internally used by variable mRepeatFnS_VA and mDblLoop */
/* this version differs from the base versions by expanding and attaching m## to the RepFn */
/* -this is done to work around the MS __VA_ARGS__ bug that does not expand it correctly */
#define mRepFnVA0(Itr, RepFn) mRepFnVA0_( (Itr, mDParen(RepFn)) )
#define mRepFnVA0_(PL) mRepFnVA0_0(PL)
#define mRepFnVA0_0(PL) mRepFnVA0_1(PL)
#define mRepFnVA0_1(PL) /*mExpFn( */mRepFnVA0_2##PL// )
#define mRepFnVA0_2( Itr, RepFn, ... ) /*mExpFn(*/m##RepFn##( Itr, __VA_ARGS__ )//)
/* internally used standard repetition patterns */
#define mRepFn0(Itr, Rpt) Rpt(Itr)
#define mRepNoFn0(Itr, Rpt) Rpt
#define mRepNull0(Itr, Rpt)
#define mRepNoFnComma0(Itr, Rpt) ,Rpt

#define mRep00( Itr, Rpt, _PreFn, _Fn )
#define mRep01( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep00( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep02( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep01( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep03( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep02( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep04( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep03( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep05( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep04( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep06( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep05( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep07( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep06( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep08( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep07( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep09( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep08( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep010( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep09( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep011( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep010( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep012( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep011( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep013( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep012( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep014( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep013( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep015( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep014( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep016( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep015( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep017( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep016( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep018( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep017( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep019( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep018( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep020( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep019( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep021( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep020( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep022( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep021( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep023( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep022( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep024( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep023( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep025( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep024( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep026( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep025( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep027( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep026( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep028( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep027( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep029( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep028( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)
#define mRep030( Itr, Rpt, _PreFn, _Fn ) _PreFn(Itr, Rpt)mRep029( mIncInt(Itr), Rpt, _PreFn, _Fn )_Fn(Itr, Rpt)

#endif

#endif /* MacroCore_h */