#include <CtrlLib/CtrlLib.h>

using namespace Upp;

struct EditMoney:EditDouble
{
	virtual Value Format(const Value& q)const;
	virtual Value Scan(const Value& text) const;
};

struct MyApp: TopWindow
{
	MyApp()
	{
		e1<<=12345.67;
		Add(e1.LeftPos(20).TopPos(20));
		Add(e2.LeftPos(20).TopPos(60));
	}

	EditMoney e1, e2;
};

GUI_APP_MAIN
{
	MyApp a;
	a.Run();
}

// format to 2 decimal points with rounding
// and to the US format (thousand separator=,
// decimal mark=.)
Value EditMoney::Format(const Value& q)const
{
	if(IsNumber(q))
	{
		String s;
		double v=q;
		bool sign=v<0.;
		if(sign)
			v=-v;
		int64 t=int64((v+.005)*100);
		int r=int(t%100);
		t/=100;
		s<<Upp::Format(".%02d",Value(r));
		while(true){			
			r=uint32(t%1000);
			t/=1000;
			if(t==0){
				s.Insert(0,Upp::Format("%s%d",sign?"-":"",Value(r)));
				break;
			}else
				s.Insert(0,Upp::Format(",%03d",Value(r)));
		};
		return s;
	}
	return String();
}

Value EditMoney::Scan(const Value& text) const
{
	const Value* p=&text;
	Value v;
	if(text.Is<WString>()||text.Is<String>()){
		String s=text;
		int i=s.Find(',');
		if(i>=0)
		{
			String t=s.Left(i);
			++i;
			while(s[i]!='\0')
			{
				if(s[i]!=',')
					t<<(char)s[i];
				++i;
			}
			v=t;
			p=const_cast<const Value*>(&v);
		}
	}
	return ConvertDouble::Scan(*p);
}
