#ifdef flagMAIN
#include <CtrlLib/CtrlLib.h>
#include "VirtualDropList.h"

using namespace Upp;
// Modified function from reference/VirtualArray
static String sNumberAsText(int number)
{
	static const char * const digits[20] = {
		"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine",
		"ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen",
		"seventeen", "eighteen", "nineteen"
	};
	static const char * const tens[10] = {
		"", "ten", "twenty", "thirty", "fourty", "fifty", "sixty", "seventy", "eighty", "ninety"
	};

	if(number < 20)
		return digits[number];
	if(number < 100)
		return tens[number / 10] + String(" ") + sNumberAsText(number % 10);
	if(number < 1000)
		return digits[number / 100] + String(" hundred ") + sNumberAsText(number % 100);
	if(number < 1000000)
		return sNumberAsText(number / 1000) + " thousand, " + sNumberAsText(number % 1000);
	if(number < 1000000000)
		return sNumberAsText(number / 1000000) + " million, " + sNumberAsText(number % 1000000);
	return "";
}

template <String (GetData) (int index)>
struct NumberToText : public Convert {
	virtual Value Format(const Value& q) const {
		return GetData(int(q));
	}
};

String GetNumberText(int index)
{
	return index == 0 ? String("zero") : sNumberAsText(index);
}

class App : public TopWindow {
public:
	typedef App CLASSNAME;
	App();

	VirtualDropList list;
};

App::App()
{
	Title("Virtual DropList");
	Sizeable().Zoomable();
	SetRect(Size(320, 240));

	list.SetConvert(Single<NumberToText<GetNumberText> >());
	list.SetVirtualCount(0x100000);
	list.SetIndex(10);
	list.SetDropLines(11);

	Add(list.HSizePosZ(4, 4).TopPosZ(4, 19));
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();

	App app;
	app.Run();
}
#endif
