#include "ClangBase.h"

NAMESPACE_UPP

zCXString ConstructUSR_ObjCCategory(const char *class_name, const char *category_name)
{
	return clang_constructUSR_ObjCCategory(class_name, category_name);
}

zCXString ConstructUSR_ObjCClass(const char *name)
{
	return clang_constructUSR_ObjCClass(name);
}

zCXString ConstructUSR_ObjCIvar(const char *name, zCXString classUSR)
{
	return clang_constructUSR_ObjCIvar(name, classUSR.Get());
}

zCXString ConstructUSR_ObjCMethod(const char *name, unsigned isInstanceMethod, zCXString classUSR)
{
	return clang_constructUSR_ObjCMethod(name, isInstanceMethod, classUSR.Get());
}

zCXString ConstructUSR_ObjCProperty(const char *property, zCXString classUSR)
{
	return clang_constructUSR_ObjCProperty(property, classUSR.Get());
}

zCXString ConstructUSR_ObjCProtocol(const char *name)
{
	return clang_constructUSR_ObjCProtocol(name);
}


zCXString GetClangVersion()
{
	return clang_getClangVersion();
}

zCXString GetFileName(CXFile sFile)
{
	return clang_getFileName(sFile);
}

time_t GetFileTime(CXFile sFile)
{
	return clang_getFileTime(sFile);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
int GetFileUniqueID(CXFile file, CXFileUniqueID *outID)
{
	return clang_getFileUniqueID(file, outID);
}
#endif
zCXCursor GetNullCursor()
{
	return clang_getNullCursor();
}

zCXSourceLocation GetNullLocation()
{
	return clang_getNullLocation();
}

zCXSourceRange GetNullRange()
{
	return clang_getNullRange();
}


zCXString GetTypeKindSpelling(CXTypeKind k)
{
	return clang_getTypeKindSpelling(k);
}

CXTokenKind GetTokenKind(CXToken cxTok)
{
	return clang_getTokenKind(cxTok);
}

unsigned IsDeclaration(enum CXCursorKind k)
{
	return clang_isDeclaration(k);
}

unsigned isExpression(enum CXCursorKind k)
{
	return clang_isExpression(k);
}

unsigned IsInvalid(enum CXCursorKind k)
{
	return clang_isInvalid(k);
}

unsigned IsPreprocessing(enum CXCursorKind k)
{
	return clang_isPreprocessing(k);
}

unsigned IsReference(enum CXCursorKind k)
{
	return clang_isReference(k);
}

unsigned IsStatement(enum CXCursorKind k)
{
	return clang_isStatement(k);
}

unsigned IsTranslationUnit(enum CXCursorKind k)
{
	return clang_isTranslationUnit(k);
}

unsigned IsUnexposed(enum CXCursorKind k)
{
	return clang_isUnexposed(k);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned IsAttribute(enum CXCursorKind k)
{
	return clang_isAttribute(k);
}


const char *GetTUResourceUsageName(enum CXTUResourceUsageKind kind)
{
	return clang_getTUResourceUsageName(kind);
}

zCXRemapping GetRemappings(const char *path)
{
	return clang_getRemappings(path);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXRemapping GetRemappingsFromFileList(const char **filePaths, unsigned numFiles)
{
	return clang_getRemappingsFromFileList(filePaths, numFiles);
}

zCXDiagnosticSet LoadDiagnostics(const char *file, enum CXLoadDiag_Error *error, CXString *errorString)
{
	return clang_loadDiagnostics(file, error, errorString);
}

int IsEntityObjCContainerKind(CXIdxEntityKind k)
{
	return clang_index_isEntityObjCContainerKind(k);
}

const CXIdxObjCContainerDeclInfo *GetObjCContainerDeclInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getObjCContainerDeclInfo(info);
}

const CXIdxObjCInterfaceDeclInfo *GetObjCInterfaceDeclInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getObjCInterfaceDeclInfo(info);
}

const CXIdxObjCCategoryDeclInfo *GetObjCCategoryDeclInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getObjCCategoryDeclInfo(info);
}

const CXIdxObjCProtocolRefListInfo *GetObjCProtocolRefListInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getObjCProtocolRefListInfo(info);
}

const CXIdxObjCPropertyDeclInfo *GetObjCPropertyDeclInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getObjCPropertyDeclInfo(info);
}

const CXIdxCXXClassDeclInfo *GetCXXClassDeclInfo(const CXIdxDeclInfo *info)
{
	return clang_index_getCXXClassDeclInfo(info);
}

const CXIdxIBOutletCollectionAttrInfo *GetIBOutletCollectionAttrInfo(const CXIdxAttrInfo *info)
{
	return clang_index_getIBOutletCollectionAttrInfo(info);
}

CXIdxClientContainer GetClientContainer(const CXIdxContainerInfo *info)
{
	return clang_index_getClientContainer(info);
}

void SetClientContainer(const CXIdxContainerInfo *info, CXIdxClientContainer container)
{
	clang_index_setClientContainer(info, container);
}

CXIdxClientEntity GetClientEntity(const CXIdxEntityInfo *info)
{
	return clang_index_getClientEntity(info);
}

void SetClientEntity(const CXIdxEntityInfo *info, CXIdxClientEntity entity)
{
	clang_index_setClientEntity(info, entity);
}

void GetFileLocation(CXIdxLoc loc, CXIdxClientFile *indexFile, CXFile *file, unsigned *line, unsigned *column, unsigned *offset)
{
	clang_indexLoc_getFileLocation(loc, indexFile, file, line, column, offset);
}

zCXSourceLocation GetCXSourceLocation(CXIdxLoc loc)
{
	return clang_indexLoc_getCXSourceLocation(loc);
}
#endif


zCXString GetCursorKindSpelling(CXCursorKind kind)
{
	return clang_getCursorKindSpelling(kind);
}

void ClangEnableStackTraces()
{
	clang_enableStackTraces();
}
#ifndef flagLLVM_2_8 // LLVM_2_9
void ClangExecuteOnThread(void (*fn)(void*), void *user_data, unsigned stack_size)
{
	clang_executeOnThread(fn, user_data, stack_size);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
void ClangToggleCrashRecovery(unsigned isEnabled)
{
	clang_toggleCrashRecovery(isEnabled);
}
#endif

END_UPP_NAMESPACE
