#ifndef _ClangBase_Utilities_h_
#define _ClangBase_Utilities_h_

zCXString ConstructUSR_ObjCCategory(const char *class_name, const char *category_name);
zCXString ConstructUSR_ObjCClass(const char *name);
zCXString ConstructUSR_ObjCIvar(const char *name, zCXString classUSR);
zCXString ConstructUSR_ObjCMethod(const char *name, unsigned isInstanceMethod, zCXString classUSR);
zCXString ConstructUSR_ObjCProperty(const char *property, zCXString classUSR);
zCXString ConstructUSR_ObjCProtocol(const char *name);

zCXString GetClangVersion();
zCXString GetFileName(CXFile sFile);
time_t GetFileTime(CXFile sFile);
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
int GetFileUniqueID(CXFile file, CXFileUniqueID *outID);
#endif
zCXCursor GetNullCursor();
zCXSourceLocation GetNullLocation();
zCXSourceRange GetNullRange();

zCXString GetTypeKindSpelling(CXTypeKind k);
CXTokenKind GetTokenKind(CXToken cxTok);

unsigned IsDeclaration(enum CXCursorKind k);
unsigned isExpression(enum CXCursorKind k);
unsigned IsInvalid(enum CXCursorKind k);
unsigned IsPreprocessing(enum CXCursorKind k);
unsigned IsReference(enum CXCursorKind k);
unsigned IsStatement(enum CXCursorKind k);
unsigned IsTranslationUnit(enum CXCursorKind k);
unsigned IsUnexposed(enum CXCursorKind k);
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned IsAttribute(enum CXCursorKind k);

const char *GetTUResourceUsageName(enum CXTUResourceUsageKind kind);
zCXRemapping GetRemappings(const char *path);
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXRemapping GetRemappingsFromFileList(const char **filePaths, unsigned numFiles);
zCXDiagnosticSet LoadDiagnostics(const char *file, enum CXLoadDiag_Error *error, CXString *errorString);

int IsEntityObjCContainerKind(CXIdxEntityKind k);

const CXIdxObjCContainerDeclInfo *GetObjCContainerDeclInfo(const CXIdxDeclInfo *info);
const CXIdxObjCInterfaceDeclInfo *GetObjCInterfaceDeclInfo(const CXIdxDeclInfo *info);
const CXIdxObjCCategoryDeclInfo *GetObjCCategoryDeclInfo(const CXIdxDeclInfo *info);
const CXIdxObjCProtocolRefListInfo *GetObjCProtocolRefListInfo(const CXIdxDeclInfo *info);
const CXIdxObjCPropertyDeclInfo *GetObjCPropertyDeclInfo(const CXIdxDeclInfo *info);
const CXIdxCXXClassDeclInfo *GetCXXClassDeclInfo(const CXIdxDeclInfo *info);

const CXIdxIBOutletCollectionAttrInfo *GetIBOutletCollectionAttrInfo(const CXIdxAttrInfo *info);

CXIdxClientContainer GetClientContainer(const CXIdxContainerInfo *info);
void SetClientContainer(const CXIdxContainerInfo *info, CXIdxClientContainer container);

CXIdxClientEntity GetClientEntity(const CXIdxEntityInfo *info);
void SetClientEntity(const CXIdxEntityInfo *info, CXIdxClientEntity entity);

void GetFileLocation(CXIdxLoc loc, CXIdxClientFile *indexFile, CXFile *file, unsigned *line, unsigned *column, unsigned *offset);
zCXSourceLocation GetCXSourceLocation(CXIdxLoc loc);
#endif

// for debug/testing
zCXString GetCursorKindSpelling(CXCursorKind kind);
void ClangEnableStackTraces();
#ifndef flagLLVM_2_8 // LLVM_2_9
void ClangExecuteOnThread(void (*fn)(void*), void *user_data, unsigned stack_size);
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
void ClangToggleCrashRecovery(unsigned isEnabled);
#endif
#endif
