#include <ClangBase/ClangBase.h>

using namespace Upp;

CONSOLE_APP_MAIN
{
	const Vector<String>& cl = CommandLine();
	const int count = cl.GetCount();

	if (count < 1) {
		Cerr() << "Specify command line arguments\n";
		SetExitCode(1);
		return;
	}

	const char *args[count]; for (int i = 0; i < count; ++i) args[i] = cl[i];

	zCXIndex index(0, 0);

	zCXTranslationUnit tu = index.Parse(0, args, count, 0, 0, CXTranslationUnit_None);

	if (tu.IsEmpty()) {
		Cerr() << "Unable to load translation unit\n";
		SetExitCode(1);
		return;
	}

	for (unsigned i = 0, n = tu.GetNumDiagnostics(); i < n; ++i) 
	{
		zCXDiagnostic diag = tu.GetDiagnostic(i);
		zCXString formatDiag = diag.Format(diag.DefaultDiagnosticDisplayOptions());
		Cerr() << ~formatDiag << '\n';
	}
}
