#include "ClangBase.h"

NAMESPACE_UPP
// SourceLocation
unsigned zCXSourceLocation::operator==(const CXSourceLocation& loc) const
{
	return clang_equalLocations(data, loc);
}

unsigned zCXSourceLocation::operator==(const zCXSourceLocation& loc) const
{
	return clang_equalLocations(data, ~loc);
}

unsigned zCXSourceLocation::operator!=(const CXSourceLocation& loc) const
{
	return !clang_equalLocations(data, loc);
}

unsigned zCXSourceLocation::operator!=(const zCXSourceLocation& loc) const
{
	return !clang_equalLocations(data, ~loc);
}

zCXSourceRange zCXSourceLocation::operator-(const CXSourceLocation& end) const
{
	return clang_getRange(data, end);
}

zCXSourceRange zCXSourceLocation::operator-(const zCXSourceLocation& end) const
{
	return clang_getRange(data, ~end);
}

zCXSourceRange zCXSourceLocation::GetRange(const CXSourceLocation& end) const
{
	return clang_getRange(data, end);
}

zCXSourceRange zCXSourceLocation::GetRange(const zCXSourceLocation& end) const
{
	return clang_getRange(data, ~end);
}

void zCXSourceLocation::GetInstantiationLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const
{
	clang_getInstantiationLocation(data, file, line, column, offset);
}
#ifndef flagLLVM_2_8 // LLVM_2_9
void zCXSourceLocation::GetSpellingLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const
{
	clang_getSpellingLocation(data, file, line, column, offset);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
void zCXSourceLocation::GetExpansionLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const
{
	clang_getExpansionLocation(data, file, line, column, offset);
}

void zCXSourceLocation::GetPresumedLocation(CXString *filename, unsigned *line, unsigned *column) const
{
	clang_getPresumedLocation(data, filename, line, column);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
int zCXSourceLocation::IsInSystemHeader() const
{
	return clang_Location_isInSystemHeader(data);
}

void zCXSourceLocation::GetFileLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const
{
	clang_getFileLocation(data, file, line, column, offset);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
int zCXSourceLocation::IsFromMainFile() const
{
	return clang_Location_isFromMainFile(data);
}
#endif
// SourceRange
zCXSourceLocation zCXSourceRange::GetEnd() const
{
	return clang_getRangeEnd(data);
}

zCXSourceLocation zCXSourceRange::GetStart() const
{
	return clang_getRangeStart(data);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned zCXSourceRange::operator==(const CXSourceRange& range) const
{
	return clang_equalRanges(data, range);
}

unsigned zCXSourceRange::operator==(const zCXSourceRange& range) const
{
	return clang_equalRanges(data, ~range);
}

unsigned zCXSourceRange::operator!=(const CXSourceRange& range) const
{
	return !clang_equalRanges(data, range);
}

unsigned zCXSourceRange::operator!=(const zCXSourceRange& range) const
{
	return !clang_equalRanges(data, ~range);
}

int zCXSourceRange::IsNull() const
{
	return clang_Range_isNull(data);
}
#endif
// Diagnostic
unsigned zCXDiagnostic::DefaultDiagnosticDisplayOptions()
{
	return clang_defaultDiagnosticDisplayOptions();
}

zCXString zCXDiagnostic::Format(unsigned options) const
{
	return clang_formatDiagnostic(data, options);
}

zCXString zCXDiagnostic::GetFixIt(unsigned fixIt, CXSourceRange *replacementRange) const
{
	return clang_getDiagnosticFixIt(data, fixIt, replacementRange);
}

zCXString zCXDiagnostic::GetFixIt(unsigned fixIt, zCXSourceRange *replacementRange) const
{
	CXSourceRange range;
	zCXString fixit = clang_getDiagnosticFixIt(data, fixIt, &range);
	*replacementRange = range;
	return fixit;
}

zCXSourceLocation zCXDiagnostic::GetLocation() const
{
	return clang_getDiagnosticLocation(data);
}

unsigned zCXDiagnostic::GetNumFixIts() const
{
	return clang_getDiagnosticNumFixIts(data);
}

unsigned zCXDiagnostic::GetNumRanges() const
{
	return clang_getDiagnosticNumRanges(data);
}

zCXSourceRange zCXDiagnostic::GetRange(unsigned range) const
{
	return clang_getDiagnosticRange(data, range);
}

CXDiagnosticSeverity zCXDiagnostic::GetSeverity() const
{
	return clang_getDiagnosticSeverity(data);
}

zCXString zCXDiagnostic::GetSpelling() const
{
	return clang_getDiagnosticSpelling(data);
}
#ifndef flagLLVM_2_8 // LLVM_2_9
unsigned zCXDiagnostic::GetCategory() const
{
	return clang_getDiagnosticCategory(data);
}
#if (flagLLVM_2_9 || flagLLVM_3_0) // deprecated from LLVM_3_1, use GetCategoryText() instead
zCXString zCXDiagnostic::GetCategoryName(unsigned category) const
{
	return clang_getDiagnosticCategoryName(category);
}
#endif
zCXString zCXDiagnostic::GetOption(CXString *disable) const
{
	return clang_getDiagnosticOption(data, disable);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXString zCXDiagnostic::GetCategoryText() const
{
	return clang_getDiagnosticCategoryText(data);
}

zCXDiagnosticSet zCXDiagnostic::GetChildDiagnostics()
{
	zCXDiagnosticSet ds(clang_getChildDiagnostics(data));
	return ds.NoDisposable();
}
/*#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1*/
// DiagnosticSet
unsigned zCXDiagnosticSet::GetNumDiagnostics() const
{
	return clang_getNumDiagnosticsInSet(data);
}

zCXDiagnostic zCXDiagnosticSet::GetDiagnostic(unsigned Index)
{
	return clang_getDiagnosticInSet(data, Index);
}
#endif
// TranslationUnit
Vector<zCXCursor> zCXTranslationUnit::AnnotateTokens(CXToken *tokens, unsigned numTokens)
{
	CXCursor *cursors;
	clang_annotateTokens(data, tokens, numTokens, cursors);

	Vector<zCXCursor> zcursors;

	for (int i = 0; i < numTokens; ++i)
		zcursors.Add(cursors[i]);

	return zcursors;
}

zCXCodeCompleteResults zCXTranslationUnit::CodeCompleteAt(const char *complete_filename, unsigned complete_line, unsigned complete_column, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, unsigned options) const
{
	return clang_codeCompleteAt(data, complete_filename, complete_line, complete_column, unsaved_files, num_unsaved_files, options);
}

unsigned zCXTranslationUnit::DefaultCodeCompleteOptions()
{
	return clang_defaultCodeCompleteOptions();
}

unsigned zCXTranslationUnit::DefaultEditingTranslationUnitOptions()
{
	return clang_defaultEditingTranslationUnitOptions();
}

unsigned zCXTranslationUnit::DefaultReparseOptions() const
{
	return clang_defaultReparseOptions(data);
}

unsigned zCXTranslationUnit::DefaultSaveOptions() const
{
	return clang_defaultSaveOptions(data);
}

zCXCursor zCXTranslationUnit::GetCursor(CXSourceLocation loc) const
{
	return clang_getCursor(data, loc);
}

zCXCursor zCXTranslationUnit::GetCursor(zCXSourceLocation loc) const
{
	return clang_getCursor(data, ~loc);
}

zCXDiagnostic zCXTranslationUnit::GetDiagnostic(unsigned index) const
{
	return clang_getDiagnostic(data, index);
}

unsigned zCXTranslationUnit::GetNumDiagnostics() const
{
	return clang_getNumDiagnostics(data);
}

CXFile zCXTranslationUnit::GetFile(const char *file_name) const
{
	return clang_getFile(data, file_name);
}

void zCXTranslationUnit::GetInclusions(CXInclusionVisitor cb, CXClientData clientData)
{
	clang_getInclusions(data, cb, clientData);
}

zCXSourceLocation zCXTranslationUnit::GetLocation(CXFile file, unsigned line, unsigned column) const
{
	return clang_getLocation(data, file, line, column);
}
#ifndef flagLLVM_2_8 // LLVM_2_9
zCXSourceLocation zCXTranslationUnit::GetLocationForOffset(CXFile file, unsigned offset) const
{
	return clang_getLocationForOffset(data, file, offset);
}
#endif
zCXSourceRange zCXTranslationUnit::GetTokenExtent(CXToken cxTok) const
{
	return clang_getTokenExtent(data, cxTok);
}

CXSourceLocation zCXTranslationUnit::GetTokenLocation(CXToken cxTok) const
{
	return clang_getTokenLocation(data, cxTok);
}

zCXString zCXTranslationUnit::GetTokenSpelling(CXToken cxTok) const
{
	return clang_getTokenSpelling(data, cxTok);
}

zCXCursor zCXTranslationUnit::GetCursor() const
{
	return clang_getTranslationUnitCursor(data);
}

zCXString zCXTranslationUnit::GetSpelling() const
{
	return clang_getTranslationUnitSpelling(data);
}

int zCXTranslationUnit::Reparse(unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files, unsigned options)
{
	return clang_reparseTranslationUnit(data, num_unsaved_files, unsaved_files, options);
}

int zCXTranslationUnit::Save(const char *fileName, unsigned options)
{
	return clang_saveTranslationUnit(data, fileName, options);
}

void zCXTranslationUnit::Tokenize(CXSourceRange range, CXToken **tokens, unsigned *numTokens)
{
	clang_tokenize(data, range, tokens, numTokens);

	UnitTokens ut; ut.data = *tokens; ut.count = *numTokens;
	tokens_list.Add(ut);
}

void zCXTranslationUnit::Tokenize(zCXSourceRange range, CXToken **tokens, unsigned *numTokens)
{
	Tokenize(~range, tokens, numTokens);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned zCXTranslationUnit::IsFileMultipleIncludeGuarded(CXFile file) const
{
	return clang_isFileMultipleIncludeGuarded(data, file);
}

zCXTUResourceUsage zCXTranslationUnit::GetResourceUsage() const
{
	return clang_getCXTUResourceUsage(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXDiagnosticSet zCXTranslationUnit::GetDiagnosticSet()
{
	return clang_getDiagnosticSetFromTU(data);
}
#endif
#ifdef __has_feature
	#if __has_feature(blocks)
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
CXResult zCXTranslationUnit::FindIncludesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const
{
	return clang_findIncludesInFile(data, file, visitor);
}

CXResult zCXTranslationUnit::FindIncludesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitor) const
{
	return clang_findIncludesInFileWithBlock(data, file, visitor);
}
#endif
	#endif
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
// IndexAction
int zCXIndexAction::IndexSourceFile(CXClientData client_data, IndexerCallbacks *index_callbacks, unsigned index_callbacks_size, unsigned index_options, const char *source_filename, const char * const *command_line_args, int num_command_line_args, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, CXTranslationUnit *out_tu, unsigned tu_options)
{
	return clang_indexSourceFile(data, client_data, index_callbacks, index_callbacks_size, index_options, source_filename, command_line_args, num_command_line_args, unsaved_files, num_unsaved_files, out_tu, tu_options);
}

int zCXIndexAction::IndexTranslationUnit(CXClientData client_data, IndexerCallbacks *index_callbacks, unsigned index_callbacks_size, unsigned index_options, CXTranslationUnit tu)
{
	return clang_indexTranslationUnit(data, client_data, index_callbacks, index_callbacks_size, index_options, tu);
}
#endif
// Index
zCXTranslationUnit zCXIndex::Create(const char *ast_filename)
{
	return clang_createTranslationUnit(data, ast_filename);
}

zCXTranslationUnit zCXIndex::CreateFromSourceFile(const char *source_filename, int num_command_line_args, const char * const *command_line_args, unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files)
{
	return clang_createTranslationUnitFromSourceFile(data, source_filename, num_command_line_args, command_line_args, num_unsaved_files, unsaved_files);
}

zCXTranslationUnit zCXIndex::Parse(const char *source_filename, const char * const *command_line_args, int num_command_line_args, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, unsigned options)
{
	return clang_parseTranslationUnit(data, source_filename, command_line_args, num_command_line_args, unsaved_files, num_unsaved_files, options);
}
#ifdef flagLLVM_2_8 // LLVM_2_8
zCXCodeCompleteResults zCXIndex::CodeComplete(const char *source_filename, int num_command_line_args, const char * const *command_line_args, unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files, const char *complete_filename, unsigned complete_line, unsigned complete_column)
{
	return clang_codeComplete(data, source_filename, num_command_line_args, command_line_args, num_unsaved_files, unsaved_files, complete_filename, complete_line, complete_column);
}

void zCXIndex::SetUseExternalASTGeneration(int value)
{
	clang_setUseExternalASTGeneration(data, value);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
unsigned zCXIndex::GetGlobalOptions()
{
	return clang_CXIndex_getGlobalOptions(data);
}

void zCXIndex::SetGlobalOptions(unsigned options)
{
	clang_CXIndex_setGlobalOptions(data, options);
}

zCXIndexAction zCXIndex::CreateIndexAction()
{
	return clang_IndexAction_create(data);
}
#endif
// CompletionString
CXAvailabilityKind zCXCompletionString::GetAvailability() const
{
	return clang_getCompletionAvailability(data);
}

zCXCompletionString zCXCompletionString::GetCompletionString(unsigned chunk_number) const
{
	return clang_getCompletionChunkCompletionString(data, chunk_number);
}

CXCompletionChunkKind zCXCompletionString::GetChunkKind(unsigned chunk_number) const
{
	return clang_getCompletionChunkKind(data, chunk_number);
}

zCXString zCXCompletionString::GetChunkText(unsigned chunk_number) const
{
	return clang_getCompletionChunkText(data, chunk_number);
}

unsigned zCXCompletionString::GetPriority() const
{
	return clang_getCompletionPriority(data);
}

unsigned zCXCompletionString::GetNumChunks() const
{
	return clang_getNumCompletionChunks(data);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned zCXCompletionString::GetNumAnnotations() const
{
	return clang_getCompletionNumAnnotations(data);
}

zCXString zCXCompletionString::GetAnnotation(unsigned annotation_number) const
{
	return clang_getCompletionAnnotation(data, annotation_number);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXString zCXCompletionString::GetCompletionParent(enum CXCursorKind *kind)
{
	return clang_getCompletionParent(data, kind);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
zCXString zCXCompletionString::GetCompletionBriefComment()
{
	return clang_getCompletionBriefComment(data);
}
#endif
// CodeCompleteResults
CXCompletionResult zCXCodeCompleteResults::GetResult(unsigned index)
{
	return data->Results[index];
}

CXCursorKind zCXCodeCompleteResults::GetResultKind(unsigned index) const
{
	return data->Results[index].CursorKind;
}

zCXCompletionString zCXCodeCompleteResults::GetResultString(unsigned index) const
{
	return data->Results[index].CompletionString;
}

unsigned zCXCodeCompleteResults::GetNumResults()
{
	return data->NumResults;
}

zCXDiagnostic zCXCodeCompleteResults::GetDiagnostic(unsigned index) const
{
	return clang_codeCompleteGetDiagnostic(data, index);
}

unsigned zCXCodeCompleteResults::GetNumDiagnostics() const
{
	return clang_codeCompleteGetNumDiagnostics(data);
}

void zCXCodeCompleteResults::SortResults()
{
	clang_sortCodeCompletionResults(data->Results, data->NumResults);
}
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned long long zCXCodeCompleteResults::GetContexts() const
{
	return clang_codeCompleteGetContexts(data);
}

enum CXCursorKind zCXCodeCompleteResults::GetContainerKind(unsigned *isIncomplete) const
{
	return clang_codeCompleteGetContainerKind(data, isIncomplete);
}

zCXString zCXCodeCompleteResults::GetContainerUSR() const
{
	return clang_codeCompleteGetContainerUSR(data);
}

zCXString zCXCodeCompleteResults::GetObjCSelector() const
{
	return clang_codeCompleteGetObjCSelector(data);
}
#endif
// Type
zCXType zCXType::getCanonicalType() const
{
	return clang_getCanonicalType(data);
}

zCXType zCXType::GetPointeeType() const
{
	return clang_getPointeeType(data);
}

zCXType zCXType::GetResultType() const
{
	return clang_getResultType(data);
}

zCXCursor zCXType::GetTypeDeclaration() const
{
	return clang_getTypeDeclaration(data);
}

zCXString zCXType::GetTypeKindSpelling() const
{
	return clang_getTypeKindSpelling(data.kind);
}

unsigned zCXType::IsPODType() const
{
	return clang_isPODType(data);
}
#ifndef flagLLVM_2_8 // LLVM_2_9
unsigned zCXType::IsConstQualifiedType() const
{
	return clang_isConstQualifiedType(data);
}

unsigned zCXType::IsRestrictQualifiedType() const
{
	return clang_isRestrictQualifiedType(data);
}

unsigned zCXType::IsVolatileQualifiedType() const
{
	return clang_isVolatileQualifiedType(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
zCXType zCXType::GetArrayElementType() const
{
	return clang_getArrayElementType(data);
}

long long zCXType::GetArraySize() const
{
	return clang_getArraySize(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
enum CXCallingConv zCXType::GetFunctionTypeCallingConv() const
{
	return clang_getFunctionTypeCallingConv(data);
}

int zCXType::GetNumArgTypes() const
{
	return clang_getNumArgTypes(data);
}

zCXType zCXType::GetArgType(unsigned i) const
{
	return clang_getArgType(data, i);
}

unsigned zCXType::IsFunctionTypeVariadic() const
{
	return clang_isFunctionTypeVariadic(data);
}

zCXType zCXType::GetElementType() const
{
	return clang_getElementType(data);
}

long long zCXType::GetNumElements() const
{
	return clang_getNumElements(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
zCXString zCXType::GgetTypeSpelling() const
{
	return clang_getTypeSpelling(data);
}

long long zCXType::GetAlignOf() const
{
	return clang_Type_getAlignOf(data);
}

long long zCXType::GetSizeOf() const
{
	return clang_Type_getSizeOf(data);
}

long long zCXType::GetOffsetOf(const char *s) const
{
	return clang_Type_getOffsetOf(data, s);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
zCXType zCXType::GetClassType() const
{
	return clang_Type_getClassType(data);
}

enum CXRefQualifierKind zCXType::GetCXXRefQualifier() const
{
	return clang_Type_getCXXRefQualifier(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
// Comment
enum CXCommentKind zCXComment::GetKind() const
{
	return clang_Comment_getKind(data);
}

unsigned zCXComment::GetNumChildren() const
{
	return clang_Comment_getNumChildren(data);
}

zCXComment zCXComment::GetChild(unsigned childIdx) const
{
	return clang_Comment_getChild(data, childIdx);
}

unsigned zCXComment::IsWhitespace() const
{
	return clang_Comment_isWhitespace(data);
}

unsigned zCXComment::InlineContentComment_hasTrailingNewline() const
{
	return clang_InlineContentComment_hasTrailingNewline(data);
}

zCXString zCXComment::TextComment_getText() const
{
	return clang_TextComment_getText(data);
}

zCXString zCXComment::InlineCommandComment_getCommandName() const
{
	return clang_InlineCommandComment_getCommandName(data);
}

enum CXCommentInlineCommandRenderKind zCXComment::InlineCommandComment_getRenderKind() const
{
	return clang_InlineCommandComment_getRenderKind(data);
}

unsigned zCXComment::InlineCommandComment_getNumArgs() const
{
	return clang_InlineCommandComment_getNumArgs(data);
}

zCXString zCXComment::InlineCommandComment_getArgText(unsigned argIdx) const
{
	return clang_InlineCommandComment_getArgText(data, argIdx);
}

zCXString zCXComment::HTMLTagComment_getTagName() const
{
	return clang_HTMLTagComment_getTagName(data);
}

unsigned zCXComment::HTMLStartTagComment_isSelfClosing() const
{
	return clang_HTMLStartTagComment_isSelfClosing(data);
}

unsigned zCXComment::HTMLStartTag_getNumAttrs() const
{
	return clang_HTMLStartTag_getNumAttrs(data);
}

zCXString zCXComment::HTMLStartTag_getAttrName(unsigned attrIdx) const
{
	return clang_HTMLStartTag_getAttrName(data, attrIdx);
}

zCXString zCXComment::HTMLStartTag_getAttrValue(unsigned attrIdx) const
{
	return clang_HTMLStartTag_getAttrValue(data, attrIdx);
}

zCXString zCXComment::BlockCommandComment_getCommandName() const
{
	return clang_BlockCommandComment_getCommandName(data);
}

unsigned zCXComment::BlockCommandComment_getNumArgs() const
{
	return clang_BlockCommandComment_getNumArgs(data);
}

zCXString zCXComment::BlockCommandComment_getArgText(unsigned argIdx) const
{
	return clang_BlockCommandComment_getArgText(data, argIdx);
}

zCXComment zCXComment::BlockCommandComment_getParagraph() const
{
	return clang_BlockCommandComment_getParagraph(data);
}

zCXString zCXComment::ParamCommandComment_getParamName() const
{
	return clang_ParamCommandComment_getParamName(data);
}

unsigned zCXComment::ParamCommandComment_isParamIndexValid() const
{
	return clang_ParamCommandComment_isParamIndexValid(data);
}

unsigned zCXComment::ParamCommandComment_getParamIndex() const
{
	return clang_ParamCommandComment_getParamIndex(data);
}

unsigned zCXComment::ParamCommandComment_isDirectionExplicit() const
{
	return clang_ParamCommandComment_isDirectionExplicit(data);
}

enum CXCommentParamPassDirection zCXComment::ParamCommandComment_getDirection() const
{
	return clang_ParamCommandComment_getDirection(data);
}

zCXString zCXComment::TParamCommandComment_getParamName() const
{
	return clang_TParamCommandComment_getParamName(data);
}

unsigned zCXComment::TParamCommandComment_isParamPositionValid() const
{
	return clang_TParamCommandComment_isParamPositionValid(data);
}

unsigned zCXComment::TParamCommandComment_getDepth() const
{
	return clang_TParamCommandComment_getDepth(data);
}

unsigned zCXComment::TParamCommandComment_getIndex(unsigned depth) const
{
	return clang_TParamCommandComment_getIndex(data, depth);
}

zCXString zCXComment::VerbatimBlockLineComment_getText() const
{
	return clang_VerbatimBlockLineComment_getText(data);
}

zCXString zCXComment::VerbatimLineComment_getText() const
{
	return clang_VerbatimLineComment_getText(data);
}

zCXString zCXComment::HTMLTagComment_getAsString() const
{
	return clang_HTMLTagComment_getAsString(data);
}

zCXString zCXComment::FullComment_getAsHTML() const
{
	return clang_FullComment_getAsHTML(data);
}

zCXString zCXComment::FullComment_getAsXML() const
{
	return clang_FullComment_getAsXML(data);
}
// Module
zCXModule zCXModule::GetParent() const
{
	return clang_Module_getParent(data);
}

zCXString zCXModule::GetName() const
{
	return clang_Module_getName(data);
}

zCXString zCXModule::GetFullName() const
{
	return clang_Module_getFullName(data);
}
#ifdef flagLLVM_3_2 // LLVM_3_2
unsigned zCXModule::GetNumTopLevelHeaders() const
{
	return clang_Module_getNumTopLevelHeaders(data);
}

CXFile zCXModule::GetTopLevelHeader(unsigned index) const
{
	return clang_Module_getTopLevelHeader(data, index);
}
#else // LLVM_3_3
unsigned zCXModule::GetNumTopLevelHeaders(CXTranslationUnit tu) const
{
	return clang_Module_getNumTopLevelHeaders(tu, data);
}

CXFile zCXModule::GetTopLevelHeader(CXTranslationUnit tu, unsigned index) const
{
	return clang_Module_getTopLevelHeader(tu, data, index);
}

CXFile zCXModule::GetASTFile()
{
	return clang_Module_getASTFile(data);
}
#endif
#endif
// Cursor
unsigned zCXCursor::CXXMethod_isStatic() const
{
	return clang_CXXMethod_isStatic(data);
}

CX_CXXAccessSpecifier zCXCursor::GetCXXAccessSpecifier() const
{
	return clang_getCXXAccessSpecifier(data);
}

CXAvailabilityKind zCXCursor::GetAvailability() const
{
	return clang_getCursorAvailability(data);
}

zCXCursor zCXCursor::GetDefinition() const
{
	return clang_getCursorDefinition(data);
}

zCXSourceRange zCXCursor::GetExtent() const
{
	return clang_getCursorExtent(data);
}

CXCursorKind zCXCursor::GetKind() const
{
	return clang_getCursorKind(data);
}

zCXString zCXCursor::GetKindSpelling() const
{
	return clang_getCursorKindSpelling(data.kind);
}

CXLanguageKind zCXCursor::GetLanguage() const
{
	return clang_getCursorLanguage(data);
}

CXLinkageKind zCXCursor::GetLinkage() const
{
	return clang_getCursorLinkage(data);
}

zCXSourceLocation zCXCursor::GetLocation() const
{
	return clang_getCursorLocation(data);
}

zCXCursor zCXCursor::GetReferenced() const
{
	return clang_getCursorReferenced(data);
}

zCXType zCXCursor::GetResultType() const
{
	return clang_getCursorResultType(data);
}

zCXString zCXCursor::GetSpelling() const
{
	return clang_getCursorSpelling(data);
}

zCXType zCXCursor::GetType() const
{
	return clang_getCursorType(data);
}

zCXString zCXCursor::GetUSR() const
{
	return clang_getCursorUSR(data);
}

void zCXCursor::GetDefinitionSpellingAndExtent(const char **startBuf, const char **endBuf, unsigned *startLine, unsigned *startColumn, unsigned *endLine, unsigned *endColumn) const
{
	clang_getDefinitionSpellingAndExtent(data, startBuf, endBuf, startLine, startColumn, endLine, endColumn);
}

zCXType zCXCursor::GetIBOutletCollectionType() const
{
	return clang_getIBOutletCollectionType(data);
}

zCXCursor zCXCursor::GetSpecializedTemplate() const
{
	return clang_getSpecializedCursorTemplate(data);
}

CXCursorKind zCXCursor::GetTemplateKind() const
{
	return clang_getTemplateCursorKind(data);
}

zCXString zCXCursor::GetTemplateKindSpelling() const
{
	return clang_getCursorKindSpelling(clang_getTemplateCursorKind(data));
}

unsigned zCXCursor::IsDefinition() const
{
	return clang_isCursorDefinition(data);
}

unsigned zCXCursor::IsVirtualBase() const
{
	return clang_isVirtualBase(data);
}

unsigned zCXCursor::IsDeclaration() const
{
	return clang_isDeclaration(data.kind);
}

unsigned zCXCursor::isExpression() const
{
	return clang_isExpression(data.kind);
}

unsigned zCXCursor::IsInvalid() const
{
	return clang_isInvalid(data.kind);
}

unsigned zCXCursor::IsPreprocessing() const
{
	return clang_isPreprocessing(data.kind);
}

unsigned zCXCursor::IsReference() const
{
	return clang_isReference(data.kind);
}

unsigned zCXCursor::IsStatement() const
{
	return clang_isStatement(data.kind);
}

unsigned zCXCursor::IsTranslationUnit() const
{
	return clang_isTranslationUnit(data.kind);
}

unsigned zCXCursor::IsUnexposed() const
{
	return clang_isUnexposed(data.kind);
}

unsigned zCXCursor::VisitChildren(CXCursorVisitor visitor, CXClientData client_data) const
{
	return clang_visitChildren(data, visitor, client_data);
}
#ifndef flagLLVM_2_8 // LLVM_2_9
zCXCursor zCXCursor::GetCanonical() const
{
	return clang_getCanonicalCursor(data);
}

zCXString zCXCursor::GetDeclObjCTypeEncoding() const
{
	return clang_getDeclObjCTypeEncoding(data);
}

zCXString zCXCursor::GetDisplayName() const
{
	return clang_getCursorDisplayName(data);
}

zCXCursor zCXCursor::GetLexicalParent() const
{
	return clang_getCursorLexicalParent(data);
}

zCXCursor zCXCursor::GetSemanticParent() const
{
	return clang_getCursorSemanticParent(data);
}

CXFile zCXCursor::GetIncludedFile() const
{
	return clang_getIncludedFile(data);
}

unsigned zCXCursor::GetNumOverloadedDecls() const
{
	return clang_getNumOverloadedDecls(data);
}

zCXCursor zCXCursor::GetOverloadedDecl(unsigned index) const
{
	return clang_getOverloadedDecl(data, index);
}

#ifdef __has_feature
	#if __has_feature(blocks)
unsigned zCXCursor::VisitChildrenWithBlock(CXCursorVisitorBlock block) const
{
	return clang_visitChildrenWithBlock(data, block);
}
	#endif
#endif
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned zCXCursor::CXXMethod_isVirtual() const
{
	return clang_CXXMethod_isVirtual(data);
}

zCXSourceRange zCXCursor::GetReferenceNameRange(unsigned nameFlags, unsigned pieceIndex) const
{
	return clang_getCursorReferenceNameRange(data, nameFlags, pieceIndex);
}

int zCXCursor::IsNull() const
{
	return clang_Cursor_isNull(data);
}

zCXTranslationUnit zCXCursor::GetTranslationUnit() const
{
	return clang_Cursor_getTranslationUnit(data);
}
#ifdef __has_feature
	#if __has_feature(blocks)
zCXString zCXCursor::GetDeclObjCTypeEncoding() const
{
	return clang_getDeclObjCTypeEncoding(data);
}

zCXCompletionString zCXCursor::GetCompletionString() const
{
	return clang_getCursorCompletionString(data);
}
#if flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2
void zCXCursor::FindReferencesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitorBlock) const
{
	clang_findReferencesInFileWithBlock(data, file, visitorBlock);
}
#else // LLVM_3_3
CXResult zCXCursor::FindReferencesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitorBlock) const
{
	return clang_findReferencesInFileWithBlock(data, file, visitorBlock);
}
#endif
	#endif
#endif
#if flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2
void zCXCursor::FindReferencesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const
{
	clang_findReferencesInFile(data, file, visitor);
}
#else // LLVM_3_3
CXResult zCXCursor::FindReferencesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const
{
	return clang_findReferencesInFile(data, file, visitor);
}
#endif
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
zCXType zCXCursor::GetTypedefDeclUnderlyingType() const
{
	return clang_getTypedefDeclUnderlyingType(data);
}

zCXType zCXCursor::GetEnumDeclIntegerType() const
{
	return clang_getEnumDeclIntegerType(data);
}

long long zCXCursor::GetEnumConstantDeclValue() const
{
	return clang_getEnumConstantDeclValue(data);
}

unsigned long long zCXCursor::GetEnumConstantDeclUnsignedValue() const
{
	return clang_getEnumConstantDeclUnsignedValue(data);
}

int zCXCursor::GetNumArguments() const
{
	return clang_Cursor_getNumArguments(data);
}

zCXCursor zCXCursor::GetArgument(unsigned i) const
{
	return clang_Cursor_getArgument(data, i);
}

zCXSourceRange zCXCursor::GetSpellingNameRange(unsigned pieceIndex, unsigned options) const
{
	return clang_Cursor_getSpellingNameRange(data, pieceIndex, options);
}

int zCXCursor::GetObjCSelectorIndex() const
{
	return clang_Cursor_getObjCSelectorIndex(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
int zCXCursor::GetPlatformAvailability(int *always_deprecated, CXString *deprecated_message, int *always_unavailable, CXString *unavailable_message, CXPlatformAvailability *availability, int availability_size) const
{// From documentation:
 // Returns The number of platforms (N) for which availability information is available (which is unrelated to availability_size).
 // Note that the client is responsible for calling clang_disposeCXPlatformAvailability to free each of the platform-availability structures returned.
 // There are min(N, availability_size) such structures.
	return clang_getCursorPlatformAvailability(data, always_deprecated, deprecated_message, always_unavailable, unavailable_message, availability, availability_size);
}

Vector<zCXPlatformAvailability> zCXCursor::GetPlatformAvailability(int *always_deprecated, zCXString *deprecated_message, int *always_unavailable, zCXString *unavailable_message, int availability_size) const
{
	Vector<zCXPlatformAvailability> list;

	if (availability_size < 0)
		return list;

	CXString _deprecated_message, _unavailable_message;
	CXPlatformAvailability availability[availability_size];
	int count = clang_getCursorPlatformAvailability(data, always_deprecated, &_deprecated_message, always_unavailable, &_unavailable_message, availability, availability_size);
	*deprecated_message = _deprecated_message; *unavailable_message = _unavailable_message;

	if (count > availability_size)
		count = availability_size;

	for (int i = 0; i < count; ++i)
		list.Add(availability[i]);

	return list;
}

int zCXCursor::IsDynamicCall() const
{
	return clang_Cursor_isDynamicCall(data);
}

zCXType zCXCursor::GetReceiverType() const
{
	return clang_Cursor_getReceiverType(data);
}

zCXSourceRange zCXCursor::GetCommentRange() const
{
	return clang_Cursor_getCommentRange(data);
}

zCXString zCXCursor::GetRawCommentText() const
{
	return clang_Cursor_getRawCommentText(data);
}

zCXString zCXCursor::GetBriefCommentText() const
{
	return clang_Cursor_getBriefCommentText(data);
}

zCXComment zCXCursor::GetParsedComment() const
{
	return clang_Cursor_getParsedComment(data);
}

zCXModule zCXCursor::GetModule() const
{
	return clang_Cursor_getModule(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
int zCXCursor::GetFieldDeclBitWidth() const
{
	return clang_getFieldDeclBitWidth(data);
}

unsigned zCXCursor::IsBitField() const
{
	return clang_Cursor_isBitField(data);
}

unsigned zCXCursor::GetObjCPropertyAttributes(unsigned reserved) const
{
	return clang_Cursor_getObjCPropertyAttributes(data, reserved);
}

unsigned zCXCursor::GetObjCDeclQualifiers() const
{
	return clang_Cursor_getObjCDeclQualifiers(data);
}

unsigned zCXCursor::IsVariadic() const
{
	return clang_Cursor_isVariadic(data);
}
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
unsigned zCXCursor::IsObjCOptional() const
{
	return clang_Cursor_isObjCOptional(data);
}

unsigned zCXCursor::CXXMethod_isPureVirtual() const
{
	return clang_CXXMethod_isPureVirtual(data);
}
#endif
#ifndef flagLLVM_2_8 // LLVM_2_9
// CursorSet
unsigned zCXCursorSet::Contains(CXCursor cursor) const
{
	return clang_CXCursorSet_contains(data, cursor);
}

unsigned zCXCursorSet::Insert(CXCursor cursor) const
{
	return clang_CXCursorSet_insert(data, cursor);
}
#endif
// Remapping
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
unsigned zCXRemapping::GetNumFiles() const
{
	return clang_remap_getNumFiles(data);
}

void zCXRemapping::GetFilenames(unsigned index, CXString *original, CXString *transformed)
{
	clang_remap_getFilenames(data, index, original, transformed);
}

void zCXRemapping::GetFilenames(unsigned index, zCXString& original, zCXString& transformed)
{
	CXString orig = original.Get(), trans = transformed.Get();
	clang_remap_getFilenames(data, index, &orig, &trans);
	original = orig; transformed = trans;
}
#endif

END_UPP_NAMESPACE
