#ifndef _ClangBase_ClangBase_h_
#define _ClangBase_ClangBase_h_

#include <clang-c/Index.h>
#include <Core/Core.h>

NAMESPACE_UPP

class zCXString : Moveable<zCXString> {
protected:
	CXString data;
public:
	zCXString() { }
	zCXString(const CXString& text) : data(text) { }
	~zCXString() { clang_disposeString(data); }

	const CXString& Get() const { return data; }
	const char *operator~() const { return clang_getCString(data); }
	zCXString& operator=(const CXString& text) { data = text; return *this; }

	unsigned GetHashValue() const { return String(clang_getCString(data)).GetHashValue(); }
	bool IsEmpty() const { return strcmp(clang_getCString(data), "") == 0; }
};

class zCXSourceRange;

class zCXSourceLocation : Moveable<zCXSourceLocation> {
protected:
	CXSourceLocation data;
public:
	zCXSourceLocation() { }
	zCXSourceLocation(const CXSourceLocation& loc) : data(loc) { }

	const CXSourceLocation& Get() const { return data; }
	const CXSourceLocation& operator~() const { return data; }
	zCXSourceLocation& operator=(const CXSourceLocation& loc) { data = loc; return *this; }
	unsigned operator==(const CXSourceLocation& loc) const;
	unsigned operator==(const zCXSourceLocation& loc) const;
	unsigned operator!=(const CXSourceLocation& loc) const;
	unsigned operator!=(const zCXSourceLocation& loc) const;
	zCXSourceRange operator-(const CXSourceLocation& end) const;
	zCXSourceRange operator-(const zCXSourceLocation& end) const;

	zCXSourceRange GetRange(const CXSourceLocation& end) const;
	zCXSourceRange GetRange(const zCXSourceLocation& end) const;
	void GetInstantiationLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const;
#ifndef flagLLVM_2_8 // LLVM_2_9
	void GetSpellingLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	void GetExpansionLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const;
	void GetPresumedLocation(CXString *filename, unsigned *line, unsigned *column) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
	int IsInSystemHeader() const;
	void GetFileLocation(CXFile *file, unsigned *line, unsigned *column, unsigned *offset) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
	int IsFromMainFile() const;
#endif
};

class zCXSourceRange : Moveable<zCXSourceRange> {
protected:
	CXSourceRange data;
public:
	zCXSourceRange() { }
	zCXSourceRange(const CXSourceRange& range) : data(range) { }

	const CXSourceRange& Get() const { return data; }
	const CXSourceRange& operator~() const { return data; }
	zCXSourceRange& operator=(const CXSourceRange& range) { data = range; return *this; }

	zCXSourceLocation GetEnd() const;
	zCXSourceLocation GetStart() const;
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	unsigned operator==(const CXSourceRange& range) const;
	unsigned operator==(const zCXSourceRange& range) const;
	unsigned operator!=(const CXSourceRange& range) const;
	unsigned operator!=(const zCXSourceRange& range) const;
	int IsNull() const;
#endif
};

class zCXDiagnosticSet;

class zCXDiagnostic : Moveable<zCXDiagnostic> {
protected:
	CXDiagnostic data;
public:
	zCXDiagnostic() { }
	zCXDiagnostic(const CXDiagnostic& diag) : data(diag) { }
	~zCXDiagnostic() { clang_disposeDiagnostic(data); }

	const CXDiagnostic& Get() const { return data; }
	const CXDiagnostic& operator~() const { return data; }
	zCXDiagnostic& operator=(const CXDiagnostic& diag) { data = diag; return *this; }
	unsigned GetHashValue() const { return GetSpelling().GetHashValue(); }

	static unsigned DefaultDiagnosticDisplayOptions();
	zCXString Format(unsigned options) const;
	zCXString GetFixIt(unsigned fixIt, CXSourceRange *replacementRange) const;
	zCXString GetFixIt(unsigned fixIt, zCXSourceRange *replacementRange) const;
	zCXSourceLocation GetLocation() const;
	unsigned GetNumFixIts() const;
	unsigned GetNumRanges() const;
	zCXSourceRange GetRange(unsigned range) const;
	CXDiagnosticSeverity GetSeverity() const;
	zCXString GetSpelling() const;
#ifndef flagLLVM_2_8 // LLVM_2_9
	unsigned GetCategory() const;
#if (flagLLVM_2_9 || flagLLVM_3_0) // deprecated from LLVM_3_1, use GetCategoryText() instead
	zCXString GetCategoryName(unsigned category) const;
#endif
	zCXString GetOption(CXString *disable) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
	zCXString GetCategoryText() const;
	zCXDiagnosticSet GetChildDiagnostics();
#endif
};
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
class zCXDiagnosticSet : Moveable<zCXDiagnosticSet> {
protected:
	CXDiagnosticSet data;
	bool dispose;
public:
	zCXDiagnosticSet() : dispose(true) { }
	zCXDiagnosticSet(const CXDiagnosticSet& ds) : dispose(true), data(ds) { }
	~zCXDiagnosticSet() { if (dispose) clang_disposeDiagnosticSet(data); }
	zCXDiagnosticSet& Disposable(bool check = true) { dispose = check; return *this; }
	zCXDiagnosticSet& NoDisposable() { return Disposable(false); }

	unsigned GetNumDiagnostics() const;
	zCXDiagnostic GetDiagnostic(unsigned Index);
};
#endif
class zCXCompletionString : Moveable<zCXCompletionString> {
protected:
	CXCompletionString data;
public:
	zCXCompletionString() { }
	zCXCompletionString(const CXCompletionString& text) : data(text) { }

	const CXCompletionString& Get() const { return data; }
	const CXCompletionString& operator~() const { return data; }
	zCXCompletionString& operator=(const CXCompletionString text) { data = text; return *this; }

	CXAvailabilityKind GetAvailability() const;
	zCXCompletionString GetCompletionString(unsigned chunk_number) const;
	CXCompletionChunkKind GetChunkKind(unsigned chunk_number) const;
	zCXString GetChunkText(unsigned chunk_number) const;
	unsigned GetPriority() const;
	unsigned GetNumChunks() const;
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	unsigned GetNumAnnotations() const;
	zCXString GetAnnotation(unsigned annotation_number) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1, the kind argument is deprecated from LLVM_3_2: always set to CXCursor_NotImplemented if non-NULL.
	zCXString GetCompletionParent(enum CXCursorKind *kind);
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
	zCXString GetCompletionBriefComment();
#endif
};

class zCXCodeCompleteResults : Moveable<zCXCodeCompleteResults> {
protected:
	CXCodeCompleteResults *data;
public:
	zCXCodeCompleteResults() { }
	zCXCodeCompleteResults(CXCodeCompleteResults *results) : data(results) { }
	~zCXCodeCompleteResults() { clang_disposeCodeCompleteResults(data); }

	const CXCodeCompleteResults *Get() const { return data; }
	const CXCodeCompleteResults *operator~() const { return data; }
	zCXCodeCompleteResults& operator=(CXCodeCompleteResults *results) { data = results; return *this; }

	CXCompletionResult GetResult(unsigned index);
	CXCursorKind GetResultKind(unsigned index) const;
	zCXCompletionString GetResultString(unsigned index) const;
	unsigned GetNumResults();
	zCXDiagnostic GetDiagnostic(unsigned index) const;
	unsigned GetNumDiagnostics() const;
	void SortResults();
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	unsigned long long GetContexts() const;
	enum CXCursorKind GetContainerKind(unsigned *isIncomplete) const;
	zCXString GetContainerUSR() const;
	zCXString GetObjCSelector() const;
#endif
};

#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
class zCXTUResourceUsage : Moveable<zCXTUResourceUsage> {
protected:
	CXTUResourceUsage data;
public:
	zCXTUResourceUsage() { }
	zCXTUResourceUsage(const CXTUResourceUsage& usage): data(usage) { }
	~zCXTUResourceUsage() { clang_disposeCXTUResourceUsage(data); }
	
	const CXTUResourceUsage& Get() const { return data; }
	const CXTUResourceUsage& operator~() const { return data; }
	zCXTUResourceUsage& operator=(const CXTUResourceUsage& usage) { data = usage; return *this; }
};
#endif

class zCXCursor;

class zCXTranslationUnit : Moveable<zCXTranslationUnit> {
protected:
	struct UnitTokens : Moveable<UnitTokens> {
		CXToken *data;
		unsigned count;
	};

	CXTranslationUnit data;
	Vector<UnitTokens> tokens_list;
public:
	zCXTranslationUnit() { }
	zCXTranslationUnit(const CXTranslationUnit& tu) : data(tu) { }
	~zCXTranslationUnit()
	{
		for (int i = 0, n = tokens_list.GetCount(); i < n; ++i)
			clang_disposeTokens(data, tokens_list[i].data, tokens_list[i].count);

		clang_disposeTranslationUnit(data);
	}

	const CXTranslationUnit& Get() const { return data; }
	const CXTranslationUnit& operator~() const { return data; }
	zCXTranslationUnit& operator=(const CXTranslationUnit& tu) { data = tu; return *this; }
	bool IsEmpty() const { return data == NULL; }

	Vector<zCXCursor> AnnotateTokens(CXToken *tokens, unsigned numTokens);
	zCXCodeCompleteResults CodeCompleteAt(const char *complete_filename, unsigned complete_line, unsigned complete_column, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, unsigned options) const;
	static unsigned DefaultCodeCompleteOptions();
	static unsigned DefaultEditingTranslationUnitOptions();
	unsigned DefaultReparseOptions() const;
	unsigned DefaultSaveOptions() const;
	zCXCursor GetCursor(CXSourceLocation loc) const;
	zCXCursor GetCursor(zCXSourceLocation loc) const;
	zCXDiagnostic GetDiagnostic(unsigned index) const;
	unsigned GetNumDiagnostics() const;
	CXFile GetFile(const char *file_name) const;
	void GetInclusions(CXInclusionVisitor cb, CXClientData clientData);
	zCXSourceLocation GetLocation(CXFile file, unsigned line, unsigned column) const;
#ifndef flagLLVM_2_8 // LLVM_2_9
	zCXSourceLocation GetLocationForOffset(CXFile file, unsigned offset) const;
#endif
	zCXSourceRange GetTokenExtent(CXToken cxTok) const;
	CXSourceLocation GetTokenLocation(CXToken cxTok) const;
	zCXString GetTokenSpelling(CXToken cxTok) const;
	zCXCursor GetCursor() const;
	zCXString GetSpelling() const;
	int Reparse(unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files, unsigned options);
	int Save(const char *fileName, unsigned options);
	void Tokenize(CXSourceRange range, CXToken **tokens, unsigned *numTokens);
	void Tokenize(zCXSourceRange range, CXToken **tokens, unsigned *numTokens);
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	unsigned IsFileMultipleIncludeGuarded(CXFile file) const;
	zCXTUResourceUsage GetResourceUsage() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
	zCXDiagnosticSet GetDiagnosticSet();
#endif
#ifdef __has_feature
	#if __has_feature(blocks)
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
	CXResult FindIncludesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const;
	CXResult FindIncludesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitor) const;
#endif
	#endif
#endif
};

#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
class zCXIndexAction : Moveable<zCXIndexAction> {
protected:
	CXIndexAction data;
public:
	zCXIndexAction() { }
	zCXIndexAction(const CXIndexAction& action) : data(action) { }
	~zCXIndexAction() { clang_IndexAction_dispose(data); }

	const CXIndexAction& Get() const { return data; }
	const CXIndexAction& operator~() const { return data; }
	zCXIndexAction& operator=(const CXIndexAction& action) { data = action; return *this; }

	int IndexSourceFile(CXClientData client_data, IndexerCallbacks *index_callbacks, unsigned index_callbacks_size, unsigned index_options, const char *source_filename, const char * const *command_line_args, int num_command_line_args, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, CXTranslationUnit *out_tu, unsigned tu_options);
	int IndexTranslationUnit(CXClientData client_data, IndexerCallbacks *index_callbacks, unsigned index_callbacks_size, unsigned index_options, CXTranslationUnit tu);
};
#endif

class zCXIndex : Moveable<zCXIndex> {
protected:
	CXIndex data;
public:
	zCXIndex() { }
	zCXIndex(int excludeDeclarationsFromPCH, int displayDiagnostics) :
		data(clang_createIndex(excludeDeclarationsFromPCH, displayDiagnostics)) { }

	zCXIndex(const CXIndex& index) : data(index) { }
	~zCXIndex() { clang_disposeIndex(data); }

	const CXIndex& Get() const { return data; }
	const CXIndex& operator~() const { return data; }
	zCXIndex& operator=(const CXIndex& index) { data = index; return *this; }

	zCXTranslationUnit Create(const char *ast_filename);
	zCXTranslationUnit CreateFromSourceFile(const char *source_filename, int num_command_line_args, const char * const *command_line_args, unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files);
	zCXTranslationUnit Parse(const char *source_filename, const char * const *command_line_args, int num_command_line_args, struct CXUnsavedFile *unsaved_files, unsigned num_unsaved_files, unsigned options);
#ifdef flagLLVM_2_8 // LLVM_2_8
	zCXCodeCompleteResults CodeComplete(const char *source_filename, int num_command_line_args, const char * const *command_line_args, unsigned num_unsaved_files, struct CXUnsavedFile *unsaved_files, const char *complete_filename, unsigned complete_line, unsigned complete_column);
	void SetUseExternalASTGeneration(int value);
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
	unsigned GetGlobalOptions();
	void SetGlobalOptions(unsigned options);
	zCXIndexAction CreateIndexAction();
#endif
};

class zCXType : Moveable<zCXType> {
protected:
	CXType data;
public:
	zCXType() { }
	zCXType(const CXType& tp) : data(tp) { }

	const CXType& Get() const { return data; }
	const CXType& operator~() const { return data; }
	zCXType& operator=(const CXType& tp) { data = tp; return *this; }
	unsigned operator==(const CXType& tp) const { return clang_equalTypes(data, tp); }
	unsigned operator==(const zCXType& tp) const { return clang_equalTypes(data, ~tp); }
	unsigned operator!=(const CXType& tp) const { return !clang_equalTypes(data, tp); }
	unsigned operator!=(const zCXType& tp) const { return !clang_equalTypes(data, ~tp); }

	zCXType getCanonicalType() const;
	zCXType GetPointeeType() const;
	zCXType GetResultType() const;
	zCXCursor GetTypeDeclaration() const;
	zCXString GetTypeKindSpelling() const;
	unsigned IsPODType() const;
#ifndef flagLLVM_2_8 // LLVM_2_9
	unsigned IsConstQualifiedType() const;
	unsigned IsRestrictQualifiedType() const;
	unsigned IsVolatileQualifiedType() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	zCXType GetArrayElementType() const;
	long long GetArraySize() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
	enum CXCallingConv GetFunctionTypeCallingConv() const;
	int GetNumArgTypes() const;
	zCXType GetArgType(unsigned i) const;
	unsigned IsFunctionTypeVariadic() const;
	zCXType GetElementType() const;
	long long GetNumElements() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
	zCXString GgetTypeSpelling() const;
	long long GetAlignOf() const;
	long long GetSizeOf() const;
	long long GetOffsetOf(const char *s) const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
	zCXType GetClassType() const;
	enum CXRefQualifierKind GetCXXRefQualifier() const;
#endif
};
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
class zCXComment : Moveable<zCXComment> {
protected:
	CXComment data;
public:
	zCXComment() { }
	zCXComment(const CXComment& ct) : data(ct) { }

	const CXComment& Get() const { return data; }
	const CXComment& operator~() const { return data; }
	zCXComment& operator=(const CXComment& ct) { data = ct; return *this; }

	enum CXCommentKind GetKind() const;
	unsigned GetNumChildren() const;
	zCXComment GetChild(unsigned childIdx) const;
	unsigned IsWhitespace() const;
	unsigned InlineContentComment_hasTrailingNewline() const;
	zCXString TextComment_getText() const;
	zCXString InlineCommandComment_getCommandName() const;
	enum CXCommentInlineCommandRenderKind InlineCommandComment_getRenderKind() const;
	unsigned InlineCommandComment_getNumArgs() const;
	zCXString InlineCommandComment_getArgText(unsigned argIdx) const;
	zCXString HTMLTagComment_getTagName() const;
	unsigned HTMLStartTagComment_isSelfClosing() const;
	unsigned HTMLStartTag_getNumAttrs() const;
	zCXString HTMLStartTag_getAttrName(unsigned attrIdx) const;
	zCXString HTMLStartTag_getAttrValue(unsigned attrIdx) const;
	zCXString BlockCommandComment_getCommandName() const;
	unsigned BlockCommandComment_getNumArgs() const;
	zCXString BlockCommandComment_getArgText(unsigned argIdx) const;
	zCXComment BlockCommandComment_getParagraph() const;
	zCXString ParamCommandComment_getParamName() const;
	unsigned ParamCommandComment_isParamIndexValid() const;
	unsigned ParamCommandComment_getParamIndex() const;
	unsigned ParamCommandComment_isDirectionExplicit() const;
	enum CXCommentParamPassDirection ParamCommandComment_getDirection() const;
	zCXString TParamCommandComment_getParamName() const;
	unsigned TParamCommandComment_isParamPositionValid() const;
	unsigned TParamCommandComment_getDepth() const;
	unsigned TParamCommandComment_getIndex(unsigned depth) const;
	zCXString VerbatimBlockLineComment_getText() const;
	zCXString VerbatimLineComment_getText() const;
	zCXString HTMLTagComment_getAsString() const;
	zCXString FullComment_getAsHTML() const;
	zCXString FullComment_getAsXML() const;
};

class zCXModule : Moveable<zCXModule> {
protected:
	CXModule data;
public:
	zCXModule() { }
	zCXModule(const CXModule& module) : data(module) { }

	const CXModule& Get() const { return data; }
	const CXModule& operator~() const { return data; }
	zCXModule& operator=(const CXModule& module) { data = module; return *this; }

	zCXModule GetParent() const;
	zCXString GetName() const;
	zCXString GetFullName() const;
#ifdef flagLLVM_3_2 // LLVM_3_2
	unsigned GetNumTopLevelHeaders() const;
	CXFile GetTopLevelHeader(unsigned index) const;
#else // LLVM_3_3
	unsigned GetNumTopLevelHeaders(CXTranslationUnit tu) const;
	CXFile GetTopLevelHeader(CXTranslationUnit tu, unsigned index) const;
	CXFile GetASTFile();
#endif
};

class zCXPlatformAvailability : Moveable<zCXPlatformAvailability> {
protected:
	CXPlatformAvailability data;
public:
	zCXPlatformAvailability() { }
	zCXPlatformAvailability(const CXPlatformAvailability& availability) : data(availability) { }
	~zCXPlatformAvailability() { clang_disposeCXPlatformAvailability(&data); }

	const CXPlatformAvailability& Get() const { return data; }
	const CXPlatformAvailability& operator~() const { return data; }
	zCXPlatformAvailability& operator=(const CXPlatformAvailability& availability) { data = availability; return *this; }
};
#endif
class zCXCursor : Moveable<zCXCursor> {
protected:
	CXCursor data;
public:
	zCXCursor() { }
	zCXCursor(const CXCursor& cursor) : data(cursor) { }

	const CXCursor& Get() const { return data; }
	const CXCursor& operator~() const { return data; }
	zCXCursor& operator=(const CXCursor& cursor) { data = cursor; return *this; }

	unsigned operator==(const CXCursor& cursor) const { return clang_equalCursors(data, cursor); }
	unsigned operator==(const zCXCursor& cursor) const { return clang_equalCursors(data, ~cursor); }
	unsigned operator!=(const CXCursor& cursor) const { return !clang_equalCursors(data, cursor); }
	unsigned operator!=(const zCXCursor& cursor) const { return !clang_equalCursors(data, ~cursor); }
#ifdef flagLLVM_2_8 // LLVM_2_8
	unsigned GetHashValue() const { return String(~GetUSR()).GetHashValue(); }
#endif

	unsigned CXXMethod_isStatic() const;
	CX_CXXAccessSpecifier GetCXXAccessSpecifier() const;
	CXAvailabilityKind GetAvailability() const;
	zCXCursor GetDefinition() const;
	zCXSourceRange GetExtent() const;
	CXCursorKind GetKind() const;
	zCXString GetKindSpelling() const;
	CXLanguageKind GetLanguage() const;
	CXLinkageKind GetLinkage() const;
	zCXSourceLocation GetLocation() const;
	zCXCursor GetReferenced() const;
	zCXType GetResultType() const;
	zCXString GetSpelling() const;
	zCXType GetType() const;
	zCXString GetUSR() const;
	void GetDefinitionSpellingAndExtent(const char **startBuf, const char **endBuf, unsigned *startLine, unsigned *startColumn, unsigned *endLine, unsigned *endColumn) const;
	zCXType GetIBOutletCollectionType() const;
	zCXCursor GetSpecializedTemplate() const;
	CXCursorKind GetTemplateKind() const;
	zCXString GetTemplateKindSpelling() const;
	unsigned IsDefinition() const;
	unsigned IsVirtualBase() const;
	unsigned IsDeclaration() const;
	unsigned isExpression() const;
	unsigned IsInvalid() const;
	unsigned IsPreprocessing() const;
	unsigned IsReference() const;
	unsigned IsStatement() const;
	unsigned IsTranslationUnit() const;
	unsigned IsUnexposed() const;
	unsigned VisitChildren(CXCursorVisitor visitor, CXClientData client_data) const;
#ifndef flagLLVM_2_8 // LLVM_2_9
	unsigned GetHashValue() const { return clang_hashCursor(data); }
	zCXCursor GetCanonical() const;
	zCXString GetDeclObjCTypeEncoding() const;
	zCXString GetDisplayName() const;
	zCXCursor GetLexicalParent() const;
	zCXCursor GetSemanticParent() const;
	CXFile GetIncludedFile() const;
	unsigned GetNumOverloadedDecls() const;
	zCXCursor GetOverloadedDecl(unsigned index) const;
#ifdef __has_feature
	#if __has_feature(blocks)
	unsigned VisitChildrenWithBlock(CXCursorVisitorBlock block) const;
	#endif
#endif
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
	unsigned CXXMethod_isVirtual() const;
	zCXSourceRange GetReferenceNameRange(unsigned nameFlags, unsigned pieceIndex) const;
	int IsNull() const;
	zCXTranslationUnit GetTranslationUnit() const;
#ifdef __has_feature
	#if __has_feature(blocks)
	zCXString GetDeclObjCTypeEncoding() const;
	zCXCompletionString GetCompletionString() const;
#if flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2
	void FindReferencesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitorBlock) const;
#else // LLVM_3_3
	CXResult FindReferencesInFileWithBlock(CXFile file, CXCursorAndRangeVisitorBlock visitorBlock) const;
#endif
	#endif
#endif
#if flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2
	void FindReferencesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const;
#else // LLVM_3_3
	CXResult FindReferencesInFile(CXFile file, CXCursorAndRangeVisitor visitor) const;
#endif
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0) // LLVM_3_1
	zCXType GetTypedefDeclUnderlyingType() const;
	zCXType GetEnumDeclIntegerType() const;
	long long GetEnumConstantDeclValue() const;
	unsigned long long GetEnumConstantDeclUnsignedValue() const;
	int GetNumArguments() const;
	zCXCursor GetArgument(unsigned i) const;
	zCXSourceRange GetSpellingNameRange(unsigned pieceIndex, unsigned options) const;
	int GetObjCSelectorIndex() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2
	int GetPlatformAvailability(int *always_deprecated, CXString *deprecated_message, int *always_unavailable, CXString *unavailable_message, CXPlatformAvailability *availability, int availability_size) const;
	Vector<zCXPlatformAvailability> GetPlatformAvailability(int *always_deprecated, zCXString *deprecated_message, int *always_unavailable, zCXString *unavailable_message, int availability_size) const;
	int IsDynamicCall() const;
	zCXType GetReceiverType() const;
	zCXSourceRange GetCommentRange() const;
	zCXString GetRawCommentText() const;
	zCXString GetBriefCommentText() const;
	zCXComment GetParsedComment() const;
	zCXModule GetModule() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2) // LLVM_3_3
	int GetFieldDeclBitWidth() const;
	unsigned IsBitField() const;
	unsigned GetObjCPropertyAttributes(unsigned reserved = 0) const;
	unsigned GetObjCDeclQualifiers() const;
	unsigned IsVariadic() const;
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
	unsigned IsObjCOptional() const;
	unsigned CXXMethod_isPureVirtual() const;
#endif
};
#ifndef flagLLVM_2_8 // LLVM_2_9
class zCXCursorSet : Moveable<zCXCursorSet> {
protected:
	CXCursorSet data;
public:
	zCXCursorSet() : data(clang_createCXCursorSet()) { }
	~zCXCursorSet() { clang_disposeCXCursorSet(data); }

	const CXCursorSet& Get() const { return data; }
	const CXCursorSet& operator~() const { return data; }
	zCXCursorSet& operator=(const CXCursorSet& set) { data = set; return *this; }

	unsigned Contains(CXCursor cursor) const;
	unsigned Insert(CXCursor cursor) const;
};

class zCXOverriddenCursors : Moveable<zCXOverriddenCursors> {
protected:
	CXCursor *data;
	unsigned count;
public:
	zCXOverriddenCursors() { }
	zCXOverriddenCursors(const CXCursor& cursor) {	clang_getOverriddenCursors(cursor, &data, &count); }
	zCXOverriddenCursors(const zCXCursor& cursor) {	clang_getOverriddenCursors(~cursor, &data, &count); }
	~zCXOverriddenCursors() { clang_disposeOverriddenCursors(data); }

	CXCursor *Get() const { return data; }
	CXCursor *operator~() const { return data; }
	CXCursor Get(unsigned index) const { return data[index]; }
	CXCursor operator[](unsigned index) const { return data[index]; }
	unsigned GetCount() const { return count; }
};
#endif
#if !(flagLLVM_2_8 || flagLLVM_2_9) // LLVM_3_0
class zCXRemapping : Moveable<zCXRemapping> {
protected:
	CXRemapping data;
public:
	zCXRemapping() { }
	zCXRemapping(const CXRemapping& remapping) : data(remapping) { }
	~zCXRemapping() { clang_remap_dispose(data); }

	const CXRemapping& Get() const { return data; }
	const CXRemapping& operator~() const { return data; }
	zCXRemapping& operator=(const CXRemapping& remapping) { data = remapping; return *this; }

	unsigned GetNumFiles() const;
	void GetFilenames(unsigned index, CXString *original, CXString *transformed);
	void GetFilenames(unsigned index, zCXString& original, zCXString& transformed);
};
#endif

#include "Utilities.h"
#include "CompilationDatabase.h"

END_UPP_NAMESPACE

#endif
