#ifndef _ClangBase_CompilationDatabase_h_
#define _ClangBase_CompilationDatabase_h_
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1) // LLVM_3_2

#include <clang-c/CXCompilationDatabase.h>

class zCXCompileCommand : Moveable<zCXCompileCommand> {
protected:
	CXCompileCommand data;
public:
	zCXCompileCommand() { }
	zCXCompileCommand(const CXCompileCommand& cmd) : data(cmd) { }

	const CXCompileCommand& Get() const { return data; }
	const CXCompileCommand& operator~() const { return data; }
	zCXCompileCommand& operator=(const CXCompileCommand& cmd) { data = cmd; return *this; }

	zCXString GetDirectory() const;
	unsigned GetNumArgs() const;
	zCXString GetArg(unsigned i) const;
#if !(flagLLVM_2_8 || flagLLVM_2_9 || flagLLVM_3_0 || flagLLVM_3_1 || flagLLVM_3_2 || flagLLVM_3_3) // LLVM_3_4
	unsigned GetNumMappedSources() const;
	zCXString GetMappedSourcePath(unsigned i) const;
	zCXString GetMappedSourceContent(unsigned i) const;
#endif
};

class zCXCompileCommands : Moveable<zCXCompileCommands> {
protected:
	CXCompileCommands data;
public:
	zCXCompileCommands() { }
	zCXCompileCommands(const CXCompileCommands& cmd) : data(cmd) { }
	~zCXCompileCommands() { clang_CompileCommands_dispose(data); }

	const CXCompileCommands& Get() const { return data; }
	const CXCompileCommands& operator~() const { return data; }
	zCXCompileCommands& operator=(const CXCompileCommands& cmd) { data = cmd; return *this; }

	unsigned GetSize(CXCompileCommands) const;
	zCXCompileCommand GetCommand(unsigned i) const;
};

class zCXCompilationDatabase : Moveable<zCXCompilationDatabase> {
protected:
	CXCompilationDatabase data;
public:
	zCXCompilationDatabase() { }
	zCXCompilationDatabase(const char *buildDir, CXCompilationDatabase_Error *errorCode) :
		data(clang_CompilationDatabase_fromDirectory(buildDir, errorCode)) { }

	zCXCompilationDatabase(const CXCompilationDatabase& base) : data(base) { }
	~zCXCompilationDatabase() { clang_CompilationDatabase_dispose(data); }

	const CXCompilationDatabase& Get() const { return data; }
	const CXCompilationDatabase& operator~() const { return data; }
	zCXCompilationDatabase& operator=(const CXCompilationDatabase& base) { data = base; return *this; }

	zCXCompileCommands GetCompileCommands(const char *completeFileName) const;
#ifndef flagLLVM_3_2 // LLVM_3_3
	zCXCompileCommands GetAllCompileCommands() const;
#endif
};

#endif
#endif
