#include <CtrlLib/CtrlLib.h>

using namespace Upp; 

#define IMAGECLASS DotSplitterImage
#define IMAGEFILE <DotSplitter/DotSplitter.iml>
#include <Draw/iml.h>
#include <DotSplitter/DotSplitter.h>

DotSplitter::DotSplitter() { 
	static Splitter::Style spstyle = Splitter::StyleDefault() ;
	spstyle.width = 15;	
	SetStyle(spstyle);
	//BarWidth(5);
	currstate = lastindex = 0;
}

void DotSplitter::LeftDouble(Point p, dword keyflags)
{
	switch (currstate){
		case 0:
			{
				lastindex = FindIndex(p);
				if (lastindex<0)
					break;
				isCtrlKey = (keyflags & K_CTRL);
				pos_backup.Clear();
				pos_backup.Append(pos);
				lastpos= this->GetPos(lastindex);
				bool isShiftKey = (keyflags & K_SHIFT);
				
				a = isShiftKey ? 10000 : 0;
				b = 10000 - a;
				if (isCtrlKey){
					SetPos(a, lastindex);
					currstate = -1;
				} else {
					if (isShiftKey){
						for(int i = pos.GetCount() -1; i >= 0; i--) 
							SetPos(	( (i<lastindex) ? 0 : ((i==lastindex) ? a : 10000 ) )	,i);
					} else {
						for(int i = 0; i < pos.GetCount(); i++) 
							SetPos(	( (i<lastindex) ? 0 : ((i==lastindex) ? a : 10000 ) )	,i);
					}
					currstate = 1;
				}
				WhenAction();
			}
			break;
		case -1:
			{
				currstate= 1;
				SetPos(b, lastindex);
				WhenAction();
			}
			break;
		case 1:
			{
				currstate = 0;
				if (isCtrlKey){
					SetPos(lastpos, lastindex);
				} else {
					pos.Clear();
					pos.Append(pos_backup);
					Layout();
				}
				WhenAction();
			}
			break;
	}
}
void DotSplitter::Paint(Draw& w) {
	Splitter::Paint(w);
	Size sz = GetSize();
	//w.DrawRect(GetRect(),Yellow());
	for(int i = 0; i < (GetCount()-1); i++) {
		if (vert)
			w.DrawImage((sz.cx-149)/2,GetPos(i)*sz.cy/10000-2,DotSplitterImage::SplitterCenter());
		else 
			w.DrawImage(GetPos(i)*sz.cx/10000-2,(sz.cy-149)/2,DotSplitterImage::SplitterCenterV());
	}
}
