/*
Project:			CmdLineArgs
File:				ArgcArgv.cpp
File version:		V1.1.0
Date:				2007-02-05
Ultimate++ version:	Ultimate++ 2007.1beta3
Code:				Werner Wenzel (public domain)
Comments:			Werner Wenzel (public domain)

This application demonstrates how to create and use the two parameters
of the standard C++ main function "int main(int argc, char* argv[])"
under Ultimate++.

To use this facility

1. add "ArgcArgv.hpp" and "ArgcArgv.cpp" to your project,
2. include "ArgcArgv.hpp" at the very beginning of your file containing "GUI_APP_MAIN",
3. add "ArgcArgv(argc, argv);" as the first line of code below "GUI_APP_MAIN {".

This file defines the central setup function "ArgcArgv" and the clearup function
"ResetHeap". As the data is stored on the heap the second function is automatically
called to reset the heap when the application terminates normally.
*/

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

// command line argument count defined in ArgcArgv.hpp
extern int argc;
// command line argument vector defined in ArgcArgv.hpp
extern char** argv;

// reset heap when application terminates normally
void ResetHeap()
{
	// release heap for all arguments
	for (int i = 0; i < argc; ++i)
		delete[] argv[i];
	// release heap for argument pointers
	delete[] argv;
}

// function definition to create argc and argv	
int ArgcArgv(int& argc, char**& argv)
{
	// make arguments easily accessible
	const Vector<String>& arguments = CommandLine();
	// count arguments and standardize argument count representation
	argc = arguments.GetCount();
	// C++ standard expects the application title as argv[0]
	++argc;
	// create char pointers to application title, arguments, and NULL
	argv = new char*[argc + 1];
	
	// get application name
	String app_name = Ctrl::GetAppName();
	// length of current argument
	int an_argument_length;
	// get length of app_name
	an_argument_length = app_name.GetLength();
	// allocate heap for app_name converted to char[]
	argv[0] = new char[an_argument_length + 1];
	// make const String behave as const char[]
	const char* a_const_argument = app_name;
	// convert const char[] to char[]
	char* target = argv[0];
	while (*target++ = *a_const_argument++);
		
	// standardize argument representation
	for (int i = 0; i < argc - 1; ++i)
	{
		// get length of current argument
	    an_argument_length = arguments[i].GetLength();
	    // allocate heap for current argument converted to char[]
	    argv[i + 1] = new char[an_argument_length + 1];
	    // make const String behave as const char[]
	    a_const_argument = arguments[i];
	    // convert const char[] to char[]
	    target = argv[i + 1];
	    while (*target++ = *a_const_argument++);
	}
	
	// C++ standard expects argv[argc] == (char*)0
	argv[argc] = (char*)0;
	// register function to reset the heap when main returns
	atexit(ResetHeap);
	// return number of command line arguments
	return argc;
}
