/*
Project:			CmdLineArgs
File:				ArgcArgv.hpp
File version:		V1.1.0
Date:				2007-02-05
Ultimate++ version:	Ultimate++ 2007.1beta3
Code:				Werner Wenzel (public domain)
Comments:			Werner Wenzel (public domain)

This application demonstrates how to create and use the two parameters
of the standard C++ main function "int main(int argc, char* argv[])"
under Ultimate++.

To use this facility

1. add "ArgcArgv.hpp" and "ArgcArgv.cpp" to your project,
2. include "ArgcArgv.hpp" at the very beginning of your file containing "GUI_APP_MAIN",
3. add "ArgcArgv(argc, argv);" as the first line of code below "GUI_APP_MAIN {".

This file defines the two global variables "argc" und "argv" and declares the central
setup function "ArgcArgv". The file should be included only in the file containing
"GUI_APP_MAIN", usually "main.cpp".
*/

#ifndef ARGC_ARGV_H
#define ARGC_ARGV_H

// command line argument count
int argc;
// command line argument vector
char** argv;

// function declaration to create argc and argv	
int ArgcArgv(int& argc, char**& argv);

#endif
