/*
Project:			CmdLineArgs
File:				CmdLineArgs.h
File version:		V1.1.0
Date:				2007-02-05
Ultimate++ version:	Ultimate++ 2007.1beta3
Code:				Werner Wenzel (public domain)
Comments:			Werner Wenzel (public domain)

This application demonstrates how to create and use the two parameters
of the standard C++ main function "int main(int argc, char* argv[])"
under Ultimate++.

To use this facility

1. add "ArgcArgv.hpp" and "ArgcArgv.cpp" to your project,
2. include "ArgcArgv.hpp" at the very beginning of your file containing "GUI_APP_MAIN",
3. add "ArgcArgv(argc, argv);" as the first line of code below "GUI_APP_MAIN {".

This file initializes the layout of the demo application and just creates a rectangle
in which the command line arguments are listed.
CAUTION: For the sake of simplicity no scrolling, so keep the number of the arguments limited!
*/

#ifndef _CmdLineArgs_CmdLineArgs_h
#define _CmdLineArgs_CmdLineArgs_h

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#define LAYOUTFILE <CmdLineArgs/CmdLineArgs.lay>
#include <CtrlCore/lay.h>

class CmdLineArgs : public WithCmdLineArgsLayout<TopWindow>
{
private:
    virtual void Paint(Draw& w)
    {
    	String text;

    	w.DrawRect(GetSize(), WhiteGray);
   		w.DrawText(10, 10, "argc: " + AsString(argc), Courier(12), Black);
    	for (int i = 0; i < argc; ++i)
    	{
    		text = Format("argv[%i] = %s", i, argv[i]);
    		w.DrawText(10, 50 + i * 15, text, Courier(12), Black);
    	}
    }
    
public:
	typedef CmdLineArgs CLASSNAME;
	CmdLineArgs();
};

#endif

