/*
Project:			CmdLineArgs
File:				main.cpp
File version:		V1.1.0
Date:				2007-02-05
Ultimate++ version:	Ultimate++ 2007.1beta3
Code:				Werner Wenzel (public domain)
Comments:			Werner Wenzel (public domain)

This application demonstrates how to create and use the two parameters
of the standard C++ main function "int main(int argc, char* argv[])"
under Ultimate++.

To use this facility

1. add "ArgcArgv.hpp" and "ArgcArgv.cpp" to your project,
2. include "ArgcArgv.hpp" at the very beginning of your file containing "GUI_APP_MAIN",
3. add "ArgcArgv(argc, argv);" as the first line of code below "GUI_APP_MAIN {".

This file follows the instructions #2 and #3 above.
*/

#include "ArgcArgv.hpp"						// 1st line to include
#include "CmdLineArgs.h"

CmdLineArgs::CmdLineArgs()
{
	CtrlLayoutOK(*this, "CmdLineArgs");
}

GUI_APP_MAIN
{
	ArgcArgv(argc, argv);					// 2nd line to include	
	CmdLineArgs().Run();
}

