#ifndef _SERIAL_H
#define _SERIAL_H

#ifdef flagPOSIX
	#include <termios.h>
	typedef struct
	{
	    int32_t portHandle;
	    struct termios options;
	    struct termios optionsOld;
	} serialPort_t;
#else /* !__linux__ */
	#define _WINSOCKAPI_
	#include <windows.h>
	typedef __int32 int32_t;
	typedef unsigned __int32 uint32_t;
	typedef __int16 int16_t;
	typedef unsigned __int16 uint16_t;
	typedef __int8 int8_t;
	typedef unsigned __int8 uint8_t;
	typedef struct
	{
	    HANDLE portHandle;
	    DCB options;
	    DCB optionsOld;
	} serialPort_t;
#endif /* __linux__ */

typedef enum
{
    SERIAL_OK = 0,
    SERIAL_FAIL,
    SERIAL_TIMEOUT,
    SERIAL_WRITE_INCOMPLETE,
    SERIAL_BAD_PARITY,
    SERIAL_BAD_DATABITS,
    SERIAL_BAD_STOPBITS,
    SERIAL_BAD_BAUD,
    SERIAL_NOT_IMPLEMENTED
} serialError_t;

serialError_t SerialOpen(serialPort_t *port, const char *name);
serialError_t SerialClose(serialPort_t *port);
serialError_t SerialSettings(serialPort_t *port, uint32_t baud, char parity,
                             uint8_t dataBits, uint8_t stopBits,
                             int32_t timeout_tenths);
serialError_t SerialTimeouts(serialPort_t *port, int32_t timeout_tenths);
serialError_t SerialRead(serialPort_t *port, uint8_t *data, int32_t size, int32_t *bytesRead);
serialError_t SerialWrite(serialPort_t *port, const uint8_t *data, int32_t size, int32_t *bytesWritten);
serialError_t SerialEnumerate(void);

#endif /* !_SERIAL_H */
