#ifndef _mt_Utils_h_
#define _mt_Utils_h_

#include <Core/Core.h>
#include <Web/Web.h>

String Encrypt(const String &src, const String &pass);
String Decrypt(const String &src, const String &pass);
int64 ToJSTime(const Time &);
Time  FromJSTime(int64);

struct HTMLFilter
{
	enum ATTR_CONVERT
	{
		ATTR_CONVERT_AS_IS,
		ATTR_CONVERT_AS_SPAN,
		ATTR_CONVERT_REMOVE,
		ATTR_CONVERT_NO_CAPTION,
		ATTR_CONVERT_IMG,
		ATTR_CONVERT_LINK
	};
	VectorMap<String, VectorMap<String, int> > tags;
	VectorMap<String, int> styles;
};
const HTMLFilter & GetHTMLFilter(bool init = false);
String ConvertTextToUtf8(const String &_text, bool filterTags, bool isConvertAnyway = false);
String SafeguardHTML(const String &s, bool convertUtf8 = true);
String SafeguardPlain(const String &s, bool convertUtf8 = true);

bool ParseFormData(
	Socket                   &socket, 
	dword                     timeout, 
	const String             &contentType, 
	const String             &dir,
	bool                      isFieldsListOnly, 
	VectorMap<String,String> &fields, 
	VectorMap<String,String> &files,
	const int                 maxFileSize = 100*1024*1024
	);

#endif
